/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.print.Config;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class GeneralPurposePreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_GeneralPurpose";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected GeneralPurposePreferences(HashStructure hash) {
        super(hash);
    }

    public static GeneralPurposePreferences getInstance(PropertyStorage prefs) {
        return new GeneralPurposePreferences(GeneralPurposePreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setLastExportFolder(String lastExportFolder) {
        this._hash.putString("last_export_folder", lastExportFolder);
    }

    public String getLastExportFolder() {
        return this._hash.getString("last_export_folder");
    }

    public String getLastOpenDesign() {
        return this._hash.getString("last_open_design");
    }

    public void setLastOpenDesign(String lastOpenDesign) {
        this._hash.putString("last_open_design", lastOpenDesign);
    }

    public String getDefaultDDLFilesPath() {
        return this._hash.getString("def_ddl_files_path");
    }

    public void setDefaultDDLFilesPath(String defaultDDLFilesPath) {
        this._hash.putString("def_ddl_files_path", defaultDDLFilesPath);
    }

    public void setIncludeDesNameInDDLFilesPath(boolean value) {
        this._hash.putBoolean("incl_des_name_in_ddl_files_path", value);
    }

    public boolean getIncludeDesNameInDDLFilesPath() {
        return this._hash.getBoolean("incl_des_name_in_ddl_files_path");
    }

    public void setCreateDateTimeSnapshot(boolean value) {
        this._hash.putBoolean("create_datetime_snapshot", value);
    }

    public boolean getCreateDateTimeSnapshot() {
        return this._hash.getBoolean("create_datetime_snapshot");
    }

    public String getLastOpenDPV() {
        return this._hash.getString("last_open_dpv");
    }

    public void setLastOpenDPV(String lastOpenDPV) {
        this._hash.putString("last_open_dpv", lastOpenDPV);
    }

    public boolean getAutoJoinOnFK() {
        return this._hash.getBoolean("autoJoinOnFK");
    }

    public void setAutoJoinOnFK(boolean value) {
        this._hash.putBoolean("autoJoinOnFK", value);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void setPrinterName(String name) {
        this._hash.putString("printer_name", name);
    }

    public String getPrinterName() {
        return this._hash.getString("printer_name");
    }

    public void setPaperMediaName(String paperMediaName) {
        this._hash.putString("paper_media_name", paperMediaName);
    }

    public String getPaperMediaName() {
        return this._hash.getString("paper_media_name");
    }

    public void setPageOrientation(int value) {
        this._hash.putInt("page_orientation", value);
    }

    public int getPageOrientation() {
        return this._hash.getInt("page_orientation");
    }

    public void setPageWidth(double value) {
        this._hash.putDouble("page_width", value);
    }

    public double getPageWidth() {
        return this._hash.getDouble("page_width");
    }

    public void setPageHeight(double value) {
        this._hash.putDouble("page_height", value);
    }

    public double getPageHeight() {
        return this._hash.getDouble("page_height");
    }

    public void setPageMarginX(double value) {
        this._hash.putDouble("page_margin_x", value);
    }

    public double getPageMarginX() {
        return this._hash.getDouble("page_margin_x");
    }

    public void setPageMarginY(double value) {
        this._hash.putDouble("page_margin_y", value);
    }

    public double getPageMarginY() {
        return this._hash.getDouble("page_margin_y");
    }

    public void setPageMarginWidth(double value) {
        this._hash.putDouble("page_margin_width", value);
    }

    public double getPageMarginWidth() {
        return this._hash.getDouble("page_margin_width");
    }

    public void setPageMarginHeight(double value) {
        this._hash.putDouble("page_margin_height", value);
    }

    public double getPageMarginHeight() {
        return this._hash.getDouble("page_margin_height");
    }

    public Boolean getUsePreferredLogicalTypes() {
        return this._hash.getBoolean("use_preferred_logical_types");
    }

    public void setUsePreferredLogicalTypes(boolean usePreferredLogicalTypes) {
        this._hash.putBoolean("use_preferred_logical_types", usePreferredLogicalTypes);
    }

    public void loadToSettings(Settings settings, ApplicationView appView) {
        if (this.contains("last_export_folder")) {
            settings.setLastExportFolder(this.getLastExportFolder());
        }
        if (this.contains("last_open_design")) {
            settings.setLastOpenDesign(this.getLastOpenDesign());
        }
        if (this.contains("last_open_dpv")) {
            settings.setLastOpenDPV(this.getLastOpenDPV());
        }
        if (this.contains("autoJoinOnFK")) {
            settings.setAutoJoinOnFK(this.getAutoJoinOnFK());
        }
        if (this.contains("def_ddl_files_path")) {
            settings.setDefaultDDLFilesPath(this.getDefaultDDLFilesPath());
        }
        if (this.contains("incl_des_name_in_ddl_files_path")) {
            settings.setIncludeDesgnNameInDDLPath(this.getIncludeDesNameInDDLFilesPath());
        }
        if (this.contains("create_datetime_snapshot")) {
            settings.setCreateDateTimeSnapshot(this.getCreateDateTimeSnapshot());
        }
        if (this.contains("use_preferred_logical_types")) {
            settings.setUsePreferredLogicalTypes(this.getUsePreferredLogicalTypes());
        }
        if (this.contains("page_orientation") && this.contains("page_width") && this.contains("page_height") && this.contains("page_margin_x") && this.contains("page_margin_y") && this.contains("page_margin_width") && this.contains("page_margin_height")) {
            PageFormat pf = new PageFormat();
            pf.setOrientation(this.getPageOrientation());
            Paper paper = new Paper();
            paper.setSize(this.getPageWidth(), this.getPageHeight());
            paper.setImageableArea(this.getPageMarginX(), this.getPageMarginY(), this.getPageMarginWidth(), this.getPageMarginHeight());
            pf.setPaper(paper);
            settings.setPageFormat(pf);
            Config.getConfig().init(pf, this.getPrinterName(), this.getPaperMediaName());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

