/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.view.AbstractPinnable;
import oracle.ide.view.View;

public class SearchDockable
extends AbstractPinnable {
    public static final String VIEW_TYPE = "DM_SEARCH";
    private final DockStation dockStation = DockStation.getDockStation();
    private HelpInfo helpInfo;
    private SearchPanel _gui;
    private int viewSequence;

    public SearchDockable(ViewId vID) {
        super(vID.getId());
        this.viewSequence = Integer.valueOf(vID.getName());
        DockingParam dp = new DockingParam();
        dp.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
        this.dockStation.dock((Dockable)this, dp);
    }

    public final Component getGUI() {
        if (this._gui == null) {
            this._gui = this.createGUI();
        }
        return this._gui;
    }

    public Icon getTabIcon() {
        return Icons.getSearchIcon();
    }

    protected SearchPanel createGUI() {
        SearchPanel gui = new SearchPanel();
        gui.createGUI();
        return gui;
    }

    public String getTitleName() {
        if (this._gui != null) {
            if (this._gui.getCurrentModel() != null) {
                return this._gui.getCurrentModel().getName() + " (" + this._gui.getCurrentModel().getDesign().getName() + ")";
            }
            return Messages.getString("SearchDockable.Find");
        }
        return Messages.getString("SearchDockable.Find");
    }

    protected boolean isViewSupported(View view) {
        return true;
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo == null) {
            this.helpInfo = new HelpInfo("FIND_DIALOG");
        }
        return this.helpInfo;
    }

    public SearchPanel get_gui() {
        return this._gui;
    }

    public int getViewSequence() {
        return this.viewSequence;
    }

    public void closeView(SearchDockable sd) {
        try {
            sd.setPinState(0);
            ((SearchPanel)sd.getGUI()).clearOnCloseDesign();
            this.dockStation.close((Dockable)sd);
            this._gui = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deactivate() {
        super.deactivate();
    }
}

