/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class XMLAExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(200, 20);
    private JTextField tfCatalog;
    private JComboBox cbMDM;
    private Design design;
    private MultidimensionalDesign multidimensionalDesign;
    private String catalog = "";

    public XMLAExportOptions(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = appView.getCurrentDesign();
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(""));
        JLabel lbFormula = new JLabel(Messages.getString("XMLAExportOptions.DatabaseName"));
        lbFormula.setPreferredSize(this.prefDimension);
        this.tfCatalog = new JTextField(appView.getDesignName());
        this.tfCatalog.setPreferredSize(this.prefDimension);
        JPanel row = this.newRow(lbFormula, this.tfCatalog);
        optionsPanel.add(row);
        MultidimensionalDesign mdm = this.design.getMultidimensionalDesign();
        JLabel lbMDM = new JLabel(Messages.getString("XMLAExportOptions.DimensionalModel"));
        lbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(mdm);
        row = this.newRow(lbMDM, this.cbMDM);
        optionsPanel.add(row);
        JPanel bottom = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(Messages.getString("XMLAExportOptions.OK"));
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLAExportOptions.this.result = XMLAExportOptions.this.checkSettings();
                if (XMLAExportOptions.this.result) {
                    XMLAExportOptions.this.close();
                }
            }
        });
        bottom.add(okButton);
        JButton cancelButton = new JButton(Messages.getString("XMLAExportOptions.Cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLAExportOptions.this.result = false;
                XMLAExportOptions.this.close();
            }
        });
        bottom.add(cancelButton);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bottom.add(bnHelp);
        okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)optionsPanel, "Center");
        jpanel.add((Component)bottom, "South");
        this.add(jpanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("XMLAExportOptions.XMLAExportOptions"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_XMLA_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkSettings() {
        this.catalog = this.tfCatalog.getText();
        if ("".equalsIgnoreCase(this.catalog)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExportOptions.YouHveToSpecifyDatabaseName"), Messages.getString("XMLAExportOptions.Warning"), 2);
            return false;
        }
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }
}

