/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.GUID;

public class RSLogicalTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        LongNameObject type;
        ArrayList list = new ArrayList(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_LOGICAL_TYPES (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, OVID, LT_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = design.getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            type = (LogicalDatatype)it.next();
            String ovid = new GUID().toString();
            map.put(((ModelIDObject)type).getObjectID(), ovid);
            stmt.setString(1, design.getObjectID());
            stmt.setString(2, designOVID);
            stmt.setString(3, design.getName());
            stmt.setString(4, ((ModelIDObject)type).getObjectID());
            stmt.setString(5, ovid);
            stmt.setString(6, ((DesignObject)type).getName());
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_LOGICAL_TO_NATIVE (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, Logical_Type_OVID, LT_Name, Native_Type, RDBMS_Type, RDBMS_Version, Has_Size, Has_Precision, Has_Scale) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        it = design.getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            LogicalDatatype ldt = (LogicalDatatype)it.next();
            String ltOVID = (String)map.get(ldt.getObjectID());
            Map<String, String> m = ldt.getToPhysical();
            Iterator tit = Design.getDefaultRDBMSTypeSet().iterator();
            while (tit.hasNext()) {
                RDBMSType type2 = (RDBMSType)tit.next();
                MDDataType mdt = ldt.createDataType(type2.getName(), m);
                if (mdt == null) continue;
                stmt.setString(1, design.getObjectID());
                stmt.setString(2, designOVID);
                stmt.setString(3, design.getName());
                stmt.setString(4, ldt.getObjectID());
                stmt.setString(5, ltOVID);
                stmt.setString(6, ldt.getName());
                stmt.setString(7, mdt.getName());
                stmt.setString(8, type2.getProductName());
                stmt.setString(9, type2.getVersionName());
                stmt.setString(10, mdt.hasSize() && RSLogicalTypes.hasSize(mdt.getSize()) ? "Y" : "N");
                stmt.setString(11, mdt.hasPrecision() && mdt.getPrecision() > 0 ? "Y" : "N");
                stmt.setString(12, mdt.hasScale() && mdt.getScale() > 0 ? "Y" : "N");
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_NATIVE_TO_LOGICAL (RDBMS_Type, RDBMS_Version, Native_Type, LT_Name, Logical_Type_ID, Logical_Type_OVID, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        it = design.getDefaultRDBMSTypeSet().iterator();
        while (it.hasNext()) {
            type = (RDBMSType)it.next();
            String[] dataTypes = StandardDatatypeNames.getAllPossibleDatatypes((RDBMSType)type);
            for (int j = 0; j < dataTypes.length; ++j) {
                String dt = dataTypes[j];
                if (dt.equalsIgnoreCase("UNKNOWN")) continue;
                String usedtype = StandardDatatypeNames.getUsedDatatypeName(dt);
                if (!dt.equals(usedtype = StandardDatatypeNames.getTransformedDatatypeName(usedtype, (RDBMSType)type))) continue;
                LogicalDatatype ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype((RDBMSType)type, usedtype);
                if (ltype == null) {
                    ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype((RDBMSType)type, dt);
                }
                if (ltype == null) continue;
                stmt.setString(1, ((RDBMSType)type).getProductName());
                stmt.setString(2, ((RDBMSType)type).getVersionName());
                stmt.setString(3, dt);
                stmt.setString(4, ltype.getName());
                stmt.setString(5, ltype.getObjectID());
                stmt.setString(6, (String)map.get(ltype.getObjectID()));
                stmt.setString(7, design.getObjectID());
                stmt.setString(8, designOVID);
                stmt.setString(9, design.getName());
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }

    private static boolean hasSize(String size) {
        if (size != null && !"".equalsIgnoreCase(size)) {
            return !"0".equalsIgnoreCase(size);
        }
        return false;
    }
}

