/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSColumnGroups
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_COLUMN_GROUPS (Table_ID, Table_OVID, Sequence, ColumnGroup_ID, ColumnGroup_OVID, ColumnGroup_Name, Columns, Notes, Table_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = table.getColumnGroupsSet().iterator();
        int seq = 0;
        while (it.hasNext()) {
            Table.ColumnGroup cg = (Table.ColumnGroup)it.next();
            stmt.setString(1, table.getObjectID());
            stmt.setString(2, (String)map.get(table.getObjectID()));
            stmt.setInt(3, ++seq);
            stmt.setString(4, cg.getObjectID());
            stmt.setString(5, RSColumnGroups.getOrCreateOVID(map, cg.getObjectID()));
            stmt.setString(6, cg.getName());
            stmt.setString(7, RSColumnGroups.getColumns(cg, table));
            stmt.setString(8, cg.getNote());
            stmt.setString(9, table.getName());
            stmt.setString(10, (String)map.get(table.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }

    private static String getColumns(Table.ColumnGroup cg, Table table) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = cg.getColumns().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String columnID = it.next();
            ContainedObject column = table.getElementByID(columnID);
            if (column == null) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(column.getName());
        }
        return sb.toString();
    }
}

