/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;
    public static final String PAGESIZE = "PAGESIZE";
    public static final String MANAGED_BY = "MANAGED BY";
    public static final String AUTORESIZE = "AUTORESIZE";
    public static final String INITIALSIZE = "INITIALSIZE";
    public static final String INCREASESIZE = "INCREASESIZE";
    public static final String MAXSIZE = "MAXSIZE";
    public static final String EXTENTSIZE = "EXTENTSIZE";
    public static final String PREFETCHSIZE = "PREFETCHSIZE";
    public static final String OVERHEAD = "OVERHEAD";
    public static final String TRANSFERRATE = "TRANSFERRATE";
    public static final String DROPPED_TABLE_RECOVERY = "DROPPED TABLE RECOVERY";
    public static final String FILE_SYSTEM_CACHING = "FILE SYSTEM CACHING";
    public static final String NO_FILE_SYSTEM_CACHING = "NO FILE SYSTEM CACHING";
    public static final String ON_DBPARTITIONNUM = "ON DBPARTITIONNUM";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceUDBv81 && ((TableSpaceUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableSpaceUDBv81 tablespace = (TableSpaceUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (!tablespace.getDBDefOnly()) {
            this.appendComment(buffer, tablespace);
            this.appendCreate(buffer, tablespace);
            this.appendNodeGroup(buffer, tablespace, prettyPrint);
            this.appendPageSize(buffer, tablespace, prettyPrint);
            this.appendManagedBy(buffer, tablespace);
            this.appendUsingContainer(buffer, tablespace, prettyPrint);
            this.appendExtentSize(buffer, tablespace, prettyPrint);
            this.appendPrefetchSize(buffer, tablespace, prettyPrint);
            this.appendBufferPool(buffer, tablespace, prettyPrint);
            this.appendOverhead(buffer, tablespace, prettyPrint);
            this.appendTransferRate(buffer, tablespace, prettyPrint);
            this.appendDroppedTableRecovery(buffer, tablespace, prettyPrint);
            this.appendFileSystemCaching(buffer, tablespace, prettyPrint);
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv81.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTablespace();
            if (tablespace.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(buffer, tablespace, prettyPrint);
            }
        }
        this.appendUsePrivileges(buffer, tablespace, prettyPrint);
    }

    private StorageDesignUDB getTSStorageDesign(Object tablespace) {
        if (this.storageDesign == null) {
            this.storageDesign = (StorageDesignUDB)this.getStorageDesign(tablespace);
        }
        return this.storageDesign;
    }

    private void appendCommentOn(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        String commentOn = tablespace.getCommentInRDBMS().trim();
        if (!"".equalsIgnoreCase(commentOn)) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, this.getTSStorageDesign(tablespace).getFormatedName(tablespace.getLongNameDDL()));
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IS");
            SSBTableSpaceUDBv81.appendString(buffer, '\'');
            SSBTableSpaceUDBv81.appendString(buffer, commentOn);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, '\'');
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv81.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendCreate(StringBuffer buffer, TableSpaceUDBv81 tablespace) {
        this.appendCreate(buffer);
        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getDataType());
        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, this.getTSStorageDesign(tablespace).getFormatedName(tablespace.getName()));
    }

    protected void appendNodeGroup(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            if (tablespace.getNodeGroup() != null) {
                SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IN");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "DATABASE");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "PARTITION");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "GROUP");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, this.getTSStorageDesign(tablespace).getFormatedName(tablespace.getNodeGroup().getName()));
            } else if (this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IN");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "DATABASE");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "PARTITION");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "GROUP");
                if (!tablespace.getDataType().equalsIgnoreCase("SYSTEM TEMPORARY")) {
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IBMDEFAULTGROUP");
                } else {
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IBMTEMPGROUP");
                }
            }
        }
    }

    protected void appendPageSize(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (tablespace.getPageSize() > 0 && this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, PAGESIZE);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getPageSize());
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, 'K');
        }
    }

    protected void appendManagedBy(StringBuffer buffer, TableSpaceUDBv81 tablespace) {
        if (this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, MANAGED_BY);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getManagedBy());
            if (!"".equals(tablespace.getAutoResize())) {
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, AUTORESIZE);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getAutoResize());
            }
            if (!"".equals(tablespace.getInitialSize())) {
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, INITIALSIZE);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getInitialSize());
            }
            if (!"".equals(tablespace.getIncreaseSize())) {
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, INCREASESIZE);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getIncreaseSize());
            }
            if (!"".equals(tablespace.getMaxSize())) {
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, MAXSIZE);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getMaxSize());
            }
        }
    }

    protected void appendExtentSize(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tablespace.getExtentSize()) && this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, EXTENTSIZE);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getExtentSize());
        }
    }

    protected void appendPrefetchSize(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tablespace.getPrefetchSize()) && this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, PREFETCHSIZE);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, tablespace.getPrefetchSize());
        }
    }

    protected void appendBufferPool(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            if (tablespace.getBufferPool() != null) {
                SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "BUFFERPOOL");
                this.appendStringWithSpace(buffer, tablespace.getBufferPool());
            } else if (this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "BUFFERPOOL");
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "IBMDEFAULTBP");
            }
        }
    }

    protected void appendOverhead(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (tablespace.getOverhead() > 0.0f && this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, OVERHEAD);
            this.appendStringWithSpace(buffer, tablespace.getOverhead());
        }
    }

    protected void appendTransferRate(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (tablespace.getTransferRate() > 0.0f && this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, TRANSFERRATE);
            this.appendStringWithSpace(buffer, tablespace.getTransferRate());
        }
    }

    protected void appendDroppedTableRecovery(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (tablespace.getDataType().equalsIgnoreCase("REGULAR")) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, DROPPED_TABLE_RECOVERY);
            this.appendOnOffWithSpace(buffer, tablespace.getDroppedTableRecovery());
        }
    }

    protected void appendFileSystemCaching(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        if (!tablespace.getFileSystemCaching()) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, NO_FILE_SYSTEM_CACHING);
        } else {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, FILE_SYSTEM_CACHING);
        }
    }

    protected void appendUsingContainer(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        block6: {
            ContainerUDB[] containers = tablespace.getContainers();
            if (containers.length <= 0 || !this.getTSStorageDesign(tablespace).getAppView().getSettings().isIncludeStorageInDDL()) break block6;
            List allNodes = tablespace.getAllNodes();
            if (tablespace.getManagedBy().equalsIgnoreCase("SYSTEM")) {
                for (int i = 0; i < allNodes.size(); ++i) {
                    SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                    String node = allNodes.get(i).toString();
                    ContainerUDB[] containersForNode = tablespace.getContainersForNode(node);
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "USING");
                    SSBTableSpaceUDBv81.appendString(buffer, '(');
                    for (int j = 0; j < containersForNode.length; ++j) {
                        ContainerUDBv81 container = (ContainerUDBv81)containersForNode[j];
                        SSBTableSpaceUDBv81.appendString(buffer, container.getContainers().trim());
                        if (j >= containersForNode.length - 1) continue;
                        buffer.append(", ");
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, ')');
                    if (node.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, ON_DBPARTITIONNUM);
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, '(');
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, node.trim());
                    SSBTableSpaceUDBv81.appendString(buffer, ')');
                }
            } else {
                for (int i = 0; i < allNodes.size(); ++i) {
                    SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                    String node = allNodes.get(i).toString();
                    ContainerUDB[] containersForNode = tablespace.getContainersForNode(node);
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "USING");
                    SSBTableSpaceUDBv81.appendString(buffer, '(');
                    for (int j = 0; j < containersForNode.length; ++j) {
                        ContainerUDBv81 container = (ContainerUDBv81)containersForNode[j];
                        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, container.getContainers());
                        if (j >= containersForNode.length - 1) continue;
                        buffer.append(", ");
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, ')');
                    if (node.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, ON_DBPARTITIONNUM);
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, '(');
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, node);
                    SSBTableSpaceUDBv81.appendString(buffer, ')');
                }
            }
        }
    }

    private void appendUsePrivileges(StringBuffer buffer, TableSpaceUDB ts, boolean prettyPrint) {
        if (!ts.getUsers().equalsIgnoreCase("") || !ts.getGroups().equalsIgnoreCase("")) {
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "GRANT");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "USE");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "OF");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, this.getTSStorageDesign(ts).getFormatedName(ts.getName()));
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "TO");
            if (!ts.getUsers().equalsIgnoreCase("")) {
                int i;
                for (i = 0; i < ts.getUserSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    if (!((String)ts.getUserSet().elementAt(i)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "USER");
                    }
                    this.appendStringWithSpace(buffer, ts.getUserSet().elementAt(i));
                }
                if (!ts.getGroups().equalsIgnoreCase("")) {
                    for (i = 0; i < ts.getUserGroupSet().size(); ++i) {
                        this.appendComma(buffer);
                        SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "GROUP");
                        this.appendStringWithSpace(buffer, ts.getUserGroupSet().elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < ts.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "GROUP");
                    this.appendStringWithSpace(buffer, ts.getUserGroupSet().elementAt(i));
                }
            }
            if ("YES".equalsIgnoreCase(ts.getGrantOption())) {
                SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv81.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceUDBv81.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

