/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.DefaultSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDefaultSqlServerv2k
extends AbstractSSBSqlServer {
    public static final String[] FUNCTIONS = new String[]{"GETDATE()"};
    private StorageDesign storageDesign;

    public static boolean isFunction(String constant) {
        for (String name : FUNCTIONS) {
            if (!name.equalsIgnoreCase(constant)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DefaultSqlServerv2k defaultSqlServerv2k = (DefaultSqlServerv2k)object;
        this.storageDesign = defaultSqlServerv2k.getStorageDesign();
        if (defaultSqlServerv2k.getDataBase() != null && !defaultSqlServerv2k.getDataBase().isNullInstance()) {
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "USE");
            this.appendString(buffer, defaultSqlServerv2k.getDataBase());
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
        SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "DEFAULT");
        if (defaultSqlServerv2k.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBDefaultSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(defaultSqlServerv2k.getOwner().getName()));
            SSBDefaultSqlServerv2k.appendString(buffer, '.');
        }
        SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(defaultSqlServerv2k.getName()));
        SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (!defaultSqlServerv2k.getConstant().equalsIgnoreCase("")) {
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "AS");
            String constant = defaultSqlServerv2k.getConstant();
            if (SSBDefaultSqlServerv2k.isFunction(constant)) {
                SSBDefaultSqlServerv2k.appendString(buffer, constant);
            } else {
                SSBDefaultSqlServerv2k.appendString(buffer, '\'');
                SSBDefaultSqlServerv2k.appendString(buffer, constant);
                SSBDefaultSqlServerv2k.appendString(buffer, '\'');
            }
        } else {
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Empty Constant in default ");
            buffer.append(this.storageDesign.getFormatedName(defaultSqlServerv2k.getName()));
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateDefault();
        if (defaultSqlServerv2k.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendDefaultComment(buffer, defaultSqlServerv2k, prettyPrint);
        }
    }

    protected void appendDefaultComment(StringBuffer buffer, DefaultSqlServerv2k def, boolean prettyPrint) {
        String comment = def.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBDefaultSqlServerv2k.appendString(buffer, '\'');
            SSBDefaultSqlServerv2k.appendString(buffer, comment);
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (def != null && def.getOwner() != null) {
                SSBDefaultSqlServerv2k.appendString(buffer, '\'');
                SSBDefaultSqlServerv2k.appendString(buffer, "USER");
                SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBDefaultSqlServerv2k.appendString(buffer, '\'');
                this.appendString(buffer, def.getOwner());
                SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBDefaultSqlServerv2k.appendString(buffer, '\'');
            SSBDefaultSqlServerv2k.appendString(buffer, "DEFAULT");
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBDefaultSqlServerv2k.appendString(buffer, '\'');
            SSBDefaultSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(def.getLongNameDDL()));
            SSBDefaultSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBDefaultSqlServerv2k.appendString(buffer, "GO");
            SSBDefaultSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DefaultSqlServerv2k && ((DefaultSqlServerv2k)object).getDataBase() != null && !((DefaultSqlServerv2k)object).getDataBase().isNullInstance() && ((DefaultSqlServerv2k)object).isMarkedGenerate();
    }
}

