/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;

public class SSBDropViewSqlServer
extends SQLStatementBuilder {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)object).isDropEnabled() && !((TableViewProxySqlServer)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        if (object == null) {
            return;
        }
        TableView view = null;
        TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)object;
        view = (TableView)tableViewProxySqlServer.getObject();
        this.appendBeforeDropScript(buffer, prettyPrint, view);
        DataBaseSqlServer database = tableViewProxySqlServer.getDataBase();
        this.storageDesign = tableViewProxySqlServer.getStorageDesign();
        if (database != null && !database.isNullInstance()) {
            SSBDropViewSqlServer.appendStringWithSpace(buffer, "USE");
            SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(database.getName()));
            SSBDropViewSqlServer.appendNewLine(buffer, prettyPrint, 0);
            SSBDropViewSqlServer.appendStringWithSpace(buffer, "GO");
            SSBDropViewSqlServer.appendNewLine(buffer, prettyPrint, 0);
        }
        this.appendDrop(buffer);
        SSBDropViewSqlServer.appendStringWithSpace(buffer, "VIEW");
        if (tableViewProxySqlServer.getStorageDesign() instanceof StorageDesignSqlServerv2k) {
            UserSqlServer user = tableViewProxySqlServer.getUser();
            if (user != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(user.getName()));
                SSBDropViewSqlServer.appendString(buffer, '.');
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(view.getName()));
            } else {
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(view.getName()));
            }
        } else if (tableViewProxySqlServer.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            SchemaSqlServer schema = tableViewProxySqlServer.getSchema();
            if (schema != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(schema.getName()));
                SSBDropViewSqlServer.appendString(buffer, '.');
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(view.getName()));
            } else {
                SSBDropViewSqlServer.appendString(buffer, this.storageDesign.getFormatedName(view.getName()));
            }
        }
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        SSBDropViewSqlServer.appendNewLine(buffer, prettyPrint, 0);
        SSBDropViewSqlServer.appendString(buffer, "GO");
        SSBDropViewSqlServer.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
    }
}

