/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceOraclev9i && ((TableSpaceOraclev9i)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TableSpaceOraclev9i tableSpace = (TableSpaceOraclev9i)object;
        this.storageDesign = tableSpace.getStorageDesign();
        if (!tableSpace.isNullInstance()) {
            List list = tableSpace.getDataFiles();
            this.appendComment(oldbuffer, tableSpace);
            this.appendCreate(buffer, tableSpace);
            advancedComment = buffer.toString();
            this.appendDataFiles(buffer, tableSpace, list);
            this.appendMinimumExtent(buffer, tableSpace);
            this.appendBlockSize(buffer, tableSpace);
            this.appendLogging(buffer, tableSpace);
            this.appendForceLogging(buffer, tableSpace, prettyPrint);
            this.appendStatus(buffer, tableSpace);
            this.appendContents(buffer, tableSpace);
            this.appendDefaultStorage(buffer, tableSpace);
            this.appendExtentManagement(buffer, tableSpace);
            this.appendLocalSubType(buffer, tableSpace);
            this.appendUniformSize(buffer, tableSpace);
            this.appendSegmentManagement(buffer, tableSpace);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBTableSpaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceOraclev9i.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendCreate(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
    }

    private void appendSegmentManagement(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        String segmentManagement;
        String contents = tableSpace.getContents();
        String extentManagement = tableSpace.getExtentManagement();
        if (contents.equalsIgnoreCase("PERMANENT") && extentManagement.equalsIgnoreCase("LOCAL") && !"".equals(segmentManagement = tableSpace.getSegmentManagement())) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("SEGMENT SPACE MANAGEMENT ").append(segmentManagement);
        }
    }

    private void appendBlockSize(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        int blockSize = tableSpace.getBlockSize();
        if (blockSize > 0) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("BLOCKSIZE ").append(blockSize);
        }
    }

    private void appendDataFiles(StringBuffer buffer, TableSpaceOraclev9i tableSpace, List dataFiles) {
        if (dataFiles.isEmpty()) {
            buffer.append(NEWLINE);
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "--  WARNING: Tablespace has no data files defined");
            DDLFileMaker.incrementWarnings();
        }
        Iterator setIt = dataFiles.iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append("    ");
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, ',');
            }
            String filename = dataFile.getFileName().trim();
            if (!filename.equals("")) {
                buffer.append(NEWLINE);
                buffer.append("    ").append("    ");
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, this.addQuotes(filename, true));
            }
            if (dataFile.getSize() > 0L) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "SIZE");
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getSize());
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            }
            if (dataFile.getReuse().equalsIgnoreCase("YES") && !filename.equals("")) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "NEXT");
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendMinimumExtent(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        int minExtent;
        if ("DICTIONARY".equalsIgnoreCase(tableSpace.getExtentManagement()) && (minExtent = tableSpace.getMinExtLen()) > 0) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("MINIMUM EXTENT ").append(minExtent);
        }
    }

    private void appendLogging(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            String logging = tableSpace.getLogging();
            buffer.append(NEWLINE);
            buffer.append("    ").append(logging);
        }
    }

    private void appendForceLogging(StringBuffer buffer, TableSpaceOraclev9i tableSpace, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(tableSpace.getForceLogging())) {
            SSBTableSpaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "FORCE");
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, "LOGGING");
        }
    }

    private void appendStatus(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        String status = tableSpace.getStatus();
        buffer.append(NEWLINE);
        buffer.append("    ").append(status);
    }

    private void appendContents(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        String contents = tableSpace.getContents();
        buffer.append(NEWLINE);
        buffer.append("    ").append(contents);
    }

    private void appendDefaultStorage(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        if ("DICTIONARY".equalsIgnoreCase(tableSpace.getExtentManagement()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("DEFAULT STORAGE (");
            long initExtent = tableSpace.getDSInitialExtent();
            long nextExtent = tableSpace.getDSNextExtent();
            int minExtents = tableSpace.getDSMinExtents();
            String maxtExtents = tableSpace.getDSMaxExtents();
            int pctIncrease = tableSpace.getDSPctIncrease();
            if (initExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                buffer.append("INITIAL ").append(initExtent).append(' ');
            }
            if (nextExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                buffer.append("NEXT ").append(nextExtent).append(' ');
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                if (minExtents > 1) {
                    buffer.append("MINEXTENTS ").append(minExtents).append(' ');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append("MINEXTENTS ").append(minExtents).append('1');
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                buffer.append("MAXEXTENTS ").append(maxtExtents);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                buffer.append(" PCTINCREASE ").append(pctIncrease);
            }
            buffer.append(")");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        String extentManagement = tableSpace.getExtentManagement();
        buffer.append(NEWLINE);
        buffer.append("    ").append("EXTENT MANAGEMENT ").append(extentManagement);
    }

    private void appendLocalSubType(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        String localSubType;
        if ("LOCAL".equalsIgnoreCase(tableSpace.getExtentManagement()) && "UNIFORM".equalsIgnoreCase(localSubType = tableSpace.getEMLocalSubtype())) {
            buffer.append(NEWLINE);
            buffer.append("    ");
            SSBTableSpaceOraclev9i.appendStringWithSpace(buffer, localSubType);
        }
    }

    private void appendUniformSize(StringBuffer buffer, TableSpaceOraclev9i tableSpace) {
        int uniformSize;
        if ("LOCAL".equalsIgnoreCase(tableSpace.getExtentManagement()) && "UNIFORM".equalsIgnoreCase(tableSpace.getEMLocalSubtype()) && (uniformSize = tableSpace.getEMUniformSize()) > 0) {
            buffer.append(" SIZE ").append(uniformSize);
        }
    }
}

