/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v12c.SSBTableOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.util.options.Settings;

public class SSBMaterializedViewLogOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOracle storageDesign;

    public void appendMViewLogDDL(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof MaterializedViewLogOracle) {
            this.doAppend(oldbuffer, object, prettyPrint);
        }
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        MaterializedViewLogOracle mvLog = (MaterializedViewLogOracle)object;
        StringBuffer buffer = new StringBuffer();
        this.storageDesign = (StorageDesignOracle)mvLog.getStorageDesign();
        Settings s = this.storageDesign.getAppView().getSettings();
        this.appendPrompt(buffer, mvLog, "MATERIALIZED VIEW LOG");
        this.appendComment(oldbuffer, mvLog);
        this.appendCreateMaterializedViewLog(buffer, mvLog);
        String advancedComment = buffer.toString();
        if (mvLog.getLogging() != null && s.isIncludeLoggingInDDL()) {
            if (mvLog.getLogging().equals("YES")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "LOGGING");
            } else if (mvLog.getLogging().equals("NO")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if (mvLog.getTablespace() != null && s.isIncludeTablespaceInDDL() && !mvLog.getTablespace().equals("")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            this.appendStringWithSpace(buffer, mvLog.getTablespace());
        }
        if (mvLog.getSegment() != null) {
            SSBTableOraclev10g.appendSegment(buffer, mvLog.getSegment(), true, prettyPrint, null, "", mvLog.getStorageDesign());
        } else if (s.isIncludeStorageInDDL()) {
            if (mvLog.getPercentFree() != null && !mvLog.getPercentFree().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPercentFree());
            }
            if (mvLog.getPercentUsed() != null && !mvLog.getPercentUsed().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PCTUSED");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPercentUsed());
            }
            if (mvLog.getInitrans() != null && !mvLog.getInitrans().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getInitrans());
            }
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, '(');
            if (!mvLog.getInitialExtent().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getInitialExtent());
            }
            if (!mvLog.getNextExtent().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "NEXT");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getNextExtent());
            }
            if (!mvLog.getMinExtent().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getMinExtent());
            }
            if (!mvLog.getMaxExtent().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getMaxExtent());
            }
            if (!mvLog.getPercentIncrease().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPercentIncrease());
            }
            if (!mvLog.getFreelists().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getFreelists());
            }
            if (!mvLog.getFreelistGroups().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "FREELIST GROUPS");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getFreelistGroups());
            }
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getBufferPool());
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, ')');
        }
        if (mvLog.getCache().equals("No cache")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
        } else if (mvLog.getCache().equals("Cache")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "CACHE");
        }
        if (mvLog.getParallel().equals("NO")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        } else if (mvLog.getParallel().equals("YES")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            if (mvLog.getDegree() != null && !mvLog.getDegree().isEmpty()) {
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getDegree());
            }
        }
        TableProxyOracle tp = mvLog.getLogTableProxy();
        if (tp != null && tp.getPartitionList() != null) {
            SSBTableOraclev12c ssb = new SSBTableOraclev12c();
            ssb.setStorageDesign(mvLog.getStorageDesign());
            ssb.appendPartitionList(buffer, tp, prettyPrint);
        }
        if (mvLog.getPkLogged().equals("YES") || mvLog.getSequenceLogged().equals("YES") || mvLog.getColumns() != null && !mvLog.getColumns().isEmpty() || mvLog.getRowIDLogged().equals("YES")) {
            TableProxyOracle tableProxy;
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "WITH");
            boolean needsComma = false;
            if (mvLog.getPkLogged().equals("YES")) {
                SSBMaterializedViewLogOraclev9i.appendString(buffer, "PRIMARY KEY");
                needsComma = true;
            }
            if (mvLog.getSequenceLogged().equals("YES")) {
                if (needsComma) {
                    SSBMaterializedViewLogOraclev9i.appendString(buffer, ',');
                } else {
                    needsComma = true;
                }
                SSBMaterializedViewLogOraclev9i.appendString(buffer, ' ');
                SSBMaterializedViewLogOraclev9i.appendString(buffer, "SEQUENCE");
            }
            if (mvLog.getRowIDLogged().equals("YES")) {
                if (needsComma) {
                    SSBMaterializedViewLogOraclev9i.appendString(buffer, ',');
                } else {
                    needsComma = true;
                }
                SSBMaterializedViewLogOraclev9i.appendString(buffer, ' ');
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "ROWID");
            }
            if ((tableProxy = mvLog.getTableProxy()) != null && !tableProxy.getBasedOnStructuredType().equals("")) {
                if (mvLog.getObjectIDLogged().equals("YES")) {
                    if (needsComma) {
                        SSBMaterializedViewLogOraclev9i.appendString(buffer, ',');
                    } else {
                        needsComma = true;
                    }
                    SSBMaterializedViewLogOraclev9i.appendString(buffer, ' ');
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "OBJECT ID");
                }
            } else if (tableProxy == null && mvLog.getObjectIDLogged().equals("YES")) {
                if (needsComma) {
                    SSBMaterializedViewLogOraclev9i.appendString(buffer, ',');
                } else {
                    needsComma = true;
                }
                SSBMaterializedViewLogOraclev9i.appendString(buffer, ' ');
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "OBJECT ID");
            }
            if (mvLog.isCommitSCN()) {
                if (needsComma) {
                    SSBMaterializedViewLogOraclev9i.appendString(buffer, ',');
                } else {
                    needsComma = true;
                }
                SSBMaterializedViewLogOraclev9i.appendString(buffer, ' ');
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "COMMIT SCN");
            }
            if (mvLog.getColumns() != null && !mvLog.getColumns().equals("")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                Object colNames = "";
                Iterator columnsIt = this.storageDesign.getColumnProxySet().iterator();
                block0: for (String colObjID : Arrays.asList(mvLog.getColumns().split(","))) {
                    if (colObjID.equals("")) continue;
                    while (columnsIt.hasNext()) {
                        ColumnProxyOracle col = (ColumnProxyOracle)columnsIt.next();
                        if (!col.getObjectID().equals(colObjID)) continue;
                        colNames = (String)colNames + col.getName() + ", ";
                        continue block0;
                    }
                }
                if (!((String)colNames).isEmpty()) {
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, '(');
                    colNames = ((String)colNames).substring(0, ((String)colNames).lastIndexOf(44));
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, (String)colNames);
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, ')');
                }
            }
        }
        if (mvLog.getNewValues().equals("Excluding")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "EXCLUDING NEW VALUES");
        } else if (mvLog.getNewValues().equals("Including")) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "INCLUDING NEW VALUES");
        }
        if (!mvLog.getPurgeType().equals(Character.valueOf(' '))) {
            if (mvLog.getPurgeType().equals("IMMEDIATE SYNCHRONOUS")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PURGE");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE SYNCHRONOUS");
            } else if (mvLog.getPurgeType().equals("IMMEDIATE ASYNCHRONOUS")) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PURGE");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE ASYNCHRONOUS");
            } else if (mvLog.getPurgeType().equals("DEFERRED") && mvLog.getPurgeSWExpression() != null && !mvLog.getPurgeSWExpression().trim().isEmpty()) {
                SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "PURGE");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "START WITH");
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPurgeSWExpression());
                if (mvLog.getPurgeNextExpression() != null && !mvLog.getPurgeNextExpression().trim().isEmpty()) {
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPurgeNextExpression());
                }
                if (mvLog.getPurgeRIExpression() != null && !mvLog.getPurgeRIExpression().trim().isEmpty()) {
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "REPEAT INTERVAL");
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getPurgeRIExpression());
                }
            }
        }
        if (!mvLog.getRefreshType().trim().isEmpty()) {
            SSBMaterializedViewLogOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if (mvLog.getRefreshType().equals("SYNCHRONOUS") && !mvLog.getRefreshSLName().isEmpty()) {
                if (!mvLog.isCommitSCN()) {
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "FOR SYNCHRONOUS REFRESH USING");
                    SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, mvLog.getRefreshSLName());
                }
            } else if (mvLog.getRefreshType().equals("FAST")) {
                SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "FOR FAST REFRESH");
            }
        }
        SSBMaterializedViewLogOraclev9i.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendCreateMaterializedViewLog(StringBuffer buffer, MaterializedViewLogOracle mvLog) {
        this.appendCreate(buffer);
        SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "MATERIALIZED");
        SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "VIEW");
        SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "LOG");
        SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBMaterializedViewLogOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(mvLog));
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof MaterializedViewLogOracle;
    }
}

