/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SequenceOraclev10g sequence = (SequenceOraclev10g)object;
        this.storageDesign = sequence.getStorageDesign();
        this.appendPrompt(buffer, sequence, "SEQUENCE");
        this.appendComment(buffer, sequence);
        SSBSequenceOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBSequenceOraclev10g.appendStringWithSpace(buffer, "SEQUENCE");
        SSBSequenceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(sequence));
        advancedComment = buffer.toString();
        this.appendStartWith(buffer, sequence, prettyPrint);
        this.appendIncrementBy(buffer, sequence, prettyPrint);
        this.appendMaxValue(buffer, sequence, prettyPrint);
        this.appendMinValue(buffer, sequence, prettyPrint);
        this.appendCycle(buffer, sequence, prettyPrint);
        this.appendCache(buffer, sequence, prettyPrint);
        this.appendOrder(buffer, sequence, prettyPrint);
        this.appendSession(buffer, sequence, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBSequenceOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateSequence();
        this.appendPermissions(oldbuffer, sequence, prettyPrint);
        SSBSequenceOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceOraclev10g && ((SequenceOraclev10g)object).isMarkedGenerate();
    }

    private void appendStartWith(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getStartWith())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "START");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "WITH");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, sequence.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getIncrementBy())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, sequence.getIncrementBy());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "1");
        }
    }

    private void appendMaxValue(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMaxValue())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "MAXVALUE");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
    }

    private void appendMinValue(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMinValue())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "MINVALUE");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "NOMINVALUE");
        }
    }

    private void appendCycle(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getCycle())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "NOCYCLE");
        }
    }

    private void appendCache(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if ("YES".equals(sequence.getNoCache())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
        } else if (this.isNotEmpty(sequence.getCache())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "CACHE");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, sequence.getCache());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "CACHE");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "20");
        }
    }

    private void appendOrder(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getOrder())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "NOORDER");
        }
    }

    private void appendSession(StringBuffer buffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            if ("YES".equalsIgnoreCase(sequence.getSession())) {
                SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBSequenceOraclev10g.appendStringWithSpace(buffer, "SESSION");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBSequenceOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SequenceOraclev10g sequence, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        for (PermissionsOraclev10g permissions : ((StorageDesignOracle)this.storageDesign).getPermissionsSet()) {
            if (permissions.getSequence() == null || !permissions.getSequence().equals(sequence)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                SSBSequenceOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBSequenceOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                SSBSequenceOraclev10g.appendStringWithSpace(buffer, "GRANT");
                SSBSequenceOraclev10g.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions, this.storageDesign);
            this.appendGrantOption(buffer, permissions);
            advancedComment = buffer.toString();
            this.appendHierrarchyOption(buffer, permissions, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if (permissions.getSequence() != null) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSequence()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            SSBSequenceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }
}

