/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Iterator;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.CheckOutList;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.VersionTreeDiagram;

public class UnreservedCheckOutShape
extends GraphShape {
    private Rectangle2D m_shape;

    UnreservedCheckOutShape(String label, Point location, int size, GraphShape parent, int connectionSide, GraphElement clientObject) {
        super(label, parent, connectionSide, clientObject);
        this.m_shape = new Rectangle2D.Double(location.x - size / 2, location.y - size / 2, size, size);
    }

    @Override
    public String getToolTipText() {
        if (super.getToolTipText() != null) {
            return super.getToolTipText();
        }
        String versionLabel = null;
        try {
            versionLabel = ((ContextElement)this.getGraphElement()).getVersionableResource().getVersionLabel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (versionLabel != null) {
                return VHVArb.format(68, new String[]{versionLabel, this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
            }
            return VHVArb.format(67, new String[]{this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void paint(Graphics2D g, boolean paintText) {
        if (g.getClip() == null || g.getClip().intersects(this.getBounds2D())) {
            double size;
            GeneralPath gp;
            Color c = VersionTreeDiagram.getDefaultNodeColor();
            CheckOutElement coe = (CheckOutElement)this.getGraphElement();
            if (VersionTreeDiagram.isIgnoreDiagramColor() && coe.getResource().getBackground() != null) {
                c = coe.getResource().getBackground();
            } else if (VersionTreeDiagram.getInContextNodeColor() != null && coe.isInContext()) {
                c = VersionTreeDiagram.getInContextNodeColor();
            } else if (VersionTreeDiagram.getUnreservedCheckOutNodeColor() != null && coe.isUnreservedCheckOut()) {
                c = VersionTreeDiagram.getUnreservedCheckOutNodeColor();
            } else if (coe.getResource().getBackground() != null) {
                c = coe.getResource().getBackground();
            }
            g.setColor(c);
            g.fill(this.m_shape);
            g.setColor(Color.black);
            if (this.isSelected()) {
                g.setStroke(new BasicStroke(2.0f));
                gp = new GeneralPath();
                size = (this.m_shape.getMaxX() - this.m_shape.getMinX()) / 6.0;
                gp.moveTo((float)this.m_shape.getMinX() - 3.0f, (float)(this.m_shape.getMinY() - 3.0 + size));
                gp.lineTo((float)this.m_shape.getMinX() - 3.0f, (float)this.m_shape.getMinY() - 3.0f);
                gp.lineTo((float)(this.m_shape.getMinX() - 3.0 + size), (float)this.m_shape.getMinY() - 3.0f);
                gp.moveTo((float)this.m_shape.getMaxX() + 3.0f, (float)(this.m_shape.getMinY() - 3.0 + size));
                gp.lineTo((float)this.m_shape.getMaxX() + 3.0f, (float)this.m_shape.getMinY() - 3.0f);
                gp.lineTo((float)(this.m_shape.getMaxX() + 3.0 - size), (float)this.m_shape.getMinY() - 3.0f);
                gp.moveTo((float)this.m_shape.getMaxX() + 3.0f, (float)(this.m_shape.getMaxY() + 3.0 - size));
                gp.lineTo((float)this.m_shape.getMaxX() + 3.0f, (float)this.m_shape.getMaxY() + 3.0f);
                gp.lineTo((float)(this.m_shape.getMaxX() + 3.0 - size), (float)this.m_shape.getMaxY() + 3.0f);
                gp.moveTo((float)this.m_shape.getMinX() - 3.0f, (float)(this.m_shape.getMaxY() + 3.0 - size));
                gp.lineTo((float)this.m_shape.getMinX() - 3.0f, (float)this.m_shape.getMaxY() + 3.0f);
                gp.lineTo((float)(this.m_shape.getMinX() - 3.0 + size), (float)this.m_shape.getMaxY() + 3.0f);
                g.draw(gp);
                g.setStroke(new BasicStroke(1.0f));
            }
            if (coe.isInContext()) {
                gp = new GeneralPath();
                size = this.getVisibleVersionArrowSize();
                gp.moveTo((float)this.m_shape.getMinX() - 2.0f, (float)this.m_shape.getCenterY());
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - 2.0 * size), (float)(this.m_shape.getCenterY() - size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - 2.0 * size), (float)(this.m_shape.getCenterY() + size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() + size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() + size));
                gp.closePath();
                g.setColor(c);
                g.fill(gp);
                g.setColor(Color.black);
                g.draw(gp);
            }
            if (this.isHighlighted()) {
                g.setStroke(new BasicStroke(3.0f));
            }
            g.draw(this.m_shape);
            g.setStroke(new BasicStroke(1.0f));
            if (paintText) {
                g.setFont(VersionTreeDiagram.getDisplayFont());
                Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(this.getLabel(), g);
                int labelWidth = (int)Math.round(Math.ceil(labelBounds.getWidth()));
                int labelHeight = (int)Math.round(Math.floor(g.getFontMetrics().getLineMetrics(this.getLabel(), g).getAscent() - g.getFontMetrics().getLineMetrics(this.getLabel(), g).getLeading()));
                g.setFont(VersionTreeDiagram.getDisplayFont());
                if (UnreservedCheckOutShape.isDarkColor(c)) {
                    g.setColor(Color.white);
                }
                if (coe.getResource().getForeground() != null) {
                    g.setColor(coe.getResource().getForeground());
                }
                int x = (int)Math.round(this.m_shape.getCenterX() - (double)(labelWidth / 2));
                int y = (int)Math.round(this.m_shape.getCenterY() + (double)(labelHeight / 2));
                g.drawString(this.getLabel(), x, y);
            }
        }
        g.setColor(Color.black);
        Point2D cp = this.getTopConnectionPoint();
        Point2D pcp = this.getConnectionPoint();
        Line2D.Double line = new Line2D.Double(cp, pcp);
        if (g.getClip() == null || g.getClip().getBounds2D().intersectsLine(line)) {
            g.draw(line);
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    @Override
    public void move(double dX, double dY) {
        this.m_shape.setFrame(this.m_shape.getX() + dX, this.m_shape.getY() + dY, this.m_shape.getWidth(), this.m_shape.getHeight());
    }

    @Override
    public Rectangle2D getBounds2D() {
        int border = 5;
        double minX = this.m_shape.getMinX() - (double)border;
        double minY = this.m_shape.getMinY() - (double)border;
        double maxX = this.m_shape.getMaxX() + (double)border;
        double maxY = this.m_shape.getMaxY() + (double)border;
        if (((CheckOutElement)this.getGraphElement()).isInContext()) {
            minX -= 2.0 + 2.0 * this.getVisibleVersionArrowSize();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public Rectangle2D getTotalBounds2D() {
        Rectangle2D bounds = this.getBounds2D();
        CheckOutElement coe = (CheckOutElement)this.getGraphElement();
        bounds.add(this.getConnectionPoint());
        if (coe.getTargetMerges() != null) {
            Iterator i = coe.getTargetMerges().iterator();
            while (i.hasNext()) {
                bounds.add(((GraphShape)((GraphElement)i.next()).getShape()).getBounds2D());
            }
        }
        return bounds;
    }

    @Override
    public Shape getShape() {
        return this.m_shape;
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getCenterY());
    }

    @Override
    public Point2D getTopConnectionPoint() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getMinY());
    }

    @Override
    public Point2D getBottomConnectionPoint() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getMaxY());
    }

    @Override
    public Point2D getLeftConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMinX(), this.m_shape.getCenterY());
    }

    @Override
    public Point2D getRightConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMaxX(), this.m_shape.getCenterY());
    }

    @Override
    public int getScrollX() {
        return (int)Math.ceil(this.m_shape.getMaxX() + 32.0);
    }

    @Override
    public int getScrollY() {
        return (int)Math.ceil(this.m_shape.getMaxY() + 32.0);
    }

    private double getVisibleVersionArrowSize() {
        return (this.m_shape.getMaxX() - this.m_shape.getMinX()) / 3.0;
    }

    @Override
    public GraphShape getAbove() {
        CheckOutElement coe;
        SuccessorElement se = (SuccessorElement)this.getGraphElement().getParentElement();
        CheckOutList col = se.getUnreservedCheckOuts();
        if (col != null) {
            GraphElement ge;
            GraphShape gs = null;
            Iterator i = col.iterator();
            while (i.hasNext() && (ge = (GraphElement)i.next()) != this.getGraphElement()) {
                gs = (GraphShape)ge.getShape();
            }
            if (gs != null) {
                return gs;
            }
        }
        if ((coe = se.getReservedCheckOut()) != null) {
            return (GraphShape)coe.getShape();
        }
        return (GraphShape)this.getParentShape();
    }

    @Override
    public GraphShape getBelow() {
        SuccessorElement se = (SuccessorElement)this.getGraphElement().getParentElement();
        CheckOutList col = se.getUnreservedCheckOuts();
        if (col != null) {
            GraphShape gs = null;
            Iterator i = col.iterator();
            while (i.hasNext()) {
                if (i.next() != this.getGraphElement() || !i.hasNext()) continue;
                gs = (GraphShape)((GraphElement)i.next()).getShape();
            }
            if (gs != null) {
                return gs;
            }
        }
        if (se.getDisplayedChildElement() != null) {
            return (GraphShape)se.getDisplayedChildElement().getShape();
        }
        return this;
    }
}

