/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.vhv.model.MergeElement;

public class MergeList
extends ArrayList {
    private Comparator<MergeElement> _comparator = null;

    private Comparator<MergeElement> getComparator() {
        if (this._comparator == null) {
            this._comparator = ((MergeElement)this.get(0)).getDatestamp() != null ? new DateComparator() : new NameComparator();
        }
        return this._comparator;
    }

    @Override
    public boolean add(MergeElement me) {
        if (this.isEmpty()) {
            super.add(me);
        } else {
            this.add(Math.abs(Collections.binarySearch(this, me, this.getComparator()) + 1), me);
        }
        return true;
    }

    private static class DateComparator
    implements Comparator<MergeElement> {
        private DateComparator() {
        }

        @Override
        public int compare(MergeElement o1, MergeElement o2) {
            return o1.getDatestamp().compareTo(o2.getDatestamp());
        }
    }

    private static class NameComparator
    implements Comparator<MergeElement> {
        private NameComparator() {
        }

        @Override
        public int compare(MergeElement o1, MergeElement o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }
}

