/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.vhv.VHVBranchResource;
import oracle.ide.vhv.VHVMergeResource;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.VersionTreeDiagramPane;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.controls.ThrobberLabel;

public class VHVStructureExplorer
extends Explorer
implements Observer {
    private static final String GUI_THROBBER = "throbber";
    private static final String GUI_STRUCTURE = "structure";
    private JComponent _structurePanel;
    private CardLayout _structureCardLayout;
    private Component _gui;
    private VHVViewer _viewer;
    private Context _context;
    private final Comparator<ShapeNode> _nodeNameComparator = new Comparator<ShapeNode>(){

        @Override
        public final int compare(ShapeNode node1, ShapeNode node2) {
            try {
                VHVBranchResource branch1 = this.getSourceBranch(node1);
                VHVBranchResource branch2 = this.getSourceBranch(node2);
                int result = branch1.getName().compareTo(branch2.getName());
                if (result != 0) {
                    return result;
                }
                Comparable version1 = this.getSourceVersion(node1);
                Comparable version2 = this.getSourceVersion(node2);
                if (version1 != null && version2 != null && (result = version1.compareTo(version2)) != 0) {
                    return result;
                }
                result = VHVStructureExplorer.this._nodeTypeComparator.compare(node1, node2);
                if (result != 0) {
                    return result;
                }
                return node1.getShortLabel().compareTo(node2.getShortLabel());
            }
            catch (VHVResourceException vhvre) {
                vhvre.printStackTrace();
                return 0;
            }
        }

        private final VHVBranchResource getSourceBranch(ShapeNode node) throws VHVResourceException {
            if (node.getResource() instanceof VHVBranchResource) {
                return (VHVBranchResource)node.getResource();
            }
            if (node.getResource() instanceof VHVVersionableResource) {
                return ((VHVVersionableResource)node.getResource()).getBranch();
            }
            if (node.getResource() instanceof VHVMergeResource) {
                return ((VHVVersionableResource)((VHVMergeResource)node.getResource()).getSource()).getBranch();
            }
            throw new IllegalStateException();
        }

        private final Comparable getSourceVersion(ShapeNode node) throws VHVResourceException {
            if (node.getResource() instanceof VHVBranchResource) {
                return null;
            }
            if (node.getResource() instanceof VHVVersionableResource) {
                return ((VHVVersionableResource)node.getResource()).getVersionNumber();
            }
            if (node.getResource() instanceof VHVMergeResource) {
                return ((VHVVersionableResource)((VHVMergeResource)node.getResource()).getSource()).getVersionNumber();
            }
            throw new IllegalStateException();
        }
    };
    private final Comparator<ShapeNode> _nodeTypeComparator = new Comparator<ShapeNode>(){

        @Override
        public final int compare(ShapeNode node1, ShapeNode node2) {
            return node1.getType().ordinal() - node2.getType().ordinal();
        }
    };
    private Comparator<ShapeNode> _nodeComparator = this._nodeNameComparator;
    private final DelegateExplorer _delegate = new DelegateExplorer();

    public VHVStructureExplorer() {
        this._delegate.addViewSelectionListener(new ViewSelectionListener(){

            public void viewSelectionChanged(ViewSelectionEvent vse) {
                Element[] selection = vse.getSelection();
                if (selection.length == 0) {
                    return;
                }
                VersionTreeDiagramPane diagramPane = VHVStructureExplorer.this._viewer.getVersionTreeDiagramPane();
                if (diagramPane == null) {
                    return;
                }
                if (selection.length == 1) {
                    diagramPane.selectAndScrollTo(((ShapeNode)selection[0]).getShape());
                    return;
                }
                ArrayList<GraphShape> shapes = new ArrayList<GraphShape>();
                for (Element e : selection) {
                    shapes.add(((ShapeNode)e).getShape());
                }
                diagramPane.select(shapes);
            }
        });
        final AbstractAction sortByNameAction = new AbstractAction(VHVArb.getString(114)){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                VHVStructureExplorer.this.resort(VHVStructureExplorer.this._nodeNameComparator);
            }
        };
        final AbstractAction sortByTypeAction = new AbstractAction(VHVArb.getString(115)){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                VHVStructureExplorer.this.resort(VHVStructureExplorer.this._nodeTypeComparator);
            }
        };
        this.getContextMenu().addContextMenuListener(new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                JRadioButtonMenuItem sortByNameItem = new JRadioButtonMenuItem(sortByNameAction);
                JRadioButtonMenuItem sortByTypeItem = new JRadioButtonMenuItem(sortByTypeAction);
                ButtonGroup bg = new ButtonGroup();
                bg.add(sortByNameItem);
                bg.add(sortByTypeItem);
                sortByNameItem.setSelected(VHVStructureExplorer.this._nodeComparator == VHVStructureExplorer.this._nodeNameComparator);
                sortByTypeItem.setSelected(VHVStructureExplorer.this._nodeComparator == VHVStructureExplorer.this._nodeTypeComparator);
                contextMenu.add((Component)sortByNameItem);
                contextMenu.add((Component)sortByTypeItem);
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        });
    }

    public void setOwner(View host) {
        this._delegate.setOwner(host);
    }

    public String getTitle() {
        return this._delegate.getTitle();
    }

    public ContextMenu getContextMenu() {
        return this._delegate.getContextMenu();
    }

    public final Context getContext(EventObject event) {
        return this._delegate.getContext(event);
    }

    private final void _setContext(Context context) {
        this._delegate.setContext(context);
        Element elementForContext = this.getElementForContext(context);
        if (elementForContext == null) {
            elementForContext = context.getElement();
        }
        this._delegate.setRoot_(elementForContext);
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._structureCardLayout = new CardLayout();
            this._structurePanel = new JPanel(this._structureCardLayout);
            this._structurePanel.add((Component)new ThrobberLabel(), GUI_THROBBER);
            this._structurePanel.add(this._delegate.getGUI(), GUI_STRUCTURE);
            this._structurePanel.setOpaque(false);
            this._gui = this._structurePanel;
            this.updateStructureVisibility();
        }
        return this._gui;
    }

    public void setContext(Context context) {
        this._context = context;
        this._viewer = (VHVViewer)context.getView();
        this._viewer.getProgressObservable().addObserver(this);
        this.updateStructure();
        this.updateStructureVisibility();
    }

    protected Element getElementForContext(Context context) {
        return null;
    }

    @Override
    public final void update(Observable o, Object arg) {
        this.updateStructure();
        this.updateStructureVisibility();
    }

    private final void resort(Comparator<ShapeNode> nodeComparator) {
        this._nodeComparator = nodeComparator;
        this.updateStructure();
    }

    private final void updateStructure() {
        DefaultFolder node = new DefaultFolder();
        Context context = new Context(this._context);
        context.setElement((Element)node);
        if (this._context != null && this._viewer != null && !this._viewer.isInProgress() && this._viewer.getVersionTreeDiagram() != null) {
            ArrayList<ShapeNode> shapeNodes = new ArrayList<ShapeNode>();
            for (GraphShape shape : this._viewer.getVersionTreeDiagram().getShapeList()) {
                GraphElement ge = shape.getGraphElement();
                VHVResource resource = ge.getResource();
                ResourceType type = null;
                if (resource instanceof VHVBranchResource) {
                    type = ResourceType.BRANCH;
                }
                if (resource instanceof VHVMergeResource) {
                    type = ResourceType.MERGE;
                }
                if (resource instanceof VHVVersionableResource) {
                    type = ResourceType.VERSION;
                }
                if (type == null) continue;
                shapeNodes.add(new ShapeNode(shape, ge.getResource(), type));
            }
            Collections.sort(shapeNodes, this._nodeComparator);
            for (ShapeNode shapeNode : shapeNodes) {
                node.add((Element)shapeNode);
            }
        }
        this._setContext(context);
    }

    private final void updateStructureVisibility() {
        if (this._gui == null || this._viewer == null) {
            return;
        }
        if (this._viewer.isInProgress()) {
            this._structureCardLayout.show(this._structurePanel, GUI_THROBBER);
        } else {
            this._structureCardLayout.show(this._structurePanel, GUI_STRUCTURE);
        }
    }

    private final class DelegateExplorer
    extends BaseTreeExplorer {
        private final ContextMenu _contextMenu = new ContextMenu();

        private DelegateExplorer() {
        }

        final void setRoot_(Element e) {
            this.setRoot(e);
        }

        public ContextMenu getContextMenu() {
            return this._contextMenu;
        }
    }

    private static enum ResourceType {
        BRANCH,
        VERSION,
        MERGE;

    }

    private class ShapeNode
    extends Node {
        private final GraphShape _shape;
        private final VHVResource _resource;
        private final ResourceType _type;

        ShapeNode(GraphShape shape, VHVResource resource, ResourceType type) {
            this._shape = shape;
            this._resource = resource;
            this._type = type;
        }

        final GraphShape getShape() {
            return this._shape;
        }

        final VHVResource getResource() {
            return this._resource;
        }

        final ResourceType getType() {
            return this._type;
        }

        public final Icon getIcon() {
            if (this._type == ResourceType.BRANCH) {
                return VHVArb.getIcon(111);
            }
            if (this._type == ResourceType.VERSION) {
                return VHVArb.getIcon(112);
            }
            if (this._type == ResourceType.MERGE) {
                return VHVArb.getIcon(113);
            }
            throw new IllegalStateException();
        }

        public String getShortLabel() {
            try {
                if (this._type == ResourceType.BRANCH) {
                    return VHVArb.format(108, this._resource.getName());
                }
                if (this._type == ResourceType.VERSION) {
                    return VHVArb.format(110, this.getVersionLabel((VHVVersionableResource)this._resource));
                }
                if (this._type == ResourceType.MERGE) {
                    VHVMergeResource merge = (VHVMergeResource)this._resource;
                    return VHVArb.format(109, this.getVersionLabel((VHVVersionableResource)merge.getSource()), this.getVersionLabel((VHVVersionableResource)merge.getTarget()));
                }
            }
            catch (VHVResourceException vhvre) {
                vhvre.printStackTrace();
            }
            return "";
        }

        private final String getVersionLabel(VHVVersionableResource resource) throws VHVResourceException {
            return resource.getBranch().getName() + "/" + resource.getVersionLabel();
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public String getToolTipText() {
            return null;
        }
    }
}

