/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.impl;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public class LocalActionCache {
    private final View _view;
    private final Map<Integer, IdeAction> _cache = new HashMap<Integer, IdeAction>();

    public LocalActionCache(View view) {
        this._view = view;
    }

    public IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = this._cache.get(cmdId);
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.find((int)cmdId);
        if (ideAction == null) {
            throw new IllegalArgumentException("CMDID " + cmdId + " not found");
        }
        ideAction = ideAction.newLocalAction(this._view);
        if (cmdId != 51) {
            this._cache.put(cmdId, ideAction);
        }
        return ideAction;
    }

    public IdeAction findLocalAction(int cmdId) {
        return this._cache.get(cmdId);
    }

    public IdeAction[] getCachedActions() {
        return this._cache.values().toArray(new IdeAction[0]);
    }
}

