/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.net.URL;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.javaxide.Util;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;

public final class VCSListenerHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-listener-hook");
    private static final ElementName LISTENER_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "listener-class");
    private static final ElementName URL_FILTER_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "url-filter-class");
    private final ElementVisitor _listenerClassHandler = new ListenerClassHandler();
    private final ElementVisitor _urlFilterClassHandler = new URLFilterClassHandler();
    private static final String KEY_SCOPE_LISTENER = "oide_vcs_listener";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(LISTENER_CLASS, this._listenerClassHandler);
        context.registerChildVisitor(URL_FILTER_CLASS, this._urlFilterClassHandler);
        context.getScopeData().put(KEY_SCOPE_LISTENER, new ScopeListenerBean());
    }

    public void end(ElementEndContext context) {
        ScopeListenerBean bean = (ScopeListenerBean)context.getScopeData().get(KEY_SCOPE_LISTENER);
        VCSManager.getVCSManager().addVCSListener(new MetaClassVCSListener(bean._listenerClass), bean._urlFilterClass != null ? new MetaClassURLFilter(bean._urlFilterClass) : null);
    }

    private final class ListenerClassHandler
    extends MetaClassVisitor {
        private ListenerClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((ScopeListenerBean)context.getScopeData().get((Object)VCSListenerHook.KEY_SCOPE_LISTENER))._listenerClass = mc;
        }
    }

    private final class URLFilterClassHandler
    extends MetaClassVisitor {
        private URLFilterClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((ScopeListenerBean)context.getScopeData().get((Object)VCSListenerHook.KEY_SCOPE_LISTENER))._urlFilterClass = mc;
        }
    }

    private class ScopeListenerBean {
        private MetaClass _listenerClass;
        private MetaClass _urlFilterClass;

        private ScopeListenerBean() {
        }
    }

    private final class MetaClassVCSListener
    implements VCSListener {
        private final MetaClass _metaClass;
        private VCSListener _delegate;

        MetaClassVCSListener(MetaClass metaClass) {
            this._metaClass = metaClass;
        }

        @Override
        public final void notifyEvent(VCSEvent event) {
            if (this._delegate == null) {
                this._delegate = Util.createInstance(this._metaClass, VCSListener.class);
                if (this._delegate == null) {
                    this._delegate = new VCSListener(){

                        @Override
                        public final void notifyEvent(VCSEvent event) {
                        }
                    };
                }
            }
            this._delegate.notifyEvent(event);
        }
    }

    private final class MetaClassURLFilter
    implements URLFilter {
        private final MetaClass _metaClass;
        private URLFilter _delegate;

        MetaClassURLFilter(MetaClass metaClass) {
            this._metaClass = metaClass;
        }

        public final boolean accept(URL url) {
            if (this._delegate == null) {
                this._delegate = Util.createInstance(this._metaClass, URLFilter.class);
                if (this._delegate == null) {
                    this._delegate = new URLFilter(){

                        public final boolean accept(URL url) {
                            return true;
                        }
                    };
                }
            }
            return this._delegate.accept(url);
        }
    }
}

