/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Future;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSTask;
import oracle.ideimpl.vcs.VCSContextUtil;

public class NullVCSManager
extends VCSManager {
    private static final NullVCSManager _instance = new NullVCSManager();

    public static NullVCSManager getInstance() {
        return _instance;
    }

    @Override
    public Future<Boolean> checkOutUsingUI(VCSTask task) {
        this.getTaskProperties(task).put("operation", "checkout");
        task.run();
        return task;
    }

    @Override
    public boolean checkOut(URL[] urls) {
        for (URL url : urls) {
            if (!URLFileSystem.isReadOnly((URL)url)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isVersioned(URL url) {
        return false;
    }

    @Override
    @Deprecated
    public boolean isAutoCheckOutEnabled(URL url) {
        return false;
    }

    @Override
    public boolean canCheckOut(URL url) {
        return false;
    }

    @Override
    @Deprecated
    public boolean checkOutNode(Node node) {
        return false;
    }

    @Override
    @Deprecated
    public boolean checkOutNode(Node node, CommandProcessor processor) {
        return false;
    }

    @Override
    public String getCheckOutCommand(Node node) {
        return null;
    }

    @Override
    public MetaClass getMetaCheckOutCommand(Node node) {
        return null;
    }

    @Override
    public void validateStatus(URL url) {
    }

    @Override
    public String getRevisionIdentifier(URL url) throws Exception {
        return null;
    }

    @Override
    public InputStream getRevisionContent(URL url, String revision) throws IOException {
        return null;
    }

    @Override
    public Collection<URL> getAllModifiedFiles(URL url) throws Exception {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public void validateStatus(URLFilter filter) {
    }

    @Override
    public void validateStatus(URL[] urls) {
    }

    @Override
    public String getVersionName(URL url) {
        return null;
    }

    @Override
    @Deprecated
    public boolean setReadWrite(URL[] urls) {
        return false;
    }

    @Override
    public boolean containsConflicts(URL url) {
        return false;
    }

    @Override
    public InputStream openConflictsStreamAsContributor(URL url) throws IOException {
        return URLFileSystem.openInputStream((URL)url);
    }

    @Override
    public ContextMenuListener[] getContextMenuListeners() {
        return new ContextMenuListener[0];
    }

    @Override
    public Locatable[] getContextLocatables(Context context) {
        return VCSContextUtil.getContextLocatables(context);
    }

    @Override
    protected boolean executeTaskImpl(VCSTask task) {
        if ("checkout".equals(this.getTaskProperties(task).get("operation"))) {
            return this.checkOut(task.getURLs());
        }
        return false;
    }
}

