/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.Version;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import org.xml.sax.SAXException;

public final class RoleLayoutShapingProvider {
    private static RoleLayoutShapingProvider roleLayoutShapingProvider;
    private static final String POSITION_DOCKING_ZONE_ARG = "docking-zone";
    private static final String DOCKING_POSITION_ARG = "positions";
    private static final String DOCKABLE_ID_ARG = "id";
    private static final String LAYOUT_ID_ARG = "name";
    private static final String DOCKABLE_STATES_ARG = "states";
    private static final String DOCKABLE_STATE_ARG = "state";
    private static final String DOCKABLE_TABBED_ARG = "tabbed";
    private static final String POSITION_REFERENCE_ARG = "reference";
    private static final String POSITION_ORIENTATION_ARG = "orientation";
    private static final String POSITION_GLOBAL_ARG = "global";
    private DefaultStructuredPropertyAccess structure;
    private Map<URL, Boolean> shapingFilesToLoad;
    private static String activeRoleID;

    public static synchronized RoleLayoutShapingProvider getInstance() {
        if (roleLayoutShapingProvider == null) {
            roleLayoutShapingProvider = new RoleLayoutShapingProvider();
        }
        return roleLayoutShapingProvider;
    }

    private RoleLayoutShapingProvider() {
    }

    public synchronized String getDockingZone(String dockableId) {
        return this.getPositionValue(dockableId, POSITION_DOCKING_ZONE_ARG);
    }

    public synchronized DockableState getState(String layoutName, String dockableId) {
        this.loadShapingFiles();
        if (this.structure == null) {
            return null;
        }
        String state = this.getValueFromLayout(layoutName, dockableId);
        if (state == null) {
            return null;
        }
        DockableState enumState = null;
        try {
            enumState = DockableState.valueOf(state);
        }
        catch (IllegalArgumentException iae) {
            if (Version.DEBUG_BUILD == 1) {
                Logger.getAnonymousLogger().warning("Incorrect value " + state + " in the role layout shaping file");
            }
            iae.printStackTrace();
        }
        return enumState;
    }

    public synchronized String getReference(String dockableId) {
        return this.getPositionValue(dockableId, POSITION_REFERENCE_ARG);
    }

    public synchronized String getOrientation(String dockableId) {
        return this.getPositionValue(dockableId, POSITION_ORIENTATION_ARG);
    }

    public synchronized String getGlobal(String dockableId) {
        return this.getPositionValue(dockableId, POSITION_GLOBAL_ARG);
    }

    public synchronized String getPositionValue(String dockableId, String argument) {
        this.loadShapingFiles();
        if (this.structure == null) {
            return null;
        }
        return this.getValue(dockableId, this.structure.getChildNodes(DOCKING_POSITION_ARG), DOCKABLE_ID_ARG, argument);
    }

    public synchronized boolean isTabbed(String dockableId) {
        this.loadShapingFiles();
        if (this.structure == null) {
            return false;
        }
        String tabbed = this.getValue(dockableId, this.structure.getChildNodes(DOCKING_POSITION_ARG), DOCKABLE_ID_ARG, DOCKABLE_TABBED_ARG);
        if (tabbed == null) {
            return false;
        }
        return Boolean.valueOf(tabbed);
    }

    private String getValue(String dockableId, Iterator<StructuredPropertyAccess> iter, String ... arguments) {
        String value = null;
        while (iter.hasNext()) {
            StructuredPropertyAccess root = iter.next();
            String value_ = this.getArgValue(root, dockableId, arguments[0], arguments[1]);
            if (value_ == null) continue;
            value = value_;
        }
        return value;
    }

    void addShapingFile(URL url) {
        if (this.shapingFilesToLoad == null) {
            this.shapingFilesToLoad = new HashMap<URL, Boolean>();
        }
        this.shapingFilesToLoad.put(url, false);
        if (Version.DEBUG_BUILD == 1) {
            Logger.getAnonymousLogger().fine("Role Layout Shaping file: " + url.getPath());
        }
    }

    private void loadShapingFiles() {
        if (this.shapingFilesToLoad == null || this.shapingFilesToLoad.isEmpty()) {
            return;
        }
        for (URL url : this.shapingFilesToLoad.keySet()) {
            if (this.shapingFilesToLoad.get(url).booleanValue()) continue;
            if (this.structure == null) {
                this.structure = this.loadShapingfile(url);
            } else {
                this.structure.addAll(this.loadShapingfile(url));
            }
            this.shapingFilesToLoad.put(url, true);
        }
    }

    private DefaultStructuredPropertyAccess loadShapingfile(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null URL - shaping file.");
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            try {
                return DefaultStructuredPropertyAccess.loadFromXML(inputStream);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getValueFromLayout(String layoutName, String dockableId) {
        String value = null;
        Iterator states = this.structure.getChildNodes(DOCKABLE_STATES_ARG);
        if (states != null) {
            while (states.hasNext()) {
                StructuredPropertyAccess root = (StructuredPropertyAccess)states.next();
                Iterator childNodes = root.getChildNodes();
                while (childNodes.hasNext()) {
                    StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                    Iterator iter = child.getProperties();
                    String name = null;
                    while (iter.hasNext()) {
                        String value_;
                        String id;
                        name = (String)iter.next();
                        if (!name.equals(LAYOUT_ID_ARG) || !(id = child.getProperty(name, null)).equals(layoutName) || (value_ = this.getArgValue(child, dockableId, DOCKABLE_ID_ARG, DOCKABLE_STATE_ARG)) == null) continue;
                        value = value_;
                    }
                }
            }
        }
        return value;
    }

    public Collection<String> getAllDockablesInState(String layoutName, DockableState state) {
        if (this.structure == null) {
            return Collections.emptySet();
        }
        Iterator states = this.structure.getChildNodes(DOCKABLE_STATES_ARG);
        HashSet<String> dockableIds = new HashSet<String>();
        if (states != null) {
            while (states.hasNext()) {
                StructuredPropertyAccess root = (StructuredPropertyAccess)states.next();
                Iterator childNodes = root.getChildNodes();
                while (childNodes.hasNext()) {
                    StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                    Iterator iter = child.getProperties();
                    String name = null;
                    while (iter.hasNext()) {
                        String id;
                        name = (String)iter.next();
                        if (!name.equals(LAYOUT_ID_ARG) || !(id = child.getProperty(name, null)).equals(layoutName)) continue;
                        Collection<String> dockablesIds_ = this.getAllDockableForValue(child, state, DOCKABLE_ID_ARG, DOCKABLE_STATE_ARG);
                        dockableIds.addAll(dockablesIds_);
                    }
                }
            }
        }
        return dockableIds;
    }

    private String getArgValue(StructuredPropertyAccess root, String dockableId, String ... arguments) {
        if (root != null) {
            Iterator childNodes = root.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                Iterator iter = child.getProperties();
                String name = null;
                String id = null;
                String value = null;
                while (iter.hasNext()) {
                    String id_;
                    name = (String)iter.next();
                    if (name.equals(arguments[0]) && (id_ = child.getProperty(name, null)).equals(dockableId)) {
                        id = id_;
                    }
                    if (!name.equals(arguments[1])) continue;
                    value = child.getProperty(name, null);
                }
                if (id == null || value == null) continue;
                return value;
            }
        }
        return null;
    }

    private Collection<String> getAllDockableForValue(StructuredPropertyAccess root, DockableState state, String ... arguments) {
        HashSet<String> dockableIds = new HashSet<String>();
        if (root != null) {
            Iterator childNodes = root.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                Iterator iter = child.getProperties();
                String name = null;
                String id = null;
                String value = null;
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    if (name.equals(arguments[0])) {
                        id = child.getProperty(name, null);
                    }
                    if (name.equals(arguments[1])) {
                        value = child.getProperty(name, null);
                    }
                    if (id == null || value == null || DockableState.valueOf(value) != state) continue;
                    dockableIds.add(id);
                }
            }
        }
        return dockableIds;
    }

    private Collection<String> getDockableIds(StructuredPropertyAccess root, String ... arguments) {
        ArrayList<String> dockablesIds = new ArrayList<String>();
        if (root != null) {
            Iterator childNodes = root.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                Iterator iter = child.getProperties();
                String name = null;
                Object id = null;
                Object value = null;
                while (iter.hasNext()) {
                    String id_;
                    name = (String)iter.next();
                    if (!name.equals(arguments[0]) || (id_ = child.getProperty(name, null)) == null) continue;
                    dockablesIds.add(id_);
                }
            }
        }
        return null;
    }

    static String getActiveRoleID() {
        if (activeRoleID == null) {
            activeRoleID = ExtensionManagerImpl.getExtensionRegistry().getRoleManager().getActiveRole().getId();
        }
        return activeRoleID;
    }

    private static void setActiveRoleID(String activeRoleID) {
        RoleLayoutShapingProvider.activeRoleID = activeRoleID;
    }

    public static enum DockableState {
        MINIMIZED,
        VISIBLE,
        HIDDEN;

    }
}

