/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaResource;
import oracle.ide.Version;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ideimpl.layout.RoleLayoutShapingProvider;
import oracle.javatools.data.HashStructure;

public final class RoleLayoutShapingHook
extends HashStructureHook {
    private static final String FILE_ARG = "file";
    private static final String ROLE_ID_ARG = "roleId";
    private static final String PATH_ARG = "path";
    private static final String ALL_ROLES = "all_roles";

    public RoleLayoutShapingHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                RoleLayoutShapingHook.this.addArgument(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
                RoleLayoutShapingHook.this.addArgument(e.getNewElementHashStructure());
            }
        });
    }

    private void addArgument(HashStructure hashStructure) {
        if (hashStructure == null) {
            return;
        }
        List list = hashStructure.getAsList(FILE_ARG);
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            HashStructure layoutCustomFileHash = (HashStructure)obj;
            String roleId = layoutCustomFileHash.getString(ROLE_ID_ARG);
            String path = layoutCustomFileHash.getString(PATH_ARG);
            if (roleId == null && Version.DEBUG_BUILD == 1) {
                Logger.getLogger("global").log(Level.SEVERE, "extension " + RoleLayoutShapingHook.getExtensionId(hashStructure) + " is attempting to register a role shaping layout file with no roleId");
            }
            if (path == null && Version.DEBUG_BUILD == 1) {
                Logger.getLogger("global").log(Level.SEVERE, "extension " + RoleLayoutShapingHook.getExtensionId(hashStructure) + " is attempting to register a role shaping layout file with no path");
            }
            MetaResource metaResource = LazyResourceAdapter.getInstance(layoutCustomFileHash).getMetaResource(PATH_ARG);
            if (!roleId.equals(RoleLayoutShapingProvider.getActiveRoleID()) && !roleId.equalsIgnoreCase(ALL_ROLES)) continue;
            RoleLayoutShapingProvider.getInstance().addShapingFile(metaResource.toURL());
        }
    }
}

