/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Action;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.layout.LayoutsImpl;
import org.openide.filesystems.FileUtil;

public class ResetLayoutController
implements Controller {
    private static final int RESET_WINDOW_LAYOUT_CMD_ID = Ide.findOrCreateCmdID("RESET_WINDOW_LAYOUT_CMD");

    public static IdeAction resetWindowsAction() {
        ResetLayoutController.createResetWindowsAction();
        return IdeAction.find(RESET_WINDOW_LAYOUT_CMD_ID);
    }

    private static void createResetWindowsAction() {
        IdeAction action = IdeAction.get(RESET_WINDOW_LAYOUT_CMD_ID, (String)null, StringUtils.stripMnemonic((String)IdeArb.getString(492)), IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)IdeArb.getString(492)), (ResourceBundle)IdeArb.getInstance(), null, null, true);
        action.addController(new ResetLayoutController());
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == RESET_WINDOW_LAYOUT_CMD_ID) {
            return ResetLayoutController.resetWindowManager();
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == RESET_WINDOW_LAYOUT_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean resetWindowManager() {
        ActionListener resetAction = (ActionListener)FileUtil.getConfigObject((String)"/Actions/Window/com-oracle-jdeveloper-nbwindowsystem-ResetWindowsAction.instance", Action.class);
        if (resetAction == null && WindowManagerStartingController.getInstance() == null) {
            resetAction = DockStationImpl.getInstance().getResetAction();
            Logger.getAnonymousLogger().info("Reset Action - Old Window Manager");
        } else if (WindowManagerStartingController.getInstance() == null) {
            throw new IllegalStateException("No reset action");
        }
        LayoutsImpl.getInstance().restoreLayoutsToFactorySettings(resetAction);
        if (WindowManagerStartingController.getInstance() == null) {
            ShutterManager.getInstance().hideShutterPanel(4);
        }
        return true;
    }
}

