/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ideimpl.extension.preference.ManageFeaturesPanel;
import oracle.ideimpl.extension.preference.ManageUpdatesPanel;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.ui.ControlBar;

public class ManageFeaturesAndUpdatesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel roleLabel = new JLabel();
    private JTextField roleTextField = new JTextField();
    private JTabbedPane tabbedPanel = new PreventSwitchingTabbedPane();
    private ManageFeaturesPanel _featuresPanel;
    private ManageUpdatesPanel _manageUpdatesPanel;
    private boolean _updatesPanelInitialized;

    public ManageFeaturesAndUpdatesPanel(ManageFeaturesPanel featuresPanel) {
        this._featuresPanel = featuresPanel;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean shouldClose() {
        boolean yes = true;
        if (this._featuresPanel.haveDisabledIdsChanged() || this._manageUpdatesPanel.hasChanges()) {
            yes = this.confirmPendingChangesDialog(ManageFeaturesArb.getString(32), ManageFeaturesArb.getString(33));
        }
        return yes;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._manageUpdatesPanel = new ManageUpdatesPanel();
        this._featuresPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabbedPanel.addTab(ManageFeaturesArb.getString(21), this._featuresPanel);
        this._manageUpdatesPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabbedPanel.addTab(ManageFeaturesArb.getString(22), this._manageUpdatesPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        gbc.anchor = 19;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 8, 0);
        this.add((Component)this.createDescriptionPanel(), gbc);
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.tabbedPanel, gbc);
    }

    private boolean confirmPendingChangesDialog(String question, String whatResult) {
        JEditorPane editor = new JEditorPane();
        editor.setEditorKit(new DescriptionPaneEditorKit());
        StringBuilder b = new StringBuilder();
        b.append("<p>");
        b.append("<b>");
        b.append(question);
        b.append("</b>");
        b.append("</p>");
        b.append("<br>");
        b.append("<p>");
        b.append(whatResult);
        b.append("</p>");
        b.append("<br>");
        editor.setText(ManageFeaturesAndUpdatesPanel.html(b.toString()));
        editor.setOpaque(false);
        BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)this, (String)ManageFeaturesArb.getString(34), (int)4);
        dialog.setMessage((Object)editor);
        boolean ok = dialog.runDialog();
        return ok;
    }

    private static String html(String string) {
        return "<html><body>" + string + "</body></html>";
    }

    private JPanel createDescriptionPanel() {
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new GridBagLayout());
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        RoleManager roleManager = extensionRegistry.getRoleManager();
        if (roleManager.canSwitchRoles()) {
            this.roleLabel.setText(ManageFeaturesArb.getString(23));
            descriptionPanel.add((Component)this.roleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 5, 0));
            Role activeRole = roleManager.getActiveRole();
            this.roleTextField.setText(activeRole.getName());
            this.roleTextField.setEditable(false);
            descriptionPanel.add((Component)this.roleTextField, new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 21, 2, new Insets(0, 0, 0, 100), 5, 0));
        } else {
            descriptionPanel.add(Box.createVerticalStrut(new JTextField().getPreferredSize().height), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 5, 0));
        }
        ControlBar bar = new ControlBar();
        this.addCheckForUpdatesMenuButton(bar);
        descriptionPanel.add((Component)bar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 2, new Insets(0, 0, 0, 5), 0, 0));
        return descriptionPanel;
    }

    private void addCheckForUpdatesMenuButton(ControlBar bar) {
        String checkForUpdatesCmd = "CheckForUpdates";
        IdeAction checkForUpdatesAction = IdeAction.find(Ide.findCmdID("CheckForUpdates"));
        if (checkForUpdatesAction != null) {
            checkForUpdatesAction.putValue("ShortDescription", checkForUpdatesAction.getValue("Name"));
            int cmdID = Ide.findOrCreateCmdID("internal-auto-check-for-updates-cmdId");
            IdeAction checkOnStartupAction = IdeAction.get(cmdID);
            checkOnStartupAction.putValue("Name", ManageFeaturesArb.getString(9));
            checkOnStartupAction.putValue("MnemonicKey", ManageFeaturesArb.getInteger(10));
            checkOnStartupAction.putValue("Check", Boolean.TRUE);
            Controller controller = new Controller(){

                @Override
                public boolean handleEvent(IdeAction action, Context context) {
                    boolean checked = action.getState();
                    this.checkForUpdatePrefs().setCheckOnStartup(checked);
                    return true;
                }

                @Override
                public boolean update(IdeAction action, Context context) {
                    boolean checked = this.checkForUpdatePrefs().isCheckOnStartup();
                    action.setState(checked);
                    action.setEnabled(true);
                    return true;
                }

                private CheckForUpdatePrefsAdapter checkForUpdatePrefs() {
                    return CheckForUpdatePrefsAdapter.getInstance(Preferences.getPreferences());
                }
            };
            checkOnStartupAction.addController(controller);
            MenuToolButton menu = new MenuToolButton(checkForUpdatesAction);
            String menuText = ManageFeaturesArb.getString(31);
            menu.setText(StringUtils.stripMnemonic((String)menuText));
            menu.setMnemonic(StringUtils.getMnemonicKeyCode((String)menuText));
            menu.addPopupItem(checkForUpdatesAction);
            menu.addPopupItem(checkOnStartupAction);
            bar.add((Component)menu);
        }
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" }");
        return rule.toString();
    }

    private class PreventSwitchingTabbedPane
    extends JTabbedPane {
        private PreventSwitchingTabbedPane() {
        }

        @Override
        public void setSelectedIndex(int index) {
            boolean yes = true;
            if (index == 1) {
                if (ManageFeaturesAndUpdatesPanel.this._featuresPanel.haveDisabledIdsChanged()) {
                    yes = ManageFeaturesAndUpdatesPanel.this.confirmPendingChangesDialog(ManageFeaturesArb.getString(27), ManageFeaturesArb.getString(28));
                }
                if (yes && !ManageFeaturesAndUpdatesPanel.this._updatesPanelInitialized) {
                    ManageFeaturesAndUpdatesPanel.this._manageUpdatesPanel.populate();
                    ManageFeaturesAndUpdatesPanel.this._updatesPanelInitialized = true;
                }
            } else if (ManageFeaturesAndUpdatesPanel.this._manageUpdatesPanel.hasChanges()) {
                yes = ManageFeaturesAndUpdatesPanel.this.confirmPendingChangesDialog(ManageFeaturesArb.getString(29), ManageFeaturesArb.getString(30));
            }
            if (yes) {
                super.setSelectedIndex(index);
                String id = 0 == index ? "f1_idedidemangefeatures_html" : "f1_managefeatures_instupdates_html";
                HelpUtils.setHelpID((JComponent)ManageFeaturesAndUpdatesPanel.this, (String)id);
            }
        }
    }

    private static class DescriptionPaneEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;

        private DescriptionPaneEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(ManageFeaturesAndUpdatesPanel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            try (StringReader r = null;){
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            return ss;
        }
    }

    private static class CheckForUpdatePrefsAdapter
    extends HashStructureAdapter {
        private static final String DATA_KEY = "oracle.ideimpl.webupdate.CheckForUpdatesPreferences";
        private static final String KEY_AUTOCHECK = "checkOnStartup";

        private CheckForUpdatePrefsAdapter(HashStructure hs) {
            super(hs);
        }

        public static CheckForUpdatePrefsAdapter getInstance(PropertyStorage ps) {
            return new CheckForUpdatePrefsAdapter(CheckForUpdatePrefsAdapter.findOrCreate((PropertyStorage)ps, (String)DATA_KEY));
        }

        public boolean isCheckOnStartup() {
            return this._hash.getBoolean(KEY_AUTOCHECK, true);
        }

        public void setCheckOnStartup(boolean checkOnStartup) {
            this._hash.putBoolean(KEY_AUTOCHECK, checkOnStartup);
        }
    }
}

