/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.feature;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.XMLParsingUtils;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ideimpl.extension.feature.FeatureRegistryImpl;
import oracle.ideimpl.extension.feature.LazyTextCallable;

public class FeatureCategoryVisitor
extends ElementVisitor {
    public static final ElementName FEATURE_CATEGORY_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "feature-category");
    private static final ElementName _NAME_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "name");
    private static final ElementName _DESCRIPTION_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "description");
    private static final String _ID_ATTR = "id";
    private static final String _KEY_FEATURE_CATEGORY = "feature-category-key";
    private static final Logger _sLogger = Logger.getLogger(FeatureCategoryVisitor.class.getName());

    public void start(ElementStartContext context) {
        String id = this.getAttributeHelper(context, _ID_ATTR, true, true);
        if (id != null) {
            FeatureCategoryImpl featureCategory = new FeatureCategoryImpl(id, (ElementContext)context);
            FeatureCategoryImpl parent = (FeatureCategoryImpl)context.getScopeData().get(_KEY_FEATURE_CATEGORY);
            if (parent != null) {
                registered = parent.registerSubCategory(featureCategory);
                if (!registered) {
                    this.log((ElementContext)context, Level.SEVERE, "Duplicate feature-category id encountered: " + featureCategory.getId());
                    return;
                }
            } else {
                registered = FeatureRegistryImpl.getInstance().__registerFeatureCategory(featureCategory);
                if (!registered) {
                    this.log((ElementContext)context, Level.SEVERE, "Duplicate feature-category id encountered: " + featureCategory.getId());
                    return;
                }
            }
            context.getScopeData().put(_KEY_FEATURE_CATEGORY, featureCategory);
            LazyTextCallable nameCallable = new LazyTextCallable();
            context.registerChildVisitor(_NAME_ELEMENT, (ElementVisitor)nameCallable);
            featureCategory.setDisplayName(nameCallable);
            LazyTextCallable descriptionCallable = new LazyTextCallable();
            context.registerChildVisitor(_DESCRIPTION_ELEMENT, (ElementVisitor)descriptionCallable);
            featureCategory.setDescription(descriptionCallable);
            context.registerChildVisitor(FEATURE_CATEGORY_ELEMENT, (ElementVisitor)this);
        }
    }

    private class FeatureCategoryImpl
    extends FeatureCategory {
        private String _owningExtension;
        private LocationAdapter _locator;
        private Callable<String> _displayNameCallable;
        private Callable<String> _descriptionCallable;
        private ConcurrentHashMap<String, FeatureCategory> _subCategoryMap;

        public FeatureCategoryImpl(String identifier, ElementContext context) {
            super(identifier);
            this._displayNameCallable = null;
            this._descriptionCallable = null;
            this._subCategoryMap = new ConcurrentHashMap();
            this._owningExtension = context.getExtension().getID();
            this._locator = XMLParsingUtils.copyAndCastToLocationAdapter(context.getScopeData().get("xml.locator"));
        }

        @Override
        public String getOwningExtensionId() {
            return this._owningExtension;
        }

        @Override
        public LocationAdapter getLocator() {
            return this._locator;
        }

        public void setDisplayName(Callable<String> displayNameCallable) {
            this._displayNameCallable = displayNameCallable;
        }

        @Override
        protected String getDisplayNameImpl() {
            String displayName = null;
            if (this._displayNameCallable != null) {
                try {
                    displayName = this._displayNameCallable.call();
                }
                catch (Exception e) {
                    _sLogger.log(Level.SEVERE, "Unexpected exception while processing feature display name", e);
                }
            }
            return displayName;
        }

        public void setDescription(Callable<String> descriptionCallable) {
            this._descriptionCallable = descriptionCallable;
        }

        @Override
        public String getDescription() {
            String description = null;
            if (this._descriptionCallable != null) {
                try {
                    description = this._descriptionCallable.call();
                }
                catch (Exception e) {
                    _sLogger.log(Level.SEVERE, "Unexpected exception while processing feature description", e);
                }
            }
            return description;
        }

        @Override
        public Iterator<FeatureCategory> getSubCategories() {
            return this._subCategoryMap.values().iterator();
        }

        @Override
        public FeatureCategory getSubCategory(String identifier) {
            return this._subCategoryMap.get(identifier);
        }

        public boolean registerSubCategory(FeatureCategory subCategory) {
            FeatureCategory previous = this._subCategoryMap.putIfAbsent(subCategory.getId(), subCategory);
            return previous == null;
        }
    }
}

