/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.OnDemandElementVisitorListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.controller.ActionFilter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ideimpl.controller.IdeActionHook;
import oracle.ideimpl.extension.MenuCustomizationHook;
import oracle.ideimpl.extension.OldStyleMenuUtil;
import oracle.javatools.data.HashStructure;

public final class MenuShapingAddin
implements Addin {
    @Override
    public void initialize() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        ShapingHandler shapingHandler = new ShapingHandler();
        MenuCustomizationHook customizationHook = (MenuCustomizationHook)extensionRegistry.getHook(MenuCustomizationHook.NAME);
        customizationHook.addHashStructureHookListener(shapingHandler);
        IdeActionHook actionHook = (IdeActionHook)extensionRegistry.getHook(IdeActionHook.ELEMENT);
        actionHook.addActionsRegListener(shapingHandler);
    }

    private static class ShapingHandler
    implements ActionFilter,
    MenuFilter,
    HashStructureHookListener,
    OnDemandElementVisitorListener {
        final Set<String> _hiddenItems = new HashSet<String>();
        final Set<String> _disabledItems = new HashSet<String>();

        private ShapingHandler() {
        }

        @Override
        public void listenerAttached(HashStructureHookEvent e) {
            OldStyleMenuUtil.create(e.getCombinedHashStructure());
            ToolbarManager.getToolbarManager().addActionFilter(this);
            Toolbar.addToolbarFilter(this);
            MultiMapAdapter.addActionFilter(this);
            Ide.getMenubar().addMenuFilter(this);
            MenuCustomizationHook customizationHook = (MenuCustomizationHook)e.getHashStructureHook();
            this.doShaping(customizationHook, e.getCombinedHashStructure());
        }

        @Override
        public void elementVisited(HashStructureHookEvent e) {
            MenuCustomizationHook customizationHook = (MenuCustomizationHook)e.getHashStructureHook();
            this.doShaping(customizationHook, e.getNewElementHashStructure());
        }

        private void doShaping(MenuCustomizationHook customizationHook, HashStructure hash) {
            if (hash == null) {
                return;
            }
            HashSet<String> hidden = new HashSet<String>(customizationHook.getHiddenMenuComponents(hash));
            if (!this._hiddenItems.isEmpty()) {
                hidden.removeAll(this._hiddenItems);
            }
            this._hiddenItems.addAll(hidden);
            this.hide(this._hiddenItems);
            List<String> disabledActionIds = customizationHook.getPermanentlyUnavailableActions(hash);
            this._disabledItems.addAll(disabledActionIds);
            this.disableHiddenActions(disabledActionIds, true);
        }

        private void hide(Collection<String> hiddenIds) {
            if (!hiddenIds.isEmpty()) {
                this.disableHiddenActions(hiddenIds, false);
                this.hideMenuItems();
                this.hideToolbarItems();
            }
        }

        private void disableHiddenActions(Collection<String> newIds, final boolean permanentlyDisable) {
            for (String cmdName : newIds) {
                IdeAction action;
                Integer cmdID = Ide.findCmdID(cmdName);
                if (cmdID == null || (action = IdeAction.find(cmdID)) == null) continue;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        action.setEnabled(false);
                        if (permanentlyDisable) {
                            action.putValue("oracle.ide.IdeAction.permanently-disable", Boolean.TRUE);
                        }
                    }
                };
                this.ensureSwingCallsAreOnEDT(runnable);
            }
        }

        private void hideMenuItems() {
            JMenuBar mb = Ide.getMainWindow().getJMenuBar();
            if (mb != null) {
                for (int i = 0; i < mb.getMenuCount(); ++i) {
                    final JMenu menu = mb.getMenu(i);
                    if (!this.accept(menu)) {
                        this.ensureSwingCallsAreOnEDT(new Runnable(){

                            @Override
                            public void run() {
                                Ide.getMenubar().remove(menu);
                            }
                        });
                        --i;
                        continue;
                    }
                    this.filterMenuItems(menu);
                }
            }
        }

        private void filterMenuItems(final JMenu menu) {
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                final Component item = menu.getMenuComponent(i);
                if (!this.accept(item)) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            menu.remove(item);
                        }
                    };
                    this.ensureSwingCallsAreOnEDT(runnable);
                    --i;
                    continue;
                }
                if (!(item instanceof JMenu)) continue;
                this.filterMenuItems((JMenu)item);
            }
        }

        private void hideToolbarItems() {
            ToolbarManager.getToolbarManager().refilterActions();
        }

        private void ensureSwingCallsAreOnEDT(Runnable runnable) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        @Override
        public boolean accept(String cmdName) {
            boolean hidden = this._hiddenItems.contains(cmdName);
            if (IdeAction.DEBUG) {
                System.out.println((String)(hidden ? cmdName + " is hidden" : cmdName));
            }
            return !hidden;
        }

        @Override
        public boolean accept(Component component) {
            String componentId = this.getId(component);
            if (IdeAction.DEBUG) {
                System.out.print("ide.IdeAction.debug info: [MenuShapingAddin] " + (Serializable)(component != null ? component.getClass().getName() : component) + " ");
            }
            return this.accept(componentId);
        }

        private String getId(Component component) {
            if (component == null) {
                return "";
            }
            return Ide.getMenubar().getId(component);
        }

        public void starting(String extensionId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ended(String extensionId) {
            HashSet<String> disabled;
            ShapingHandler shapingHandler = this;
            synchronized (shapingHandler) {
                if (this._disabledItems == null || this._disabledItems.isEmpty()) {
                    return;
                }
                disabled = new HashSet<String>(this._disabledItems);
            }
            this.disableHiddenActions(disabled, true);
        }
    }
}

