/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerCacheSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

final class LayerBuilder {
    private static final String PUBLIC_DTD_ID = "-//NetBeans//DTD Filesystem 1.2//EN";
    private static final String NETWORK_DTD_URL = "http://www.netbeans.org/dtds/filesystem-1_2.dtd";
    private static final boolean PRETTY_PRINT = LayerCacheSupport.DEBUG_FOLDER != null;
    private static DocumentBuilderFactory factory;
    private final Document doc;
    private final Element originatingElement = null;
    private final List<File> unwrittenFiles = new LinkedList<File>();

    LayerBuilder() {
        this.doc = this.createLayerDocument();
    }

    private Document createLayerDocument() {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
        }
        try {
            DOMImplementation impl = factory.newDocumentBuilder().getDOMImplementation();
            DocumentType dtd = null;
            dtd = impl.createDocumentType("filesystem", PUBLIC_DTD_ID, NETWORK_DTD_URL);
            return impl.createDocument(null, "filesystem", dtd);
        }
        catch (ParserConfigurationException ex) {
            System.out.println(ex);
            return null;
        }
    }

    public byte[] getBytes() {
        if (this.doc != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DOMImplementationLS ls = (DOMImplementationLS)this.doc.getImplementation().getFeature("LS", "3.0");
            assert (ls != null) : "No DOM 3 LS supported in " + this.doc.getClass().getName();
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(baos);
            LSSerializer ser = ls.createLSSerializer();
            if (PRETTY_PRINT) {
                String fpp = "format-pretty-print";
                if (ser.getDomConfig().canSetParameter(fpp, true)) {
                    ser.getDomConfig().setParameter(fpp, true);
                }
            }
            ser.write(this.doc, output);
            byte[] data = baos.toByteArray();
            return data;
        }
        return null;
    }

    public File file(String path) {
        File f = new File(path, false);
        this.unwrittenFiles.add(f);
        return f;
    }

    public File folder(String path) {
        File f = new File(path, true);
        this.unwrittenFiles.add(f);
        return f;
    }

    void close() {
        for (File f : this.unwrittenFiles) {
            if (f.getPath().startsWith("dummy/")) continue;
            System.out.println("layer file " + f.getPath() + " was never written");
        }
        this.unwrittenFiles.clear();
    }

    public File instanceFile(String name, String type, String factoryClazz, String factoryMethod, String instanceOf) {
        File f = this.file(name + ".instance");
        if (factoryMethod == null && factoryClazz == null) {
            f.newvalue("instanceCreate", type);
        } else if (factoryClazz == null) {
            f.methodvalue("instanceCreate", type, factoryMethod);
        } else {
            if (factoryMethod == null) {
                throw new IllegalArgumentException();
            }
            f.methodvalue("instanceCreate", factoryClazz, factoryMethod);
        }
        f.stringvalue("instanceClass", type);
        if (instanceOf != null) {
            f.stringvalue("instanceOf", instanceOf);
        }
        return f;
    }

    public File shadowFile(String target, String folder, String name) {
        if (name == null) {
            name = target.replaceFirst("^.+/", "").replaceFirst("\\.[^./]+$", "");
        }
        return this.file(folder + "/" + name + ".shadow").stringvalue("originalFile", target);
    }

    public final class File {
        private final String path;
        private final boolean folder;
        private final Map<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        private String contents;
        private String url;

        File(String path, boolean folder) {
            this.path = path;
            this.folder = folder;
        }

        public String getPath() {
            return this.path;
        }

        public File contents(String contents) {
            if (this.contents != null || this.url != null || contents == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.contents = contents;
            return this;
        }

        public File url(String url) {
            if (this.contents != null || this.url != null || url == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            return this;
        }

        public File stringvalue(String attr, String value) {
            this.attrs.put(attr, new String[]{"stringvalue", value});
            return this;
        }

        public File bytevalue(String attr, byte value) {
            this.attrs.put(attr, new String[]{"bytevalue", Byte.toString(value)});
            return this;
        }

        public File shortvalue(String attr, short value) {
            this.attrs.put(attr, new String[]{"shortvalue", Short.toString(value)});
            return this;
        }

        public File intvalue(String attr, int value) {
            this.attrs.put(attr, new String[]{"intvalue", Integer.toString(value)});
            return this;
        }

        public File longvalue(String attr, long value) {
            this.attrs.put(attr, new String[]{"longvalue", Long.toString(value)});
            return this;
        }

        public File floatvalue(String attr, float value) {
            this.attrs.put(attr, new String[]{"floatvalue", Float.toString(value)});
            return this;
        }

        public File doublevalue(String attr, double value) {
            this.attrs.put(attr, new String[]{"doublevalue", Double.toString(value)});
            return this;
        }

        public File boolvalue(String attr, boolean value) {
            this.attrs.put(attr, new String[]{"boolvalue", Boolean.toString(value)});
            return this;
        }

        public File charvalue(String attr, char value) {
            this.attrs.put(attr, new String[]{"charvalue", Character.toString(value)});
            return this;
        }

        public File urlvalue(String attr, URI value) throws LayerGenerationException {
            if (value.isOpaque()) {
                throw new LayerGenerationException("Cannot use an opaque URI: " + value);
            }
            this.attrs.put(attr, new String[]{"urlvalue", value.toString()});
            return this;
        }

        public File urlvalue(String attr, String value) throws LayerGenerationException {
            try {
                return this.urlvalue(attr, URI.create(value));
            }
            catch (IllegalArgumentException x) {
                throw new LayerGenerationException(x.getLocalizedMessage());
            }
        }

        public File methodvalue(String attr, String clazz, String method) {
            this.attrs.put(attr, new String[]{"methodvalue", clazz + "." + method});
            return this;
        }

        public File methodvalue(String attr, String method) {
            this.attrs.put(attr, new String[]{"methodvalue", method});
            return this;
        }

        public File newvalue(String attr, String clazz) {
            this.attrs.put(attr, new String[]{"newvalue", clazz});
            return this;
        }

        public File bundlevalue(String attr, String bundle, String key) {
            this.attrs.put(attr, new String[]{"bundlevalue", bundle + "#" + key});
            return this;
        }

        public File bundlevalue(String attr, String label) throws LayerGenerationException {
            String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            Matcher m = Pattern.compile("((?:" + javaIdentifier + "\\.)+[^\\s.#]+)?#(\\S*)").matcher(label);
            if (m.matches()) {
                Object bundle = m.group(1);
                String key = m.group(2);
                if (bundle == null) {
                    Element referenceElement;
                    for (referenceElement = LayerBuilder.this.originatingElement; referenceElement != null && referenceElement.getKind() != ElementKind.PACKAGE; referenceElement = referenceElement.getEnclosingElement()) {
                    }
                    if (referenceElement == null) {
                        throw new LayerGenerationException("No reference element to determine package in '" + label + "'");
                    }
                    bundle = ((PackageElement)referenceElement).getQualifiedName() + ".Bundle";
                }
                this.verifyBundleKey((String)bundle, key, m.group(1) == null);
                this.bundlevalue(attr, (String)bundle, key);
            } else {
                this.stringvalue(attr, label);
            }
            return this;
        }

        private void verifyBundleKey(String bundle, String key, boolean samePackage) throws LayerGenerationException {
        }

        public File serialvalue(String attr, byte[] data) {
            StringBuilder buf = new StringBuilder(data.length * 2);
            for (int n : data) {
                if (n >= 0 && n < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(n < 0 ? n + 256 : n));
            }
            this.attrs.put(attr, new String[]{"serialvalue", buf.toString().toUpperCase(Locale.ENGLISH)});
            return this;
        }

        public File position(int position) {
            if (position != Integer.MAX_VALUE) {
                this.intvalue("position", position);
            }
            return this;
        }

        public LayerBuilder write() {
            long start = System.nanoTime();
            LayerBuilder.this.unwrittenFiles.remove(this);
            org.w3c.dom.Element e = LayerBuilder.this.doc.getDocumentElement();
            String[] pieces = this.path.split("/");
            for (String piece : Arrays.asList(pieces).subList(0, pieces.length - 1)) {
                org.w3c.dom.Element kid = this.find(e, piece, "file|folder");
                if (kid != null) {
                    if (!kid.getNodeName().equals("folder")) {
                        throw new IllegalArgumentException(this.path);
                    }
                    e = kid;
                    continue;
                }
                e = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("folder"));
                e.setAttribute("name", piece);
            }
            String piece = pieces[pieces.length - 1];
            org.w3c.dom.Element file = this.find(e, piece, "file|folder");
            if (this.folder) {
                if (file == null) {
                    file = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("folder"));
                }
            } else {
                if (file != null) {
                    e.removeChild(file);
                }
                file = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("file"));
            }
            file.setAttribute("name", piece);
            NodeList oldComments = file.getChildNodes();
            int i = 0;
            while (i < oldComments.getLength()) {
                Node node = oldComments.item(i);
                if (node.getNodeType() == 8) {
                    file.removeChild(node);
                    continue;
                }
                ++i;
            }
            if (LayerBuilder.this.originatingElement != null) {
                file.appendChild(LayerBuilder.this.doc.createComment((String)(switch (LayerBuilder.this.originatingElement.getKind()) {
                    case ElementKind.CONSTRUCTOR, ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.INSTANCE_INIT, ElementKind.METHOD, ElementKind.STATIC_INIT -> LayerBuilder.this.originatingElement.getEnclosingElement() + "." + LayerBuilder.this.originatingElement;
                    default -> LayerBuilder.this.originatingElement.toString();
                })));
            }
            for (Map.Entry<String, String[]> entry : this.attrs.entrySet()) {
                org.w3c.dom.Element former = this.find(file, entry.getKey(), "attr");
                if (former != null) {
                    file.removeChild(former);
                }
                org.w3c.dom.Element attr = (org.w3c.dom.Element)file.appendChild(LayerBuilder.this.doc.createElement("attr"));
                attr.setAttribute("name", entry.getKey());
                attr.setAttribute(entry.getValue()[0], entry.getValue()[1]);
            }
            if (this.url != null) {
                file.setAttribute("url", this.url);
            } else if (this.contents != null) {
                file.appendChild(LayerBuilder.this.doc.createCDATASection(this.contents));
            }
            LayerCache.TIMERS.addCurrentNanos("LAYER : write", start);
            return LayerBuilder.this;
        }

        private org.w3c.dom.Element find(org.w3c.dom.Element parent, String name, String kindRx) {
            NodeList nl = parent.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                org.w3c.dom.Element e;
                Node item = nl.item(i);
                if (item.getNodeType() != 1 || !(e = (org.w3c.dom.Element)item).getAttribute("name").equals(name) || !e.getNodeName().matches(kindRx)) continue;
                return e;
            }
            return null;
        }
    }

    public static class LayerGenerationException
    extends Exception {
        public LayerGenerationException(String message) {
            super(message);
        }
    }
}

