/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import oracle.ideimpl.extension.ExtensionGroups;

public class ExtensionGroupHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "extension-group");
    private static final ElementName ELEMENT_MEMBERS = new ElementName("http://xmlns.oracle.com/ide/extension", "members");
    private static final ElementName ELEMENT_MEMBER = new ElementName("http://xmlns.oracle.com/ide/extension", "member");
    private final ExtensionGroupMembersVisitor _membersVisitor = new ExtensionGroupMembersVisitor();
    private final ExtensionGroupMemberVisitor _memberVisitor = new ExtensionGroupMemberVisitor();
    private String _currentExtensionGroupId;

    public void start(ElementStartContext context) {
        Extension extension = context.getExtension();
        String extensionId = extension.getID();
        String extensionGroupId = context.getAttributeValue("id");
        ExtensionGroups.getInstance().addExtensionGroup((ElementContext)context, extensionGroupId, extensionId);
        this._currentExtensionGroupId = extensionGroupId;
        context.registerChildVisitor(ELEMENT_MEMBERS, (ElementVisitor)this._membersVisitor);
    }

    public void end(ElementEndContext context) {
        this._currentExtensionGroupId = null;
    }

    private class ExtensionGroupMembersVisitor
    extends ElementVisitor {
        private ExtensionGroupMembersVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ELEMENT_MEMBER, (ElementVisitor)ExtensionGroupHook.this._memberVisitor);
        }

        public void end(ElementEndContext context) {
            int num;
            if (ExtensionGroupHook.this._currentExtensionGroupId != null && (num = ExtensionGroups.getInstance().getNumMembers(ExtensionGroupHook.this._currentExtensionGroupId)) == 1) {
                this.log((ElementContext)context, Level.WARNING, "Extension group has no other members");
            }
        }
    }

    private class ExtensionGroupMemberVisitor
    extends ElementVisitor {
        private ExtensionGroupMemberVisitor() {
        }

        public void end(ElementEndContext context) {
            String id = context.getText().trim();
            if ("".equals(id)) {
                this.log((ElementContext)context, Level.SEVERE, "A member extension ID is required");
                return;
            }
            if (ExtensionGroupHook.this._currentExtensionGroupId != null) {
                ExtensionGroups.getInstance().addExtensionMember((ElementContext)context, id, ExtensionGroupHook.this._currentExtensionGroupId);
            }
        }
    }
}

