/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.Ide;
import oracle.ideimpl.extension.ExtensionSearchStrategy;
import oracle.ideimpl.extension.HotDeployExtensionSource;
import oracle.javatools.util.Log;

public class DefaultIdeExtensionSearchStrategy
extends ExtensionSearchStrategy {
    private Collection<ExtensionSource> sources;
    private static final Log LOG = new Log("extension-search");

    @Override
    public Collection<ExtensionSource> findExtensionSources() {
        if (this.sources != null) {
            return this.sources;
        }
        this.sources = new ArrayList<ExtensionSource>();
        for (File path : this.getExtensionRegistry().getExtensionSearchPath()) {
            this.sources.addAll(this.findExtensionSources(path));
        }
        this.addHotDeployedExtensionSource(this.sources);
        LOG.trace("{0}", this.sources);
        return this.sources;
    }

    protected Collection<ExtensionSource> findExtensionSources(File directory) {
        ArrayList<ExtensionSource> sources = new ArrayList<ExtensionSource>();
        for (File file : directory.listFiles()) {
            if (!this.isCandidateExtensionArchive(file)) continue;
            URI uri = URIFactory.newURI((String)file.getAbsolutePath());
            sources.add((ExtensionSource)new JARExtensionSource(uri));
        }
        return sources;
    }

    private void addHotDeployedExtensionSource(Collection<ExtensionSource> sources) {
        String hotManifest = System.getProperty("edt.hot.manifest");
        if (hotManifest != null) {
            String hotClasses = System.getProperty("edt.hot.classes");
            String hotDeploy = System.getProperty("edt.hot.deploydir");
            String extensionId = System.getProperty("edt.extension.id");
            if (extensionId != null) {
                Iterator<ExtensionSource> i = sources.iterator();
                while (i.hasNext()) {
                    ExtensionSource src = i.next();
                    URI uri = src.getURI();
                    String jarName = uri != null ? VirtualFileSystem.getVirtualFileSystem().getName(uri) : null;
                    if (!extensionId.equals(jarName)) continue;
                    this.getLogger().info("Hot deployed extension " + extensionId + " will obscure " + uri);
                    i.remove();
                }
            }
            URI manifestURI = URIFactory.newFileURI((String)hotManifest);
            URI classesURI = URIFactory.newDirURI((String)hotClasses);
            URI deployURI = URIFactory.newDirURI((URI)URIFactory.newDirURI((String)Ide.getOracleHomeDirectory()), (String)hotDeploy);
            sources.add(new HotDeployExtensionSource(manifestURI, classesURI, deployURI));
        }
    }

    protected boolean isCandidateExtensionArchive(File f) {
        return f.getName().toUpperCase().endsWith(".JAR");
    }
}

