/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.LocationAdapter;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ProductInformation;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.ProductAddins;
import oracle.ideri.util.Product;

public final class AddinsHook
extends ExtensionHook {
    static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "addins");
    private static final ElementName ADDIN = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "addin");
    private static final String KEY_LOADSET = "loadset";
    private static final String KEY_HASUI = "hasUI";
    private ElementVisitor _addinVisitor = new AddinVisitor();
    private Map<String, AddinInfo> _addinInfosByAddinClass = new LinkedHashMap<String, AddinInfo>();
    private boolean _processedProductAddins = false;

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ADDIN, this._addinVisitor);
    }

    public Collection<AddinInfo> getAddinInfos() {
        if (!this._processedProductAddins) {
            this._processedProductAddins = true;
            ProductInformation pi = ProductInformation.getProductInformation();
            Extension productExtension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(Product.getProductID());
            assert (productExtension != null) : "Could not find product extension: " + Product.getProductID();
            ProductAddins productAddins = new ProductAddins(pi.getHashStructure(), productExtension, ExtensionRegistry.getExtensionRegistry().getLogger());
            Collection<AddinInfo> addinInfos = productAddins.getAddins();
            for (AddinInfo info : addinInfos) {
                String className = info.getClassName();
                AddinInfo existing = this._addinInfosByAddinClass.get(className);
                if (existing != null) {
                    this.logDuplicateAddinError(null, productExtension, info);
                    continue;
                }
                this._addinInfosByAddinClass.put(className, info);
            }
        }
        return this._addinInfosByAddinClass.values();
    }

    private void logDuplicateAddinError(ElementContext context, Extension extension, AddinInfo info) {
        String className = info.getClassName();
        String otherExtensionId = info.getExtension().getID();
        String message = "Duplicate declaration of addin " + className + ". Previously defined in extension " + otherExtensionId;
        if (context != null) {
            this.log(context, Level.SEVERE, message);
        } else {
            ExtensionRegistry.getExtensionRegistry().getLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, message, extension, 0));
        }
    }

    private class AddinVisitor
    extends ElementVisitor {
        private AddinVisitor() {
        }

        public void start(ElementStartContext context) {
            String headless;
            String loadset = context.getAttributeValue(AddinsHook.KEY_LOADSET);
            if (loadset != null && loadset.trim().length() > 0) {
                context.getScopeData().put(AddinsHook.KEY_LOADSET, loadset);
            }
            Boolean bHasUI = (headless = context.getAttributeValue("headless")) == null ? Boolean.TRUE : Boolean.valueOf(Boolean.valueOf(headless) == false);
            String hasUI = context.getAttributeValue("requires-ui");
            if (hasUI != null) {
                if (headless != null) {
                    this.log((ElementContext)context, Level.WARNING, "Deprecated 'requires-ui' attribute ignored. Using the value of 'headless'");
                } else {
                    this.log((ElementContext)context, Level.WARNING, "The 'requires-ui' attribute is deprecated. Use 'headless' instead.");
                    bHasUI = Boolean.valueOf(hasUI);
                }
            }
            context.getScopeData().put(AddinsHook.KEY_HASUI, bHasUI);
        }

        public void end(ElementEndContext context) {
            String addinClassName = context.getText().trim();
            if (addinClassName.length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing addin class name.");
            } else {
                AddinInfo info = AddinsHook.this._addinInfosByAddinClass.get(addinClassName);
                if (info == null) {
                    String loadset = (String)context.getScopeData().get(AddinsHook.KEY_LOADSET);
                    LocationAdapter locator = (LocationAdapter)context.getScopeData().get("xml.locator");
                    ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
                    info = new AddinInfo(loader, addinClassName, loadset, locator == null ? 0 : locator.getLineNumber());
                    info.setHasUI((Boolean)context.getScopeData().get(AddinsHook.KEY_HASUI));
                    Extension ext = context.getExtension();
                    info.setExtension(ext);
                    AddinsHook.this._addinInfosByAddinClass.put(addinClassName, info);
                } else {
                    AddinsHook.this.logDuplicateAddinError((ElementContext)context, null, info);
                }
            }
        }
    }
}

