/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.editor.EditorHookRegistration;

public class DeclarativeEditorAddin
extends EditorAddin {
    private final String _extensionId;
    private final MetaClass<Editor> _editorClass;
    private final MenuSpec _menuSpec;
    private final boolean _isDefault;
    private final boolean _isDuplicable;
    private final boolean _isCloneable;
    private final boolean _isRestoreAtStartup;
    private final boolean _isMultifile;
    private final Collection<MetaClass> _nodeClasses;
    private final float _weight;
    private static final Logger LOG = Logger.getLogger(DeclarativeEditorAddin.class.getName());

    DeclarativeEditorAddin(EditorHookRegistration reg) {
        this._extensionId = reg.getExtensionId();
        this._menuSpec = new MenuSpec(reg.getLabel(), null);
        this._editorClass = reg.getEditorClass();
        this._isDefault = reg.isDefault();
        this._isDuplicable = reg.isDuplicable();
        this._isRestoreAtStartup = reg.isRestoreAtStartup();
        this._isMultifile = reg.isMultifile();
        this._nodeClasses = reg.getNodeClasses();
        this._weight = reg.getWeight();
        this._isCloneable = reg.isCloneable();
    }

    public MetaClass getEditorMetaClass() {
        return this._editorClass;
    }

    @Override
    public Class getEditorClass() {
        try {
            return this._editorClass.toClass();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load editor class: " + this._editorClass.getClassName(), e);
            return null;
        }
    }

    @Override
    public MenuSpec getMenuSpecification() {
        return this._menuSpec;
    }

    @Override
    public boolean isDefault() {
        return this._isDefault;
    }

    @Override
    public boolean isDuplicable() {
        return this._isDuplicable;
    }

    @Override
    public boolean restoreAtStartup() {
        return this._isRestoreAtStartup;
    }

    @Override
    public boolean isMultifile() {
        return this._isMultifile;
    }

    public Collection<MetaClass> getNodeClasses() {
        return this._nodeClasses;
    }

    String getExtensionId() {
        return this._extensionId;
    }

    @Override
    public float getEditorWeight(Element element) {
        if (!Float.isNaN(this._weight)) {
            return this._weight;
        }
        return super.getEditorWeight(element);
    }

    @Override
    public float getEditorWeight(Element element, Context context) {
        return this.getEditorWeight(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeclarativeEditorAddin)) {
            return false;
        }
        DeclarativeEditorAddin other = (DeclarativeEditorAddin)object;
        if (!(this._editorClass != null ? this._editorClass.equals(other._editorClass) : other._editorClass == null)) {
            return false;
        }
        if (this._isDefault != other._isDefault) {
            return false;
        }
        if (this._isDuplicable != other._isDuplicable) {
            return false;
        }
        if (this._isCloneable != other._isCloneable) {
            return false;
        }
        if (this._isRestoreAtStartup != other._isRestoreAtStartup) {
            return false;
        }
        return this._nodeClasses != null ? this._nodeClasses.equals(other._nodeClasses) : other._nodeClasses == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + (this._editorClass == null ? 0 : this._editorClass.hashCode());
        result = 37 * result + (this._isDefault ? 0 : 1);
        result = 37 * result + (this._isDuplicable ? 0 : 1);
        result = 37 * result + (this._isRestoreAtStartup ? 0 : 1);
        result = 37 * result + (this._nodeClasses == null ? 0 : this._nodeClasses.hashCode());
        return result;
    }

    @Override
    public boolean isCloneable() {
        return this._isCloneable;
    }
}

