/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ideimpl.docking.VisibleComponentEvent;
import oracle.ideimpl.docking.VisibleComponentListener;

final class VisibleComponentAgent
implements ComponentListener,
ContainerListener {
    private ArrayList _listeners = new ArrayList();

    VisibleComponentAgent() {
    }

    public void attachTo(Container c) {
        c.addContainerListener(this);
    }

    public void addVisibleComponentListener(VisibleComponentListener vcl) {
        if (!this._listeners.contains(this._listeners)) {
            this._listeners.add(vcl);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Component c = e.getComponent();
        this.whenComponentChanges(c.getParent(), c);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Component c = e.getComponent();
        this.whenComponentChanges(c.getParent(), c);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Container cn = e.getContainer();
        Component cm = e.getChild();
        this.whenComponentChanges(cn, cm);
        cm.addComponentListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Container cn = e.getContainer();
        Component cm = e.getChild();
        cm.removeComponentListener(this);
        this.whenComponentChanges(cn, cm);
    }

    private void whenComponentChanges(Container cn, Component cm) {
        int n = cn.getComponentCount();
        int nVisibleCount = 0;
        for (int i = 0; i < n; ++i) {
            Component cChild = cn.getComponent(i);
            if (!cChild.isVisible()) continue;
            ++nVisibleCount;
        }
        VisibleComponentEvent vce = new VisibleComponentEvent(cn, cm, nVisibleCount);
        n = this._listeners.size();
        for (int i = 0; i < n; ++i) {
            VisibleComponentListener vcl = (VisibleComponentListener)this._listeners.get(i);
            vcl.visibleCountChanges(vce);
        }
    }
}

