/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.progress.ProgressManager;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.controls.DragComponentListener;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.TabbedHeader;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.AutoExpander;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.FloatDockUI;
import oracle.ideimpl.docking.FloatDockWindow;
import oracle.ideimpl.docking.MaximizedTitledPanel;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanelDragListener;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.TitledPanelTabDragListener;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class TitledPanel
extends AbstractTitledPanel
implements SwingConstants,
TitleChangeListener,
DropTargetListener {
    private static final TabCloseAction TAB_CLOSE_ACTION = new TabCloseAction();
    private final TabbedHeader _tabHeader;
    private final JPanel centerPanel;
    private JComponent centerComponent;
    private DragComponentListener _titleDragListener;
    private DragComponentListener _tabDragListener;
    private Point _ptDragEnter;
    private final DefaultListModel _model;
    private final DoubleClickTrigger _tabTrigger = new DoubleClickTrigger();
    private DockPanelPositionCache dockPanelPosition = new DockPanelPositionCache(null);

    public TitledPanel() {
        this.setOpaque(false);
        this.createTitle();
        Box controlBox = new Box(2);
        this._buttonPin = new SmallSquareButton(OracleIcons.getIcon((String)"extras/minimize.gif"), IdeImplArb.getString(57));
        this._model = new DefaultListModel();
        this._tabHeader = new TabbedHeader(this._model);
        this.centerPanel = new JPanel(new BorderLayout()){};
        CustomTab customTab = this._tabHeader.getCustomTab();
        Color textColor = UIManager.getColor("controlText");
        Color pinForeground = new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), 144);
        customTab.setCompressible(true);
        customTab.setCtrlClickCloseEnabled(true);
        customTab.setCloseAction(TAB_CLOSE_ACTION);
        this._tabHeader.setBorder(new TabbedHeaderBorder(this._tabHeader));
        this._tabHeader.setControls(controlBox);
        this._buttonPin.setForeground(pinForeground);
        this._buttonPin.setOpaque(false);
        this._buttonPin.setRolloverEnabled(false);
        this._buttonPin.addActionListener(this);
        this.centerPanel.setOpaque(true);
        this.centerPanel.setBackground(UIManager.getColor("window"));
        this.applyThemeToCenterPanel(false);
        this.centerPanel.setBorder(new CenterPanelBorder());
        this.add((Component)this.centerPanel, "Center");
        this._buttonPin.setAlignmentY(0.75f);
        controlBox.add(Box.createHorizontalStrut(14));
        controlBox.add(this._buttonPin);
        controlBox.add(Box.createHorizontalStrut(customTab.getCornerSize() + 1));
        this.add((Component)this._tabHeader, "North");
        this._tabHeader.setVisible(true);
        this._buttonPin.setVisible(true);
        this.setBorder(null);
        this._tabHeader.addMouseListener(this);
        this._tabHeader.addMouseMotionListener(this);
        EventListener eventListener = new EventListener();
        customTab.addSelectionListener(eventListener);
        customTab.addMouseListener(eventListener);
        customTab.addMouseMotionListener(eventListener);
        new DropTarget(customTab, 2, this);
        this.createUIMap();
        KeyUtil.removeCtrlTabFromTraversalKeys(this);
    }

    public void beTransparent() {
        if (!this.centerPanel.isOpaque()) {
            return;
        }
        this.centerPanel.setOpaque(false);
    }

    public void beOpaque() {
        if (this.centerPanel.isOpaque()) {
            return;
        }
        this.centerPanel.setOpaque(true);
    }

    private void applyThemeToCenterPanel(boolean active) {
        if (Themes.isThemed()) {
            Theme theme = Themes.getActiveTheme();
            String state = active ? "active" : "inactive";
            this.centerPanel.setBackground(theme.getStateProperties("view", state).getColor("backgroundcolor"));
        }
    }

    @Override
    public void containerActivated(boolean active) {
        this._tabHeader.setFocused(active);
        this.applyThemeToCenterPanel(active);
        this.centerPanel.repaint();
        super.containerActivated(active);
    }

    private void whenTabSelectionChanges(ListSelectionEvent e) {
        int selectedIndex;
        DockableHolder lastHolder = this.getHolderForComponent(this.centerComponent);
        if (lastHolder != null) {
            TitledPanel.fireDockableHidden(lastHolder, 4);
        }
        TitledPanelHolder holder = (selectedIndex = e.getFirstIndex()) != -1 ? this.getHolder(selectedIndex) : null;
        this.setHolder(holder, false);
        if (holder != null) {
            TitledPanel.fireDockableShown(holder, 4);
        }
        this.adjustTitle();
        this.revalidate();
        this.repaint();
    }

    private DefaultCustomTabPage getPage(int index) {
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._model.getElementAt(index);
        return page;
    }

    @Override
    public String toString() {
        StringBuffer strRet = new StringBuffer("TitledPanel[");
        int n = this.getClientCount();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                strRet.append(",");
            }
            strRet.append(this.getClient(i).getUniqueName());
        }
        strRet.append("]");
        return strRet.toString();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getVisibleCount() != 0) {
            this.adjustButtons();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.getVisibleCount() != 0) {
            this.adjustButtons();
        }
    }

    @Override
    protected boolean isMinimized() {
        return false;
    }

    @Override
    protected boolean isMinimizable() {
        return this.getShutterMargin() != null;
    }

    @Override
    protected boolean isMaximized() {
        return false;
    }

    @Override
    protected boolean isMaximizable() {
        return !this.isFloating();
    }

    public ShutterMargin getShutterMargin() {
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel != null) {
            return dockPanel.getShutterMargin();
        }
        return null;
    }

    public int addClient(DockableHolder holder, int flags) {
        return this.addClient(holder, null, flags);
    }

    public int insertClient(DockableHolder holder, Dockable reference, int flags) {
        return this.addClient(holder, reference, flags);
    }

    private int addClient(DockableHolder holder, Dockable reference, int flags) {
        Dockable dockable = holder.getDockable();
        DockStationImpl ds = DockStationImpl.getInstance();
        ds.undock(dockable, flags);
        DefaultCustomTabPage tabPage = this.tabPageFrom(holder);
        String titleName = dockable.getTitleName();
        tabPage.setLongLabel(titleName);
        tabPage.setTooltip(titleName);
        tabPage.setVisible(false);
        int pagePos = -1;
        if (reference != null) {
            pagePos = this.getClientPos(reference);
            this._model.add(pagePos, tabPage);
        } else {
            pagePos = this._model.getSize();
            this._model.addElement(tabPage);
        }
        ds.addToCache(dockable);
        dockable.addTitleChangeListener(this);
        return pagePos;
    }

    private DefaultCustomTabPage tabPageFrom(DockableHolder holder) {
        Dockable dockable = holder.getDockable();
        DefaultCustomTabPage tabPage = new DefaultCustomTabPage(dockable.getTabIcon(), dockable.getTabName(), holder);
        return tabPage;
    }

    public void addClient(Dockable dockable, boolean bVisible, int flags) {
        TitledPanelHolder holder = new TitledPanelHolder(dockable);
        int pagePos = this.addClient(holder, flags);
        if (bVisible) {
            this.setClientVisible(pagePos, bVisible, flags);
        }
    }

    public void removeClient(Dockable dockable, int flags) {
        List<TitledPanelHolder> holders = this.getHolders();
        for (int i = 0; i < holders.size(); ++i) {
            TitledPanelHolder holder = holders.get(i);
            Dockable dockable_i = holder.getDockable();
            if (dockable.equals(dockable_i)) {
                this.removeClientAt(i, flags);
                if (!dockable.isAutoExpandable()) continue;
                AutoExpander.instance().removeListener(dockable);
                continue;
            }
            if (dockable_i instanceof DrawerDockableWindow) {
                DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable_i;
                List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
                for (DockableHolder dockableHolder : containedHolders) {
                    if (!dockable.equals(dockableHolder.getDockable())) continue;
                    DrawerEntryImpl drawerEntry = (DrawerEntryImpl)dockableHolder;
                    drawerEntry.detach();
                }
                continue;
            }
            if (!(dockable_i instanceof DrawerWindow)) continue;
            DrawerWindow drawerWindow = (DrawerWindow)dockable_i;
            if (!(dockable instanceof View)) continue;
            drawerWindow.removeIfPresent((View)((Object)dockable));
        }
    }

    void removeClientAt(int i, int flags) {
        ShutterMargin margin;
        TitledPanelHolder holder = this.getHolder(i);
        Dockable dockable = holder.getDockable();
        dockable.removeTitleChangeListener(this);
        this.removeClientComponent(holder, flags);
        DockStationImpl.getInstance().removeFromCache(dockable);
        this.removeHolder(i);
        if (holder.isMinimized() && (margin = this.getShutterMargin()) != null) {
            margin.refreshShutter(this);
        }
    }

    private List<TitledPanelHolder> getHolders() {
        return new AbstractList<TitledPanelHolder>(){

            @Override
            public int size() {
                return TitledPanel.this.getClientCount();
            }

            @Override
            public TitledPanelHolder get(int index) {
                return TitledPanel.this.getHolder(index);
            }
        };
    }

    public TitledPanelHolder getHolder(int i) {
        if (this._model.isEmpty() || this._model.getSize() <= i) {
            return null;
        }
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._model.getElementAt(i);
        return (TitledPanelHolder)page.getUserObject();
    }

    private void removeHolder(int i) {
        this._model.removeElementAt(i);
    }

    @Override
    public int getClientCount() {
        return this._model.getSize();
    }

    @Override
    public Dockable getClient(int i) {
        return this.getHolder(i).getDockable();
    }

    TitledPanelHolder getHolder(Dockable dockable) {
        TitledPanelHolder titledPanelHolder = null;
        int clientPos = this.getClientPos(dockable);
        if (clientPos != -1) {
            titledPanelHolder = this.getHolder(clientPos);
        }
        return titledPanelHolder;
    }

    public int getClientPos(Dockable dockable) {
        if (dockable != null) {
            int n = this.getClientCount();
            for (int i = 0; i < n; ++i) {
                Dockable client_i = this.getClient(i);
                if (!dockable.equals(client_i)) continue;
                return i;
            }
        }
        return -1;
    }

    private DockableHolder getHolderForComponent(Component c) {
        if (c != null) {
            int i = this.getClientCount();
            while (i-- > 0) {
                TitledPanelHolder holder = this.getHolder(i);
                if (c != holder.getComponent()) continue;
                return holder;
            }
        }
        return null;
    }

    public boolean isClient(Dockable dockable) {
        return this.getClientPos(dockable) != -1;
    }

    public boolean isClientVisible(int clientPos) {
        DefaultCustomTabPage page = this.getPage(clientPos);
        return page.isVisible();
    }

    @Override
    public boolean isClientAccessible(Dockable dockable) {
        boolean ret = false;
        List<TitledPanelHolder> holders = this.getHolders();
        for (int i = 0; i < holders.size(); ++i) {
            TitledPanelHolder holder = holders.get(i);
            boolean foundAndAccessible = false;
            Dockable dockable_i = holder.getDockable();
            if (dockable.equals(dockable_i)) {
                foundAndAccessible = true;
            } else if (dockable_i instanceof DrawerDockableWindow) {
                DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable_i;
                List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
                for (DockableHolder dockableHolder : containedHolders) {
                    if (!dockable.equals(dockableHolder.getDockable())) continue;
                    DrawerEntryImpl drawerEntry = (DrawerEntryImpl)dockableHolder;
                    if (BitField.isSet(drawerEntry.getDockableStatus(), 8)) {
                        foundAndAccessible = true;
                    }
                    break;
                }
            } else if (dockable_i instanceof DrawerWindow) {
                DrawerWindow drawerWindow = (DrawerWindow)dockable_i;
                foundAndAccessible = drawerWindow.accessibleDrawer();
            }
            if (!foundAndAccessible || !this.isClientVisible(i)) continue;
            if (this.isMinimizable() && holder.isMinimized()) {
                ShutterMargin margin = this.getShutterMargin();
                ret = margin.hasShutter(this);
                continue;
            }
            ret = this.isVisible();
        }
        return ret;
    }

    int getDockableStatus(Dockable dockable) {
        int status = 0;
        int clientCount = this.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            TitledPanelHolder holder = this.getHolder(i);
            Dockable dockable_i = holder.getDockable();
            DefaultCustomTabPage page = this.getPage(i);
            if (dockable.equals(dockable_i)) {
                if (holder.isMinimized()) {
                    ShutterPanel shutterPanel;
                    ShutterMargin shutterMargin = this.getShutterMargin();
                    if (shutterMargin == null) continue;
                    if (shutterMargin.hasShutter(this)) {
                        status |= 4;
                        if (page.isVisible()) {
                            status |= 8;
                        }
                    }
                    if (!(shutterPanel = ShutterManager.getInstance().getShutterPanel()).isClientAccessible(dockable)) continue;
                    status |= 0x30;
                    continue;
                }
                status |= 2;
                if (!this.isVisible() || !page.isVisible()) continue;
                status |= 8;
                int selectedIndex = this.getSelectedIndex();
                if (i == selectedIndex) {
                    status |= 0x20;
                }
                if (!this.isActive() || i != selectedIndex) continue;
                status |= 0x10;
                continue;
            }
            if (dockable_i instanceof DrawerDockableWindow) {
                DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable_i;
                List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
                for (DockableHolder dockableHolder : containedHolders) {
                    if (!dockable.equals(dockableHolder.getDockable())) continue;
                    DrawerEntryImpl drawerEntry = (DrawerEntryImpl)dockableHolder;
                    int drawerStatus = drawerEntry.getDockableStatus();
                    int titledPanelStatus = this.getDockableStatus(dockable_i);
                    if (BitField.isSet(titledPanelStatus, 2)) {
                        status |= 2;
                    }
                    if (BitField.isSet(titledPanelStatus, 4) || BitField.isSet(drawerStatus, 4)) {
                        status |= 4;
                    }
                    if (BitField.isSet(titledPanelStatus, 8) && BitField.isSet(drawerStatus, 8)) {
                        status |= 8;
                    }
                    if (BitField.isSet(titledPanelStatus, 16) && BitField.isSet(drawerStatus, 16)) {
                        status |= 0x10;
                    }
                    if (!BitField.isSet(titledPanelStatus, 32) || !BitField.isSet(drawerStatus, 32)) continue;
                    status |= 0x20;
                }
                continue;
            }
            if (!(dockable_i instanceof DrawerWindow)) continue;
            DrawerWindow drawerWindow = (DrawerWindow)dockable_i;
            for (int drawerStatus : drawerWindow.drawerDockableStatuses(dockable)) {
                int n = this.getDockableStatus(dockable_i);
                if (this.pinned(n)) {
                    status |= 2;
                }
                if (this.minimized(n) || this.minimized(drawerStatus)) {
                    status |= 4;
                }
                if (this.accessible(n) && this.accessible(drawerStatus)) {
                    status |= 8;
                }
                if (this.active(n) && this.active(drawerStatus)) {
                    status |= 0x10;
                }
                if (!this.visible(n) || !this.visible(drawerStatus)) continue;
                status |= 0x20;
            }
        }
        return status;
    }

    private boolean pinned(int status) {
        return BitField.isSet(status, 2);
    }

    private boolean minimized(int status) {
        return BitField.isSet(status, 4);
    }

    private boolean accessible(int status) {
        return BitField.isSet(status, 8);
    }

    private boolean active(int status) {
        return BitField.isSet(status, 16);
    }

    private boolean visible(int status) {
        return BitField.isSet(status, 32);
    }

    private int getClientComponentIndex(Dockable dockable) {
        int clientCount = this.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            TitledPanelHolder holder = this.getHolder(i);
            if (!holder.getDockable().equals(dockable)) continue;
            return i;
        }
        return -1;
    }

    void closePanel(int flags) {
        int i;
        boolean restoreFocus = false;
        if (GraphicsUtils.isAncestorOfFocusedComponent((Component)this)) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.clearGlobalFocusOwner();
            restoreFocus = true;
        }
        int n = this.getClientCount();
        TitledPanelHolder[] holders = new TitledPanelHolder[n];
        for (i = n - 1; i >= 0; --i) {
            holders[i] = this.getHolder(i);
        }
        for (i = n - 1; i >= 0; --i) {
            TitledPanelHolder holder = holders[i];
            Dockable dockable = holder.getDockable();
            if (!this.isClient(dockable)) continue;
            this.closeClient(holder, flags);
        }
        if (this.getClientCount() == 0) {
            this.getParent().remove(this);
        } else {
            this.setVisible(false);
        }
        if (restoreFocus) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public void closeClient(TitledPanelHolder holder, int flags) {
        Dockable dockable = holder.getDockable();
        int nType = dockable.getType();
        if (BitField.isSet(nType, 1)) {
            this.removeClient(dockable, flags);
        } else {
            this.removeClientComponent(holder, flags);
        }
    }

    private static void fireDockableHidden(DockableHolder holder, int flags) {
        Dockable dockable = holder.getDockable();
        DockableEvent event = new DockableEvent(dockable, 1, flags);
        DockStationImpl.getInstance().fireDockableEvent(event);
    }

    private static void fireDockableShown(DockableHolder holder, int flags) {
        if (holder != null) {
            Dockable dockable = holder.getDockable();
            DockableEvent event = new DockableEvent(dockable, 0, flags);
            DockStationImpl.getInstance().fireDockableEvent(event);
        }
    }

    public int getVisibleCount() {
        int count = 0;
        int pageCount = this.getClientCount();
        for (int i = 0; i < pageCount; ++i) {
            DefaultCustomTabPage page = this.getPage(i);
            if (!page.isVisible()) continue;
            ++count;
        }
        return count;
    }

    private void removeClientComponent(TitledPanelHolder holder, int flags) {
        JComponent component = holder.getComponent();
        if (component != null) {
            ShutterMargin margin;
            int pagePos = this.indexOf(holder);
            DefaultCustomTabPage page = this.getPage(pagePos);
            page.setVisible(false);
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex == pagePos) {
                DefaultCustomTabPage page_i;
                int bestSelection;
                int clientCount = this.getClientCount();
                for (bestSelection = pagePos; bestSelection < clientCount - 1 && !(page_i = this.getPage(bestSelection)).isVisible(); ++bestSelection) {
                }
                while (bestSelection >= 0 && !(page_i = this.getPage(bestSelection)).isVisible()) {
                    --bestSelection;
                }
                this.setSelectedIndex(bestSelection);
            }
            if (this.getVisibleCount() == 0) {
                this.setVisible(false);
            } else {
                this._tabHeader.getCustomTab().whenTabChanged();
            }
            TitledPanel.fireDockableHidden(holder, flags);
            holder.disposeComponent();
            if (holder.isMinimized() && (margin = this.getShutterMargin()) != null) {
                if (this.getVisibleCount() == 0) {
                    margin.removeShutter(this);
                } else {
                    margin.refreshShutter(this);
                }
            }
        }
    }

    private int indexOf(DockableHolder holder) {
        Dockable dockable = holder.getDockable();
        return this.getClientPos(dockable);
    }

    public void setClientVisible(Dockable dockable, boolean bVisible, int flags) {
        List<TitledPanelHolder> holders = this.getHolders();
        for (int i = 0; i < holders.size(); ++i) {
            TitledPanelHolder holder = holders.get(i);
            Dockable dockable_i = holder.getDockable();
            if (dockable.equals(dockable_i)) {
                this.setClientVisible(i, bVisible, flags);
                continue;
            }
            if (dockable_i instanceof DrawerDockableWindow) {
                DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable_i;
                List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
                for (DockableHolder dockableHolder : containedHolders) {
                    Dockable dockable_j = dockableHolder.getDockable();
                    if (!dockable.equals(dockable_j)) continue;
                    DrawerEntryImpl drawerEntry = (DrawerEntryImpl)dockableHolder;
                    drawerEntry.setClientVisible(bVisible, flags);
                }
                continue;
            }
            if (!(dockable_i instanceof DrawerWindow)) continue;
            DrawerWindow drawerWindow = (DrawerWindow)dockable_i;
            drawerWindow.clientVisible(dockable, bVisible, flags);
        }
    }

    public void setClientVisible(int clientPos, boolean bVisible, int flags) {
        if (bVisible) {
            this.showClient(clientPos, flags);
        } else {
            this.hideClient(clientPos, flags);
        }
    }

    private boolean showClient(int clientPos, int flags) {
        boolean ret;
        TitledPanelHolder holder = this.getHolder(clientPos);
        ShutterMargin margin = this.getShutterMargin();
        Dockable holderDockable = holder.getDockable();
        if (holderDockable.isAutoExpandable() && !AutoExpander.instance().hasListenerAttached(holderDockable)) {
            AutoExpander.instance().attachListenerToDockableAndTab(this, this._tabHeader, holderDockable);
        }
        if (ret = this.setPageVisible(clientPos, flags)) {
            if (!this.isMinimizable() || !holder.isMinimized()) {
                this.setVisible(true);
                if (margin != null) {
                    margin.removeShutter(this);
                }
            } else if (margin != null) {
                ret = margin.addShutter(this, false);
            }
        }
        return ret;
    }

    private boolean setPageVisible(int clientPos, int flags) {
        boolean ret = false;
        DefaultCustomTabPage page = this.getPage(clientPos);
        if (!page.isVisible()) {
            TitledPanelHolder holder = this.getHolder(clientPos);
            JComponent c = holder.getOrCreateComponent();
            if (c != null) {
                ret = true;
                page.setVisible(true);
                if (this.isShowing() || holder.isMinimized()) {
                    this.setSelectedIndex(clientPos);
                } else if (this.getVisibleCount() == 1) {
                    Container parent;
                    this.setSelectedIndex(clientPos);
                    for (parent = this; parent != null && !parent.isShowing(); parent = parent.getParent()) {
                        if (parent instanceof Frame) continue;
                        ((Component)parent).setVisible(true);
                    }
                    if (parent != null) {
                        if (parent instanceof JComponent) {
                            JComponent jparent = parent;
                            jparent.revalidate();
                        } else {
                            parent.validate();
                        }
                    }
                }
                TitledPanel.fireDockableShown(holder, flags);
                this.revalidate();
            }
        } else {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideClient(int clientPos, int flags) {
        JComponent c;
        TitledPanelHolder holder = this.getHolder(clientPos);
        if (this.isMinimizable() && holder.isMinimized()) {
            DockStationImpl dockStation = DockStationImpl.getInstance();
            ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
            if (shutterPanel.isClientAccessible(holder)) {
                dockStation.addDockableEventContext(4);
                try {
                    ShutterManager.getInstance().hideShutterPanel(flags | 4);
                }
                finally {
                    dockStation.removeDockableEventContext(4);
                }
            }
        }
        if ((c = holder.getComponent()) != null) {
            this.removeClientComponent(holder, flags);
            c.setVisible(false);
        }
    }

    private void showFloatShutter(Dockable dockable, int flags) {
        TitledPanelHolder holder = this.getHolder(dockable);
        ShutterMargin shutterMargin = this.getShutterMargin();
        this.setClientVisible(dockable, true, flags);
        this.setVisible(false);
        shutterMargin.raiseFloatPanel(holder, flags);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        int nWidth = d.width;
        int nHeight = d.height;
        int clientCount = this.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            DefaultCustomTabPage page = this.getPage(i);
            if (!page.isVisible()) continue;
            TitledPanelHolder holder = this.getHolder(i);
            JComponent component = holder.getComponent();
            component.setPreferredSize(new Dimension(nWidth, nHeight));
        }
    }

    private void updateSiteInfo() {
        int n = this.getClientCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = this.getClient(i);
            this.updateSiteInfo(dockable);
        }
    }

    private void updateSiteInfo(Dockable dockable) {
        Site site = dockable.getSite();
        FloatDockWindow fdw = this.getFloatContainer();
        if (fdw != null) {
            Dimension d = this.getDockPanel().getSize();
            site.geometry.setSize(d);
        }
        site.size = this.getPrefDockedSize();
    }

    @Override
    protected void adjustTitle(Dockable selectedDockable) {
        super.adjustTitle(selectedDockable);
        List<TitledPanelHolder> holders = this.getHolders();
        for (int i = 0; i < holders.size(); ++i) {
            TitledPanelHolder holder = holders.get(i);
            Dockable dockable_i = holder.getDockable();
            if (!selectedDockable.equals(dockable_i)) continue;
            DefaultCustomTabPage page = this.getPage(i);
            String titleName = selectedDockable.getTitleName();
            page.setIcon(selectedDockable.getTabIcon());
            page.setLabel(selectedDockable.getTabName());
            page.setLongLabel(titleName);
            page.setTooltip(titleName);
            this._tabHeader.getCustomTab().whenTabChanged();
        }
    }

    @Override
    protected void adjustButtons(Dockable selectedDockable) {
        this._buttonPin.setVisible(!this.isFloating());
    }

    private void adjustButtons() {
        TitledPanelHolder holder = this.getSelectedHolder();
        if (holder != null) {
            Dockable selectedDockable = holder.getDockable();
            this.adjustButtons(selectedDockable);
        }
    }

    private void adjustTitle() {
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        if (selectedHolder != null) {
            Dockable dockable = selectedHolder.getDockable();
            this.adjustTitle(dockable);
            this.adjustButtons(dockable);
        }
    }

    Dimension getPrefDockedSize() {
        DockLayoutInfoLeaf dli;
        Dimension dPrefSize = null;
        DockPanel dpParent = this.getDockPanel();
        if (dpParent != null && (dli = dpParent.getLayoutInfo(this)) != null) {
            dPrefSize = dli.getPrefSize();
        }
        return dPrefSize;
    }

    Dimension getPrefFloatSize() {
        Dockable dockable;
        Site site;
        Dimension dFloatSize = null;
        if (this.getClientCount() > 0 && (site = (dockable = this.getClient(0)).getSite()) != null && site.geometry != null) {
            dFloatSize = site.geometry.getSize();
        }
        if (dFloatSize == null) {
            dFloatSize = new Dimension(this.getPreferredSize());
        }
        return dFloatSize;
    }

    FloatDockWindow getFloatContainer() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof FloatDockUI)) continue;
            FloatDockUI fdui = (FloatDockUI)((Object)c);
            return fdui.getFloatDockWindow();
        }
        return null;
    }

    DockPanel getDockPanel() {
        return (DockPanel)this.getParent();
    }

    @Override
    protected boolean isFloating() {
        return this.getFloatContainer() != null;
    }

    @Override
    protected boolean canMove() {
        return true;
    }

    @Override
    protected boolean canSize() {
        return true;
    }

    public void setSelectedIndex(int page) {
        this._tabHeader.getCustomTab().setSelectedPage(page);
    }

    public int getSelectedIndex() {
        return this._tabHeader.getCustomTab().getSelectedPage();
    }

    private JComponent getSelectedClient() {
        JComponent ret = null;
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        if (selectedHolder != null) {
            ret = selectedHolder.getOrCreateComponent();
        }
        return ret;
    }

    @Override
    public TitledPanelHolder getSelectedHolder() {
        TitledPanelHolder ret = null;
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            ret = this.getHolder(selectedIndex);
        }
        return ret;
    }

    @Override
    protected void titleMousePressed(MouseEvent e) {
        this.activate();
        _ptStart.setLocation(e.getPoint());
        super.titleMousePressed(e);
    }

    @Override
    protected void titleMouseDragged(MouseEvent e) {
        DragComponentEvent dragComponentEvent;
        if (!_bDraging && SwingUtilities.isLeftMouseButton(e) && _ptStart.distanceSq(e.getPoint()) >= (double)DRAGSTART) {
            _bDraging = true;
            DragComponentListener titleDragListener = this.titleDragListener();
            this.updateSiteInfo();
            SwingUtilities.convertPointToScreen(_ptStart, e.getComponent());
            dragComponentEvent = new DragComponentEvent(this, _ptStart, 1, e.getModifiers());
            titleDragListener.start(dragComponentEvent);
        }
        if (_bDraging) {
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            dragComponentEvent = new DragComponentEvent(this, pt, 2, e.getModifiers());
            this.titleDragListener().move(dragComponentEvent);
        }
    }

    @Override
    protected void titleMouseReleased(MouseEvent e) {
        if (_bDraging) {
            if (!this.isFloating()) {
                this.updateTitledPanelPlaceHolder();
            }
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            this.titleDragListener().end(new DragComponentEvent(this, pt, 3, e.getModifiers()));
            _bDraging = false;
            this._titleDragListener = null;
        } else {
            super.titleMouseReleased(e);
        }
    }

    private DragComponentListener titleDragListener() {
        if (this._titleDragListener == null) {
            this._titleDragListener = new TitledPanelDragListener(this);
        }
        return this._titleDragListener;
    }

    private void tabMousePressed(MouseEvent e) {
        if (!this.checkTabPopupAction(e)) {
            _ptStart.setLocation(e.getPoint());
            JComponent component = this.getSelectedClient();
            GraphicsUtils.focusComponentOrChild((Component)component, (boolean)true);
        }
    }

    private void tabMouseClicked(MouseEvent e) {
        if (!this.checkTabPopupAction(e) && this._tabTrigger.isDoubleClick(e)) {
            this.whenMaximize(4);
        }
    }

    private void tabMouseDragged(MouseEvent e) {
        DefaultCustomTabPage page;
        Rectangle rcSel;
        int nSel = this.getSelectedIndex();
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        if (selectedHolder == null) {
            return;
        }
        if (!_bDraging && (rcSel = (page = this.getPage(nSel)).getBounds()).contains(_ptStart) && SwingUtilities.isLeftMouseButton(e) && _ptStart.distanceSq(e.getPoint()) >= (double)DRAGSTART) {
            _bDraging = true;
            this._tabDragListener = new TitledPanelTabDragListener(selectedHolder);
            this.updateSiteInfo();
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(selectedHolder.getComponent(), pt, 1, e.getModifiers());
            this._tabDragListener.start(dragComponentEvent);
        }
        if (_bDraging) {
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(selectedHolder.getComponent(), pt, 2, e.getModifiers());
            DragComponentListener tabDragListener = this.tabDragListener();
            if (tabDragListener != null) {
                tabDragListener.move(dragComponentEvent);
            }
        }
    }

    private void tabMouseReleased(MouseEvent e) {
        if (_bDraging) {
            if (!this.isFloating()) {
                this.updateTitledPanelPlaceHolder();
            }
            if (e == null) {
                return;
            }
            TitledPanelHolder selectedHolder = this.getSelectedHolder();
            if (selectedHolder == null) {
                return;
            }
            JComponent jcClientComponent = selectedHolder.getComponent();
            Point pt = e.getPoint();
            if (pt == null) {
                return;
            }
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            DragComponentListener tabDragListener = this.tabDragListener();
            if (tabDragListener != null) {
                tabDragListener.end(new DragComponentEvent(jcClientComponent, pt, 3, e.getModifiers()));
            }
            _bDraging = false;
            this._tabDragListener = null;
        } else {
            this.checkTabPopupAction(e);
        }
    }

    private DragComponentListener tabDragListener() {
        TitledPanelHolder selectedHolder;
        if (this._tabDragListener == null && (selectedHolder = this.getSelectedHolder()) != null) {
            this._tabDragListener = new TitledPanelTabDragListener(selectedHolder);
        }
        return this._tabDragListener;
    }

    private boolean checkTabPopupAction(MouseEvent e) {
        boolean bRet = false;
        if (e.isPopupTrigger()) {
            Point point = e.getPoint();
            int pageAt = this._tabHeader.getCustomTab().getPageAt(point);
            if (pageAt != -1) {
                TitledPanelHolder holder = this.getHolder(pageAt);
                this.showTabContextMenu(e, holder);
                bRet = true;
            }
        }
        return bRet;
    }

    private static DockableHolder loadClientLayout(StructuredPropertyAccess structuredPropertyAccess) {
        TitledPanelHolder dockableHolder = null;
        String strDockableName = structuredPropertyAccess.getProperty("ID", "");
        DockStationImpl dockStation = DockStationImpl.getInstance();
        Dockable dockable = dockStation.findDockable(new ViewId(strDockableName));
        if (dockable != null) {
            ProgressManager.updateProgressDescription((String)"windows", (String)dockable.getTitleName(), (int)1);
            dockableHolder = new TitledPanelHolder(dockable);
            Site site = dockable.getSite();
            site.size.width = structuredPropertyAccess.getIntegerProperty("dockWidth", 0);
            site.size.height = structuredPropertyAccess.getIntegerProperty("dockHeight", 0);
            site.geometry.width = structuredPropertyAccess.getIntegerProperty("floatWidth", 0);
            site.geometry.height = structuredPropertyAccess.getIntegerProperty("floatHeight", 0);
            String floatOnTopProperty = structuredPropertyAccess.getProperty("floatOnTop", null);
            Boolean floatOnTop = floatOnTopProperty == null ? null : Boolean.valueOf(floatOnTopProperty);
            dockableHolder.setFloatOnTop(floatOnTop);
            DockStationImpl.getInstance().loadViewData(dockable);
        }
        return dockableHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void whenCloseTab(int flags, DockableHolder holder) {
        Dockable dockable = holder.getDockable();
        DockStationImpl ds = DockStationImpl.getInstance();
        ds.addDockableEventContext(flags);
        try {
            ds.closeDockable(dockable, flags);
        }
        finally {
            ds.removeDockableEventContext(flags);
        }
    }

    private JPopupMenu getTabContextMenu(DockableHolder holder) {
        return this.createSystemMenu(holder);
    }

    private void showTabContextMenu(MouseEvent e, DockableHolder holder) {
        JPopupMenu popup = this.getTabContextMenu(holder);
        Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (MouseEvent)e);
        popup.show(e.getComponent(), showPoint.x, showPoint.y);
    }

    @Override
    protected JPopupMenu getTitleContextMenu() {
        return this.createSystemMenu(null);
    }

    @Override
    protected void whenShowSystemMenu() {
        int selectedIndex = this.getSelectedIndex();
        TitledPanelHolder holder = this.getHolder(selectedIndex);
        JPopupMenu popup = this.getTabContextMenu(holder);
        Point tabLocation = this._tabHeader.getCustomTab().getLocationOnScreen();
        DefaultCustomTabPage page = this.getPage(selectedIndex);
        Rectangle pageBounds = page.getBounds();
        Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (int)(tabLocation.x + pageBounds.x), (int)(tabLocation.y + pageBounds.height));
        showPoint.translate(-tabLocation.x, -tabLocation.y);
        popup.show(this._tabHeader.getCustomTab(), showPoint.x, showPoint.y);
    }

    @Override
    protected void whenSystemMenuFloat(DockableHolder selectedHolder) {
        this.dockPanelPosition = new DockPanelPositionCache(this.getDockPanel());
        this.updateTitledPanelPlaceHolder();
        TitledPanelDragListener.updateTitledPanelReferences(this);
        DockStationImpl.getInstance().floatPanel(this, new Point(10, 10));
    }

    private void updateTitledPanelPlaceHolder() {
        int i;
        HashSet<Dockable> allClients = new HashSet<Dockable>();
        DockStationImpl dockStation = DockStationImpl.getInstance();
        for (i = 0; i < this.getClientCount(); ++i) {
            allClients.add(this.getClient(i));
        }
        for (i = 0; i < this.getClientCount(); ++i) {
            Dockable dockable = this.getClient(i);
            dockStation.setRefPlaceHolders(dockable.getUniqueName(), this.getDockPanel(), this);
            HashSet<Dockable> dockedWith = new HashSet<Dockable>(allClients);
            dockedWith.remove(dockable);
            if (dockedWith.isEmpty()) continue;
            dockStation.setRefLastDockedWith(dockable.getUniqueName(), dockedWith);
        }
    }

    @Override
    protected void whenSystemMenuDock() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TitledPanel.this._systemMenuDock();
            }
        });
    }

    private void _systemMenuDock() {
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DockPanel dpSource = (DockPanel)this.getParent();
        ArrayList<Dockable> clients = new ArrayList<Dockable>();
        for (int i = 0; i < this.getClientCount(); ++i) {
            Dockable dockable = this.getClient(i);
            if (dockable == null) continue;
            clients.add(dockable);
        }
        for (Dockable dockable : clients) {
            TitledPanel titledPanel;
            String dockableName = dockable.getUniqueName();
            if (!DockStationImpl.getInstance().isDockableVisible(dockable)) continue;
            DockPanel dockPanel = dockStation.getRefDockPanelPlaceHolder(dockableName);
            TitledPanel refTitledPanel = dockStation.getRefTitledPanelPlaceHolder(dockableName);
            boolean exists = false;
            if (dockPanel == null) {
                DockPanelHost dockPanelHost;
                DockPanelHost[] dockPanelHostArray = dockStation.getAllDockPanelHosts();
                int n = dockPanelHostArray.length;
                for (int i = 0; !(i >= n || (dockPanelHost = dockPanelHostArray[i]) != null && dockPanelHost.getDockPanel() != null && (exists = this.searchForTitledPanel(dockPanelHost.getDockPanel(), refTitledPanel, dockable))); ++i) {
                }
            } else {
                exists = this.searchForTitledPanel(dockPanel, refTitledPanel, dockable);
            }
            if (!exists && (titledPanel = dockStation.getRefSourceTitledPanel(this)) != null) {
                titledPanel.addClient(dockable, true, 0);
                exists = true;
            }
            if (!exists && (titledPanel = this.searchForDockable(dockable)) != null) {
                titledPanel.addClient(dockable, true, 0);
                exists = true;
            }
            if (!exists) {
                DockLayoutInfoLeaf dli = dpSource.getLayoutInfo(this);
                Dimension dPref = dli.getSize(2);
                DockLayoutConstraint dlc = null;
                if (dockPanel == null) {
                    dockPanel = dockStation.getSidePort(0).getDockPanel();
                    dlc = new DockLayoutConstraint(0, dPref);
                } else {
                    dlc = new DockLayoutConstraint(2, dPref);
                }
                this.removeClient(dockable, 0);
                TitledPanel newTitledPanel = new TitledPanel();
                newTitledPanel.addClient(dockable, true, 0);
                dockPanel.dock(newTitledPanel, dlc);
            }
            DockStationImpl.getInstance().removeRefPlaceHolder(dockable.getUniqueName());
            if (dockPanel == null) continue;
            dockPanel.revalidate();
        }
        dpSource.revalidate();
    }

    private boolean searchForTitledPanel(DockPanel dockPanel, TitledPanel titledPanel, Dockable dockable) {
        if (titledPanel == null) {
            return false;
        }
        for (TitledPanel tp : dockPanel.getAllTitledPanels()) {
            if (!titledPanel.equals(tp)) continue;
            tp.addClient(dockable, true, 0);
            return true;
        }
        return false;
    }

    private TitledPanel searchForDockable(Dockable dockable) {
        DockStationImpl dockStation = DockStationImpl.getInstance();
        Collection<Dockable> lastDockedWith = dockStation.getRefLastDockedWith(dockable.getUniqueName());
        if (lastDockedWith == null) {
            return null;
        }
        for (DockPanelHost dockPanelHost : dockStation.getAllDockPanelHosts()) {
            DockPanel dockPanel = dockPanelHost.getDockPanel();
            if (dockPanel == null) continue;
            for (TitledPanel titledPanel : dockPanel.getAllTitledPanels()) {
                for (TitledPanelHolder titledPanelHolder : titledPanel.getHolders()) {
                    dockPanel.getLayout().layoutContainer(titledPanel);
                    if (this == titledPanel || !lastDockedWith.contains(titledPanelHolder.getDockable())) continue;
                    return titledPanel;
                }
            }
        }
        return null;
    }

    @Override
    protected void systemMenuMoveDocked() {
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        Dockable dockable = selectedHolder.getDockable();
        JComponent c = selectedHolder.getComponent();
        MoveFeedback.createMoveDock(dockable, c);
    }

    @Override
    protected void systemMenuMoveFloating() {
        MoveFeedback.createMoveFloat(this.getFloatContainer().getGUI());
    }

    @Override
    protected void systemMenuSizeFloating() {
        MoveFeedback.createSizeFloat(this.getFloatContainer().getGUI());
    }

    @Override
    protected void systemMenuSizeDocked() {
        DockPanel dp = this.getDockPanel();
        MoveFeedback.createSizeDock(dp, this);
    }

    @Override
    protected void whenSystemMenuClose(TitledPanelHolder selectedHolder) {
        TitledPanel.whenCloseTab(20, selectedHolder);
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public void titleChange(TitleChangeEvent e) {
        Dockable dockable = e.getDockable();
        this.adjustTitle(dockable);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void whenClose(final int flags) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int i = TitledPanel.this.getClientCount();
                while (i-- > 0) {
                    TitledPanelHolder holder = TitledPanel.this.getHolder(i);
                    TitledPanel.whenCloseTab(flags, holder);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    protected void whenMaximize(int flags) {
        if (this.isFloating()) {
            return;
        }
        TitledPanelHolder holder = this.getSelectedHolder();
        MaximizedTitledPanel maximizedTitledPanel = new MaximizedTitledPanel(this, holder);
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        mainWindow.maximize(maximizedTitledPanel);
    }

    @Override
    protected void whenRestore(int flags, DockableHolder selectedHolder) {
    }

    void maximizeHolder(DockableHolder holder) {
        GraphicsUtils.focusComponentOrChild((Component)this.centerComponent, (boolean)true);
    }

    void restoreHolder(TitledPanelHolder holder) {
        this.setHolder(holder, true);
    }

    private void setHolder(TitledPanelHolder holder, boolean setFocus) {
        if (this.centerComponent != null) {
            this.centerPanel.remove(this.centerComponent);
            this.centerComponent.setVisible(false);
            this.centerComponent = null;
        }
        if (holder != null) {
            this.centerComponent = holder.getOrCreateComponent();
            if (this.centerComponent != null) {
                this.centerComponent.setVisible(true);
                try {
                    this.centerPanel.add((Component)this.centerComponent, "Center");
                }
                catch (Exception ex) {
                    Logger.getAnonymousLogger().warning("Illegal state while adding the component to the container: Component: " + this.centerComponent.getClass() + " Container: " + this.centerPanel.getClass());
                    ex.printStackTrace();
                }
                if (setFocus) {
                    GraphicsUtils.focusComponentOrChild((Component)this.centerComponent, (boolean)true);
                }
            } else {
                String uniqueName = holder.getDockable().getUniqueName();
                Logger.getAnonymousLogger().warning("Dockable failed to create the component: " + uniqueName);
            }
        }
    }

    @Override
    protected void whenMinimize(int flags) {
        if (this.isFloating()) {
            return;
        }
        boolean wasActive = this.isActive();
        this.minimize(true, flags);
        if (wasActive) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public void restore(int flags) {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin.hasShutter(this)) {
            shutterMargin.removeShutter(this);
            ShutterManager shutterManager = ShutterManager.getInstance();
            ShutterPanel shutterPanel = shutterManager.getShutterPanel();
            for (int i = 0; i < this.getClientCount(); ++i) {
                TitledPanelHolder h = this.getHolder(i);
                h.setMinimized(false);
                if (!shutterPanel.isClientAccessible(h)) continue;
                shutterManager.hideShutterPanel(0);
            }
            TitledPanelHolder holder = this.getSelectedHolder();
            this.setHolder(holder, true);
            this.setVisible(true);
            TitledPanel.fireDockableShown(holder, flags);
            DockStationImpl.getInstance().activateDockable(holder.getDockable());
        }
    }

    void minimize(boolean showEffects, int flags) {
        DockStationImpl.getInstance().markCurrentLayoutDirty();
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin == null) {
            return;
        }
        if (!shutterMargin.hasShutter(this)) {
            for (int i = 0; i < this.getClientCount(); ++i) {
                TitledPanelHolder h = this.getHolder(i);
                h.setMinimized(true);
            }
            this.setVisible(false);
            shutterMargin.addShutter(this, showEffects);
            TitledPanelHolder holder = this.getSelectedHolder();
            if (holder != null) {
                TitledPanel.fireDockableHidden(holder, flags);
            }
        }
    }

    boolean saveLayout(StructuredPropertyAccess parent) {
        boolean saved = false;
        int n = this.getClientCount();
        for (int i = 0; i < n; ++i) {
            DefaultStructuredPropertyAccess dockableNode = new DefaultStructuredPropertyAccess("dockable");
            try {
                Site site;
                TitledPanelHolder holder = this.getHolder(i);
                Dockable dockable = holder.getDockable();
                if (BitField.isSet(dockable.getType(), 64)) continue;
                saved = true;
                this.updateSiteInfo(dockable);
                String strViewId = dockable.getUniqueName();
                DockStationImpl.getInstance().saveViewData(dockable);
                dockableNode.setProperty("ID", strViewId);
                Boolean floatOnTop = holder.getFloatOnTop();
                if (floatOnTop != null) {
                    dockableNode.setBooleanProperty("floatOnTop", floatOnTop);
                }
                if ((site = dockable.getSite()) != null) {
                    dockableNode.setIntegerProperty("dockWidth", site.size.width);
                    dockableNode.setIntegerProperty("dockHeight", site.size.height);
                    dockableNode.setIntegerProperty("floatWidth", site.geometry.width);
                    dockableNode.setIntegerProperty("floatHeight", site.geometry.height);
                    dockableNode.setIntegerProperty("floatOrientation", this.dockPanelPosition.getDockPanelOrientation());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            parent.appendChild(dockableNode);
        }
        return saved;
    }

    static TitledPanel loadLayout(StructuredPropertyAccess parent) {
        TitledPanel tp = null;
        Iterator childNodes = parent.getChildNodes("dockable");
        while (childNodes.hasNext()) {
            StructuredPropertyAccess node = (StructuredPropertyAccess)childNodes.next();
            try {
                DockableHolder dockableHolder = TitledPanel.loadClientLayout(node);
                if (dockableHolder == null) continue;
                if (tp == null) {
                    tp = new TitledPanel();
                    tp.setVisible(false);
                }
                tp.addClient(dockableHolder, 0);
                int floaterOrientation = node.getIntegerProperty("floatOrientation", -1);
                tp.dockPanelPosition = new DockPanelPositionCache(floaterOrientation);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return tp;
    }

    private boolean isShuttered() {
        boolean ret = false;
        ShutterMargin margin = this.getShutterMargin();
        if (margin != null && margin.hasShutter(this)) {
            ret = true;
        }
        return ret;
    }

    void loadVisibilityLayout(VisibilityLayout visibilityLayout, boolean isStartup, int flags) {
        int selectedIndex = this.getSelectedIndex();
        boolean isMinimized = false;
        boolean clientChange = false;
        int clientCount = this.getClientCount();
        boolean wasMinimized = this.isShuttered();
        DockStationImpl ds = DockStationImpl.getInstance();
        for (int i = 0; i < clientCount; ++i) {
            boolean mustChange;
            TitledPanelHolder holder = this.getHolder(i);
            Dockable dockable = holder.getDockable();
            boolean wasVisible = false;
            if (isStartup) {
                mustChange = true;
                clientChange = true;
            } else {
                int type = dockable.getType();
                boolean isGlobal = BitField.isSet(type, 32);
                boolean bl = mustChange = !isGlobal;
                if (mustChange) {
                    clientChange = true;
                    int dockableStatus = this.getDockableStatus(dockable);
                    wasVisible = BitField.isSet(dockableStatus, 8);
                    if (BitField.isSet(flags, 1)) {
                        ds.loadViewData(dockable);
                    }
                }
            }
            String uniqueName = dockable.getUniqueName();
            if (mustChange) {
                boolean isRaised;
                boolean isVisible = visibilityLayout.isVisible(uniqueName);
                if (isVisible != wasVisible) {
                    this.setClientVisible(dockable, isVisible, flags);
                }
                if (isRaised = visibilityLayout.isRaised(uniqueName)) {
                    selectedIndex = this.getClientComponentIndex(dockable);
                }
            }
            isMinimized = isMinimized || visibilityLayout.isMinimized(uniqueName);
        }
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
        if (clientChange && wasMinimized != isMinimized) {
            if (isMinimized) {
                this.minimize(false, flags);
            } else {
                this.restore(flags);
            }
        }
        if (this.isShuttered()) {
            this.setVisible(false);
        }
    }

    void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        int clientCount = this.getClientCount();
        for (int clientPos = 0; clientPos < clientCount; ++clientPos) {
            TitledPanelHolder holder = this.getHolder(clientPos);
            Dockable dockable = holder.getDockable();
            int dockableStatus = this.getDockableStatus(dockable);
            String uniqueName = dockable.getUniqueName();
            boolean isVisible = BitField.isSet(dockableStatus, 8);
            boolean isMinimized = BitField.isSet(dockableStatus, 4);
            boolean isSelected = selectedHolder == holder;
            visibilityLayout.setVisible(uniqueName, isVisible);
            visibilityLayout.setMinimized(uniqueName, isMinimized);
            visibilityLayout.setRaised(uniqueName, isSelected);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this._ptDragEnter = e.getLocation();
        DropTargetListener tabDropListener = this.findTabDropListener(this._ptDragEnter);
        if (tabDropListener != null) {
            tabDropListener.dragEnter(e);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Point location = e.getLocation();
        DropTargetListener tabDropListener = this.findTabDropListener(location);
        if (tabDropListener != null) {
            tabDropListener.dragOver(e);
        } else if (e.getSource() instanceof DropTarget) {
            this._tabHeader.getCustomTab().setSelectedPageViaMouse();
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        DropTargetListener tabDropListener = this.findTabDropListener(this._ptDragEnter);
        if (tabDropListener != null) {
            tabDropListener.dragExit(e);
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Point location = e.getLocation();
        DropTargetListener tabDropListener = this.findTabDropListener(location);
        if (tabDropListener != null) {
            tabDropListener.drop(e);
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        Point location = e.getLocation();
        DropTargetListener tabDropListener = this.findTabDropListener(location);
        if (tabDropListener != null) {
            tabDropListener.dropActionChanged(e);
        }
    }

    private DropTargetListener findTabDropListener(Point pt) {
        int pageAt = this._tabHeader.getCustomTab().getPageAt(pt);
        if (pageAt != -1) {
            TitledPanelHolder holder = this.getHolder(pageAt);
            Dockable dockable = holder.getDockable();
            return dockable.getTabDropListener();
        }
        return null;
    }

    void transferClients(TitledPanel from, int flags) {
        int clientCount = from.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            DefaultCustomTabPage page = from.getPage(0);
            TitledPanelHolder holder = from.getHolder(0);
            boolean visible = page.isVisible();
            from.removeClientAt(0, flags);
            int pagePos = this.addClient(holder, flags);
            if (!visible) continue;
            this.setClientVisible(pagePos, true, flags);
        }
    }

    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        int clientCount = this.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            TitledPanelHolder holder = this.getHolder(i);
            if (!holder.getDockablePath(path, criteria)) continue;
            path.setPagePos(i);
            return true;
        }
        return false;
    }

    void getDockablePaths(List<DockablePath> dockablePaths) {
        int clientCount = this.getClientCount();
        for (int i = 0; i < clientCount; ++i) {
            TitledPanelHolder holder = this.getHolder(i);
            int from = dockablePaths.size();
            holder.getDockablePaths(dockablePaths);
            int to = dockablePaths.size();
            for (int j = from; j < to; ++j) {
                DockablePath path = dockablePaths.get(j);
                path.setTitledPanel(this);
                path.setPagePos(i);
            }
        }
    }

    public void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        DockableHolderImpl dockableHolder;
        int pagePos = dockablePath.getPagePos();
        this.setClientVisible(pagePos, bVisible, flags);
        List<DockableHolderImpl> dockableHolders = dockablePath.getDockableHolders();
        if (dockableHolders.size() > 1 && (dockableHolder = dockableHolders.get(1)) instanceof DrawerEntryImpl) {
            DrawerEntryImpl drawerEntry = (DrawerEntryImpl)dockableHolders.get(1);
            drawerEntry.setClientVisible(bVisible, flags);
        }
    }

    boolean activate() {
        boolean ret = false;
        JComponent c = this.getSelectedClient();
        JComponent focusable = GraphicsUtils.getFocusableComponentOrChild((Component)c, (boolean)true);
        if (focusable != null) {
            focusable.requestFocus();
            ret = true;
        }
        return ret;
    }

    public boolean activateDockable(Dockable dockable) {
        return this.activateDockable(dockable, 0);
    }

    private boolean activateDockable(Dockable dockable, int flags) {
        boolean ret = false;
        int clientCount = this.getClientCount();
        for (int i = 0; !ret && i < clientCount; ++i) {
            TitledPanelHolder titledPanelHolder = this.getHolder(i);
            Dockable dockable_i = titledPanelHolder.getDockable();
            boolean activate = false;
            if (dockable.equals(dockable_i)) {
                activate = true;
            } else if (dockable_i instanceof DrawerDockableWindow) {
                DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable_i;
                List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
                for (DockableHolder dockableHolder : containedHolders) {
                    if (!dockable.equals(dockableHolder.getDockable())) continue;
                    activate = true;
                }
            }
            if (!activate) continue;
            if (this.isMinimizable() && titledPanelHolder.isMinimized()) {
                this.showFloatShutter(dockable, flags);
                ret = true;
                continue;
            }
            if (!this.isClientVisible(i)) continue;
            this.setSelectedIndex(i);
            this.activate();
            ret = true;
        }
        return ret;
    }

    public boolean activateDockable(DockablePath dockablePath, int flags) {
        Dockable dockable = dockablePath.getDockable();
        return this.activateDockable(dockable, flags);
    }

    boolean getActiveDockablePath(DockablePath dockablePath) {
        int selectedIndex;
        if (this.isActive() && (selectedIndex = this.getSelectedIndex()) >= 0) {
            dockablePath.setPagePos(selectedIndex);
            TitledPanelHolder holder = this.getHolder(selectedIndex);
            dockablePath.setParentHolder(holder);
            return true;
        }
        return false;
    }

    @Override
    boolean isActive() {
        return super.isActive() || this.centerComponent != null && this.centerComponent.getParent() instanceof MaximizedTitledPanel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            Themes.getActiveTheme().getStateProperties("onionskin", "normal").getPainter("bg").paint(g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    private static class DockPanelPositionCache {
        private DockPanel dockPanel = null;
        private int dockPanelOrientation = -1;

        DockPanelPositionCache(DockPanel dockPanel) {
            if (dockPanel != null) {
                this.dockPanel = dockPanel;
                this.dockPanelOrientation = DockStationImpl.getInstance().getPanelOrientation(dockPanel);
            }
        }

        DockPanelPositionCache(int dockPanelOrientation) {
            this.dockPanelOrientation = dockPanelOrientation;
            this.dockPanel = null;
        }

        boolean isFloaterPositionCached() {
            return this.hasDockPanel() || this.hasDockPanelOrientation();
        }

        boolean hasDockPanel() {
            return this.dockPanel != null;
        }

        boolean hasDockPanelOrientation() {
            return this.dockPanelOrientation != -1;
        }

        DockPanel getDockPanel() {
            return this.dockPanel;
        }

        int getDockPanelOrientation() {
            return this.dockPanelOrientation;
        }
    }

    private static final class TabCloseAction
    extends AbstractAction {
        public TabCloseAction() {
            this.putValue("ShortDescription", TabCloseAction.getCloseActionLabel());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            DefaultCustomTabPage page = (DefaultCustomTabPage)source;
            DockableHolder holder = (DockableHolder)page.getUserObject();
            TitledPanel.whenCloseTab(20, holder);
        }

        private static String getCloseActionLabel() {
            KeyStroke closePanelKeystroke = AbstractTitledPanel.getClosePanelKeyStroke();
            String name = IdeImplArb.getString(45) + " (" + KeyUtil.toString(closePanelKeystroke) + ")";
            return name;
        }
    }

    private static final class TabbedHeaderBorder
    extends AbstractBorder {
        private final TabbedHeader _tabHeader;

        TabbedHeaderBorder(TabbedHeader tabs) {
            this._tabHeader = tabs;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!Themes.isThemed()) {
                CustomTab customTab = this._tabHeader.getCustomTab();
                Color oldColor = g.getColor();
                Rectangle tabBounds = customTab.getBounds();
                int tabCornerSize = customTab.getCornerSize();
                int tabTop = tabBounds.y;
                int tabLeft = tabBounds.x;
                int cornerSize = tabTop > 0 || tabLeft > 0 ? 1 : tabCornerSize;
                g.setColor(IdeConstants.COLOR_IDE_LINES);
                g.translate(x, y);
                g.drawLine(width - 1, cornerSize, width - 1, height - 1);
                if (cornerSize > 1) {
                    g.drawLine(width - cornerSize - 1, 0, width - 1, cornerSize);
                }
                if (tabTop > 0) {
                    g.drawLine(cornerSize, 0, width - cornerSize - 1, 0);
                } else {
                    g.drawLine(tabBounds.x + tabBounds.width, 0, width - cornerSize - 1, 0);
                    if (tabLeft > 0) {
                        g.drawLine(cornerSize, 0, tabLeft + tabCornerSize, 0);
                    }
                }
                if (cornerSize > 1 && (tabLeft > 0 || tabTop > 0)) {
                    g.drawLine(0, cornerSize, cornerSize, 0);
                }
                g.drawLine(0, cornerSize, 0, height - 1);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.right = 1;
            return insets;
        }
    }

    private final class CenterPanelBorder
    extends LineBorder {
        CenterPanelBorder() {
            this(IdeConstants.COLOR_IDE_LINES);
        }

        CenterPanelBorder(Color color) {
            super(color);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets i = super.getBorderInsets(c);
            if (Themes.isThemed()) {
                i.top = 0;
            }
            return i;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets i = super.getBorderInsets(c, insets);
            if (Themes.isThemed()) {
                i.top = 0;
            }
            return i;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            if (Themes.isThemed()) {
                Theme t = Themes.getActiveTheme();
                g.setColor(t.getStateProperties("view", TitledPanel.this.isActive() ? "active" : "inactive").getColor("bordercolor"));
            } else {
                g.setColor(this.lineColor);
            }
            g.translate(x, y);
            if (!Themes.isThemed()) {
                g.drawLine(0, 0, width - 1, 0);
            }
            g.drawLine(0, 0, 0, height - (Themes.isThemed() ? 1 : 2));
            g.drawLine(1, height - 1, width - (Themes.isThemed() ? 1 : 2), height - 1);
            g.drawLine(width - 1, 0, width - 1, height - (Themes.isThemed() ? 1 : 2));
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private final class EventListener
    implements ListSelectionListener,
    MouseInputListener {
        private EventListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TitledPanel.this.whenTabSelectionChanges(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TitledPanel.this.tabMouseClicked(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TitledPanel.this.tabMouseDragged(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TitledPanel.this.tabMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TitledPanel.this.tabMouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

