/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Animator;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerElement;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.DrawerPanel;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DrawerElementImpl;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.DrawerModelImpl;
import oracle.ideimpl.docking.MinimizedTray;

public final class DrawerPanelImpl
extends DrawerPanel
implements DockableDropTarget {
    private static final int COLLAPSE_SMALL_DRAWERS_THRESHOLD = 20;
    private static boolean _actionsCreated;
    private final DrawerDockableWindow _drawerDockableWindow;
    private final JComponent _bottomComponent;
    private ArrayList<Double> _drawerRatios;
    private int _dropFeedbackPos = -1;
    private Listeners _listeners = new Listeners();
    private DockableDragContext _dockableDragContext;
    private Point _relativeStartPoint;
    private static final int FEEDBACK_HEIGHT = 100;

    public DrawerPanelImpl(DrawerDockableWindow drawerDockableWindow) {
        DrawerPanelImpl.createActions();
        this._drawerDockableWindow = drawerDockableWindow;
        this._bottomComponent = new JLabel(IdeIcons.getIcon((int)6));
        this._bottomComponent.setRequestFocusEnabled(false);
        this._bottomComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._bottomComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DrawerPanelImpl.this.whenTrayClicked();
            }
        });
        this.add(this._bottomComponent);
        AbstractAction prevPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerPanelImpl.this.whenPrevPanel();
            }
        };
        AbstractAction nextPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerPanelImpl.this.whenNextPanel();
            }
        };
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(117, 1), prevPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(117, 0), nextPanelAction);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(prevPanelAction, prevPanelAction);
        actionMap.put(nextPanelAction, nextPanelAction);
        this.setBackground(Color.WHITE);
        DrawerModelImpl model = this.getModel();
        Listener listener = new Listener();
        model.addListDataListener(listener);
        if (model.size() > 0) {
            ListDataEvent addAllEvent = new ListDataEvent(model, 1, 0, model.size() - 1);
            listener.intervalAdded(addAllEvent);
        }
    }

    private void addDrawerElement(DrawerEntryImpl drawerEntry, int index) {
        DrawerElementImpl drawerElement = drawerEntry.getOrCreateComponent();
        DockableWindow dockable = drawerEntry.getDockable();
        MenuToolButton menuToolButton = new MenuToolButton(IdeAction.newLocalAction(DrawerDockableWindow.DROP_DOWN_ACTION_ID, dockable));
        menuToolButton.setBorder(BorderFactory.createEmptyBorder());
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.RESTORE_ACTION_ID, dockable));
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.MOVE_ACTION_ID, dockable));
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.SIZE_ACTION_ID, dockable));
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.FLOAT_ACTION_ID, dockable));
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.MINIMIZE_ACTION_ID, dockable));
        menuToolButton.addPopupItem(IdeAction.newLocalAction(DrawerDockableWindow.MAXIMIZE_ACTION_ID, dockable));
        menuToolButton.setOpaque(false);
        menuToolButton.setBorderPainted(false);
        drawerElement.addButton(menuToolButton);
        Ide.getMainWindow().registerView(dockable);
        if (DrawerModel.State.VISIBLE.equals((Object)drawerEntry.getState())) {
            this.addDrawer(index, drawerElement);
            DockStationImpl.getInstance().addToCache(dockable);
        }
    }

    private void removeDrawerElement(DrawerEntryImpl drawerEntry) {
        DockableWindow dockableWindow = drawerEntry.getDockable();
        DockStationImpl.getInstance().removeFromCache(dockableWindow);
        Ide.getMainWindow().unregisterView(dockableWindow);
        DrawerElementImpl drawerElement = drawerEntry.getComponent();
        if (drawerElement != null) {
            this.removeDrawer(drawerElement);
        }
    }

    public void dumpDrawerSizes() {
        System.out.println("======================================");
        List<DrawerElementImpl> drawers = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawers) {
            System.out.println(drawerElement.getLabel() + ":" + drawerElement.getRealRatio() + "/" + drawerElement.getRatio());
        }
    }

    @Override
    public void addDrawer(int pos, DrawerElement drawerElement) {
        this.add(drawerElement);
        this.whenVisibleDrawerCountChanges();
        List<DrawerElementImpl> drawers = this.getDrawers();
        if (drawers.size() == 1) {
            DrawerElementImpl drawerElementImpl = (DrawerElementImpl)drawerElement;
            drawerElementImpl.setExpanded(true);
        }
    }

    @Override
    public void removeDrawer(DrawerElement drawerElement) {
        this.remove(drawerElement);
        this.whenVisibleDrawerCountChanges();
    }

    protected final void addDropFeedback(int position) {
        this._dropFeedbackPos = position;
        this.invalidate();
        this.validate();
    }

    protected final void removeDropFeedback() {
        this.addDropFeedback(-1);
    }

    public List<DrawerElementImpl> getDrawers() {
        DrawerModelImpl model = this.getModel();
        List<DrawerEntryImpl> entries = model.getEntries();
        ArrayList<DrawerElementImpl> drawerElements = new ArrayList<DrawerElementImpl>();
        for (DrawerEntry drawerEntry : entries) {
            if (drawerEntry.getState() != DrawerModel.State.VISIBLE) continue;
            DrawerElementImpl drawerElement = (DrawerElementImpl)drawerEntry.getOrCreateComponent();
            drawerElements.add(drawerElement);
        }
        return drawerElements;
    }

    @Override
    public void doLayout() {
        int i;
        int allocatableHeight;
        Insets insets = this.getInsets();
        int width = this.getWidth();
        int availableWidth = width - (insets.left + insets.right);
        int height = this.getHeight();
        Dimension bottomPrefSize = this._bottomComponent.getPreferredSize();
        int bottomPrefHeight = bottomPrefSize.height;
        int bottomPrefWidth = bottomPrefSize.width;
        this._bottomComponent.setBounds(width - insets.right - bottomPrefWidth, height - insets.bottom - bottomPrefHeight, bottomPrefWidth, bottomPrefHeight);
        List<DrawerElementImpl> drawers = this.getDrawers();
        int titlebarHeights = 0;
        double totalRatio = 0.0;
        int expandedCount = 0;
        for (DrawerElementImpl drawerElement : drawers) {
            if (drawerElement.isExpanded()) {
                double ratio = drawerElement.getRatio();
                totalRatio += ratio;
                ++expandedCount;
            }
            int titlebarHeight = drawerElement.getTitlebarHeight();
            titlebarHeights += titlebarHeight;
        }
        int availableHeight = height - (insets.top + bottomPrefHeight + insets.bottom);
        int remainingHeight = allocatableHeight = availableHeight - titlebarHeights;
        if (this._dropFeedbackPos >= 0) {
            remainingHeight -= 100;
        }
        int expandedLeft = expandedCount;
        double y = insets.top;
        boolean isAnimating = false;
        int drawerCount = drawers.size();
        double[] newRatios = new double[drawerCount];
        for (i = 0; i < drawerCount; ++i) {
            DrawerElementImpl drawerElement = drawers.get(i);
            if (i == this._dropFeedbackPos) {
                y += 100.0;
            }
            double newRatio = 1.0;
            int drawerHeight = drawerElement.getTitlebarHeight();
            if (drawerElement.isExpanded()) {
                if (--expandedLeft != 0) {
                    double ratio = drawerElement.getRatio();
                    if (totalRatio > 0.0) {
                        int componentHeight = (int)Math.round((double)remainingHeight * ratio / totalRatio);
                        drawerHeight += componentHeight;
                        remainingHeight -= componentHeight;
                        totalRatio -= ratio;
                        if (allocatableHeight > 0) {
                            newRatio = (double)componentHeight / (double)allocatableHeight;
                        }
                    }
                } else {
                    newRatio = (double)remainingHeight / (double)allocatableHeight;
                    drawerHeight += remainingHeight;
                }
                if (drawerElement.getExpansionRatio() != 1.0) {
                    isAnimating = true;
                }
            }
            drawerElement.setBounds(insets.left, (int)Math.ceil(y), availableWidth, drawerHeight);
            y += (double)drawerHeight;
            newRatios[i] = newRatio;
        }
        if (!isAnimating) {
            for (i = 0; i < drawerCount; ++i) {
                double newRatio = newRatios[i];
                DrawerElementImpl drawerElement = drawers.get(i);
                drawerElement.setRatio(newRatio);
            }
        }
    }

    public void expand(DrawerElementImpl drawerElement) {
        this.toggle(Collections.singletonList(drawerElement), null, true);
    }

    void toggleVisibility(DrawerElementImpl drawerElement) {
        switch (2) {
            case 1: {
                this.toggleVisibility_multipleOpen(drawerElement);
                break;
            }
            case 2: {
                this.toggleVisibility_closeOneAtATime(drawerElement);
                break;
            }
            case 3: {
                this.toggleVisibility_keepOne(drawerElement);
            }
        }
    }

    private void toggleVisibility_multipleOpen(DrawerElementImpl drawerElement) {
        List<DrawerElementImpl> singleton = Collections.singletonList(drawerElement);
        if (drawerElement.isExpanded()) {
            this.toggle(null, singleton, true);
        } else {
            this.toggle(singleton, null, true);
        }
    }

    private void toggleVisibility_closeOneAtATime(DrawerElementImpl drawerElement) {
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            if (expandedDrawers.size() > 1) {
                this.toggle(null, Collections.singletonList(drawerElement), true);
            }
        } else {
            List<DrawerElementImpl> expand = Collections.singletonList(drawerElement);
            List<DrawerElementImpl> collapse = this.getDrawers(true);
            this.toggle(expand, collapse, true);
        }
    }

    private void toggleVisibility_keepOne(DrawerElementImpl drawerElement) {
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> expanded = this.getDrawers(true);
            expanded.remove(drawerElement);
            if (!expanded.isEmpty()) {
                this.toggle(null, expanded, true);
            }
        } else {
            List<DrawerElementImpl> collapse = this.getDrawers(true);
            this.toggle(Collections.singletonList(drawerElement), collapse, true);
        }
    }

    @Override
    public void toggle(final List<? extends DrawerElement> expand, final List<? extends DrawerElement> collapse, boolean animate) {
        KeyboardFocusManager focusManager;
        Component component;
        DrawerElementImpl oldFocused = null;
        DrawerElementImpl newFocused = null;
        if (expand != null && !expand.isEmpty() && collapse != null && !collapse.isEmpty() && (component = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, this)) {
            for (int i = 0; newFocused == null && i < collapse.size(); ++i) {
                DrawerElementImpl drawerElement = (DrawerElementImpl)collapse.get(i);
                if (!SwingUtilities.isDescendingFrom(component, drawerElement)) continue;
                oldFocused = drawerElement;
                newFocused = (DrawerElementImpl)expand.get(0);
            }
        }
        if (animate) {
            if (this.isShowing()) {
                final DrawerElementImpl oldFocused2 = oldFocused;
                final DrawerElementImpl drawerElementImpl = newFocused;
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        DrawerElementImpl element;
                        double expansionRatio = (Double)evt.getNewValue();
                        if (expand != null) {
                            for (DrawerElement drawerElement : expand) {
                                element = (DrawerElementImpl)drawerElement;
                                element.setExpansionRatio(expansionRatio);
                            }
                        }
                        if (collapse != null) {
                            for (DrawerElement drawerElement : collapse) {
                                element = (DrawerElementImpl)drawerElement;
                                element.setExpansionRatio(1.0 - expansionRatio);
                            }
                        }
                        DrawerPanelImpl.this.invalidate();
                        DrawerPanelImpl.this.validate();
                        if (drawerElementImpl != null) {
                            oldFocused2.containerActivated(false);
                            drawerElementImpl.containerActivated(true);
                            Component firstComponent = drawerElementImpl.getComponent();
                            JComponent focusable = GraphicsUtils.getFocusableComponentOrChild((Component)firstComponent, (boolean)true);
                            focusable.requestFocus();
                        }
                        Graphics g = DrawerPanelImpl.this.getGraphics();
                        DrawerPanelImpl.this.paint(g);
                        g.dispose();
                    }
                };
                Animator.animate(30, 400L, 10, 0.6, 0.14, propertyChangeListener);
            }
        } else {
            if (expand != null) {
                for (DrawerElement drawerElement : expand) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(1.0);
                }
            }
            if (collapse != null) {
                for (DrawerElement drawerElement : collapse) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(0.0);
                }
            }
            this.invalidate();
            this.validate();
        }
    }

    protected final void insideDrag(DrawerElementImpl drawer1, DrawerElementImpl drawer2, int delta, DrawerElementImpl drawerElement) {
        Double ratio;
        int pos;
        double smallRatio;
        int height = this.getHeight();
        Insets insets = this.getInsets();
        List<DrawerElementImpl> drawers = this.getDrawers();
        int titlebarHeights = 0;
        for (DrawerElementImpl element : drawers) {
            int titlebarHeight = element.getTitlebarHeight();
            titlebarHeights += titlebarHeight;
        }
        int availableHeight = height - (insets.top + insets.bottom);
        double allocatableHeight = availableHeight - titlebarHeights;
        double newRatio1 = this.calcNewRatio(allocatableHeight, drawer1, delta);
        double newRatio2 = this.calcNewRatio(allocatableHeight, drawer2, -delta);
        if (newRatio1 * allocatableHeight < 1.0) {
            smallRatio = drawer1.getRatio();
            newRatio2 += smallRatio;
            drawer1.setExpanded(false);
            pos = drawers.indexOf(drawer1);
            ratio = this._drawerRatios.get(pos);
            if (ratio > 0.0) {
                drawer1.setRatio(ratio);
            }
        }
        if (newRatio2 * allocatableHeight < 1.0) {
            smallRatio = drawer2.getRatio();
            newRatio1 += smallRatio;
            pos = drawers.indexOf(drawer2);
            ratio = this._drawerRatios.get(pos);
            drawer2.setExpanded(false);
            if (ratio > 0.0) {
                drawer2.setRatio(ratio);
            }
        }
        if (newRatio1 * allocatableHeight >= 1.0 && newRatio2 * allocatableHeight >= 1.0) {
            drawer1.setRatio(newRatio1);
            drawer1.setExpanded(true);
            drawer2.setRatio(newRatio2);
            drawer2.setExpanded(true);
        }
        this.invalidate();
        this.validate();
    }

    private double calcNewRatio(double allocatableHeight, DrawerElementImpl drawerElement, int delta) {
        double ret = drawerElement.getRatio() + (double)delta / allocatableHeight;
        return ret;
    }

    void mousePressed(DrawerElementImpl drawerElement, MouseEvent e) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        int drawerCount = drawers.size();
        this._drawerRatios = new ArrayList(drawerCount);
        for (int i = 0; i < drawerCount; ++i) {
            DrawerElementImpl drawerElement_i = drawers.get(i);
            double ratio = drawerElement_i.getRatio();
            this._drawerRatios.add(ratio);
        }
        this.whenMousePressed(drawerElement, e);
    }

    void mouseDragged(DrawerElementImpl drawerElement, MouseEvent e) {
        this.whenMouseDragged(drawerElement, e);
    }

    void mouseReleased(DrawerElementImpl drawerElement, MouseEvent e) {
        this.whenMouseReleased(drawerElement, e);
        this.closeSmallDrawers();
        this._drawerRatios = null;
    }

    private void closeSmallDrawers() {
        ArrayList<DrawerElementImpl> collapse = new ArrayList<DrawerElementImpl>();
        List<DrawerElementImpl> drawers = this.getDrawers(true);
        for (DrawerElementImpl drawerElement : drawers) {
            int titlebarHeight = drawerElement.getTitlebarHeight();
            int height = drawerElement.getHeight();
            int componentHeight = height - titlebarHeight;
            if (componentHeight >= 20) continue;
            collapse.add(drawerElement);
        }
        if (!collapse.isEmpty()) {
            this.toggle(null, collapse, true);
        }
    }

    @Override
    public void minimize(final DrawerElement drawerElement, boolean animate) {
        DrawerElementImpl expandDrawerElement = null;
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> drawers;
            int thisPos = (drawers = this.getDrawers()).indexOf(drawerElement);
            expandDrawerElement = drawers.get(thisPos > 0 ? thisPos - 1 : thisPos);
        }
        if (animate) {
            final Rectangle sourceBounds = drawerElement.getBounds();
            final Rectangle destBounds = this._bottomComponent.getBounds();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    double r = (Double)evt.getNewValue();
                    drawerElement.setBounds((int)((double)sourceBounds.x + (double)(destBounds.x - sourceBounds.x) * r), (int)((double)sourceBounds.y + (double)(destBounds.y - sourceBounds.y) * r), (int)((double)sourceBounds.width + (double)(destBounds.width - sourceBounds.width) * r), (int)((double)sourceBounds.height + (double)(destBounds.height - sourceBounds.height) * r));
                    Graphics g = DrawerPanelImpl.this.getGraphics();
                    DrawerPanelImpl.this.paint(g);
                    g.dispose();
                }
            };
            Animator.animate(30, 600L, 10, 0.6, 0.14, propertyChangeListener);
        }
        this.remove(drawerElement);
        if (expandDrawerElement != null) {
            this.expand(expandDrawerElement);
        }
        this.whenVisibleDrawerCountChanges();
        this.invalidate();
        this.revalidate();
    }

    private void whenVisibleDrawerCountChanges() {
        List<DrawerElementImpl> drawers = this.getDrawers();
        boolean minimizable = drawers.size() > 1;
        for (DrawerElementImpl drawerElement : drawers) {
            drawerElement.setMinimizable(minimizable);
        }
    }

    private void whenTrayClicked() {
        DrawerModelImpl model = this.getModel();
        List<DrawerEntryImpl> entries = model.getEntries();
        MinimizedTray minimizedTray = new MinimizedTray(this);
        for (DrawerEntryImpl entry : entries) {
            if (DrawerModel.State.MINIMIZED != entry.getState()) continue;
            minimizedTray.addEntry(entry);
        }
        if (!minimizedTray.isEmpty()) {
            minimizedTray.expand(this);
        }
    }

    @Override
    public void restore(DrawerEntry entry, boolean animate) {
        DrawerElement drawerElement = entry.getOrCreateComponent();
        this.add(drawerElement);
        entry.setState(DrawerModel.State.VISIBLE);
        drawerElement.setExpanded(false);
        this.validate();
        List<DrawerElementImpl> collapse = this.getDrawers(true);
        this.toggle(Collections.singletonList(drawerElement), collapse, animate);
        this.whenVisibleDrawerCountChanges();
    }

    @Override
    public void show(DrawerEntry entry) {
        DrawerElementImpl drawerElement = (DrawerElementImpl)entry.getOrCreateComponent();
        this.add(drawerElement);
        entry.setState(DrawerModel.State.VISIBLE);
        this.whenVisibleDrawerCountChanges();
        this.invalidate();
        this.revalidate();
    }

    @Override
    public void hide(DrawerEntry entry) {
        DrawerElementImpl expandDrawerElement = null;
        DrawerElementImpl hiddenDrawerElement = (DrawerElementImpl)entry.getComponent();
        if (hiddenDrawerElement != null) {
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            expandedDrawers.remove(hiddenDrawerElement);
            if (expandedDrawers.isEmpty()) {
                DrawerElementImpl element;
                int i;
                List<DrawerElementImpl> drawers = this.getDrawers();
                int index = drawers.indexOf(hiddenDrawerElement);
                for (i = index - 1; expandDrawerElement == null && i >= 0; --i) {
                    element = drawers.get(i);
                    if (!element.isVisible()) continue;
                    expandDrawerElement = element;
                }
                for (i = index + 1; i < drawers.size(); ++i) {
                    element = drawers.get(i);
                    if (!element.isVisible()) continue;
                    expandDrawerElement = element;
                }
            }
            this.remove(hiddenDrawerElement);
            entry.setState(DrawerModel.State.HIDDEN);
            if (expandDrawerElement != null) {
                this.expand(expandDrawerElement);
            }
            this.whenVisibleDrawerCountChanges();
            this.invalidate();
            this.revalidate();
        }
    }

    public void whenMaximize(DrawerElementImpl drawerElement) {
        List<DrawerElementImpl> collapse = this.getDrawers(true);
        collapse.remove(drawerElement);
        List<DrawerElementImpl> expand = drawerElement.isExpanded() ? null : Collections.singletonList(drawerElement);
        this.toggle(expand, collapse, true);
    }

    private List<DrawerElementImpl> getDrawers(Boolean expanded) {
        ArrayList<DrawerElementImpl> ret = new ArrayList<DrawerElementImpl>();
        List<DrawerElementImpl> drawers = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawers) {
            if (expanded != null && drawerElement.isExpanded() != expanded.booleanValue()) continue;
            ret.add(drawerElement);
        }
        return ret;
    }

    private DrawerElementImpl getFocusedDrawerPos() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        for (DrawerElementImpl drawerElement : this.getDrawers()) {
            if (!SwingUtilities.isDescendingFrom(focusOwner, drawerElement)) continue;
            return drawerElement;
        }
        return null;
    }

    private void whenPrevPanel() {
        this.whenNextPrevPanel(-1);
    }

    private void whenNextPanel() {
        this.whenNextPrevPanel(1);
    }

    private void whenNextPrevPanel(int direction) {
        DrawerElementImpl focusedDrawerElement = this.getFocusedDrawerPos();
        if (focusedDrawerElement != null) {
            List<DrawerElementImpl> drawers = this.getDrawers();
            int focusedDrawerPos = drawers.indexOf(focusedDrawerElement);
            int activateDrawerPos = (focusedDrawerPos + direction + drawers.size()) % drawers.size();
            DrawerElementImpl activateDrawerElement = drawers.get(activateDrawerPos);
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            expandedDrawers.remove(activateDrawerElement);
            this.toggle(Collections.singletonList(activateDrawerElement), expandedDrawers, true);
            activateDrawerElement.getComponent().requestFocus();
        }
    }

    private Dockable getDockable(DrawerElementImpl drawerElement) {
        return this._drawerDockableWindow.getDockable(drawerElement);
    }

    protected void whenMousePressed(DrawerElementImpl drawerElement, MouseEvent e) {
        this._relativeStartPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), drawerElement);
    }

    protected void whenMouseDragged(DrawerElementImpl drawerElement, MouseEvent e) {
        if (this._relativeStartPoint != null) {
            Point ptScreen = e.getPoint();
            SwingUtilities.convertPointToScreen(ptScreen, e.getComponent());
            if (this._dockableDragContext == null) {
                DockStation dockStation = DockStation.getDockStation();
                this._dockableDragContext = dockStation.createDockableDragContext(this._listeners);
                Dockable dockable = this.getDockable(drawerElement);
                Dockable[] dockables = new Dockable[]{dockable};
                this._dockableDragContext.setDockables(dockables);
                this._dockableDragContext.setStartPoint(ptScreen);
                Dimension drawerSize = drawerElement.getSize();
                this._dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
            }
            this._dockableDragContext.mouseMoved(ptScreen, e.getModifiers());
        }
    }

    protected void whenMouseReleased(DrawerElementImpl drawerElement, MouseEvent e) {
        if (this._dockableDragContext != null) {
            Point ptScreen = e.getPoint();
            SwingUtilities.convertPointToScreen(ptScreen, e.getComponent());
            this._dockableDragContext.endDrag(ptScreen, e.getModifiers());
            this._dockableDragContext = null;
        }
    }

    private void whenDragCanceled() {
        this._relativeStartPoint = null;
        this._dockableDragContext = null;
    }

    @Override
    public boolean dragEnter(DockableDragContext dockableDragContext, Point ptScreen) {
        return this.dragOver(dockableDragContext, ptScreen);
    }

    @Override
    public boolean dragOver(DockableDragContext dockableDragContext, Point ptScreen) {
        return this.dragOrAccept(dockableDragContext, ptScreen, false);
    }

    @Override
    public void dragExit(DockableDragContext dockableDragContext) {
        this.removeDropFeedback();
    }

    @Override
    public void acceptDrop(DockableDragContext dockableDragContext, Point ptScreen) {
        this.dragOrAccept(dockableDragContext, ptScreen, true);
    }

    private boolean dragOrAccept(DockableDragContext dockableDragContext, Point ptScreen, boolean accept) {
        boolean ret = false;
        Dockable[] dockables = dockableDragContext.getDockables();
        if (dockables[0] instanceof DockableWindow) {
            DockableWindow draggedDockable = (DockableWindow)dockables[0];
            DrawerModelImpl model = this.getModel();
            int index = model.indexOf(draggedDockable);
            if (index != -1) {
                DrawerEntryImpl entry = model.getEntry(index);
                DrawerElementImpl draggedDrawerElement = entry.getOrCreateComponent();
                if (this.isDropReorder(ptScreen, draggedDrawerElement)) {
                    this.removeDropFeedback();
                    Dimension drawerSize = draggedDrawerElement.getSize();
                    this._dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
                    ret = true;
                } else {
                    int dropInsertPosition = this.getDropInsertPosition(ptScreen);
                    if (dropInsertPosition >= 0) {
                        List<DrawerElementImpl> drawers = this.getDrawers();
                        int sourcePos = drawers.indexOf(draggedDrawerElement);
                        int visibleDistance = this.getVisibleDistance(sourcePos, dropInsertPosition);
                        if (visibleDistance > 0) {
                            if (this.isDraggedOverFeedback(dropInsertPosition)) {
                                if (accept) {
                                    this.dragAccept(entry, dropInsertPosition);
                                }
                            } else if (accept) {
                                this.dragAccept(entry, dropInsertPosition);
                            } else {
                                this.addDropFeedback(dropInsertPosition);
                            }
                        } else {
                            this.removeDropFeedback();
                        }
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }

    private boolean isDraggedOverFeedback(int dropInsertPosition) {
        System.out.println("DockableDrawerPanel.isDraggedOverFeedback : " + dropInsertPosition + " == " + this._dropFeedbackPos);
        return dropInsertPosition == this._dropFeedbackPos;
    }

    private int getVisibleDistance(int from, int to) {
        int ret = from > to ? from - to : to - from - 1;
        return ret;
    }

    private void dragAccept(DrawerEntryImpl entry, int dropInsertPosition) {
        DrawerModelImpl model = this.getModel();
        model.move(entry, dropInsertPosition);
    }

    private DrawerModelImpl getModel() {
        return (DrawerModelImpl)this._drawerDockableWindow.getModel();
    }

    private boolean isDropReorder(Point ptScreen, DrawerElementImpl drawerElement) {
        boolean ret = false;
        if (this.containsScreenPoint(ptScreen)) {
            Point pt = new Point(ptScreen);
            SwingUtilities.convertPointFromScreen(pt, drawerElement);
            List<DrawerElementImpl> drawers = this.getDrawers();
            int pos = drawers.indexOf(drawerElement);
            DrawerElementImpl previous = null;
            DrawerElementImpl next = null;
            int delta = pt.y - this._relativeStartPoint.y;
            if (delta < 0) {
                for (int i = pos - 1; previous == null && i >= 0; --i) {
                    DrawerElementImpl drawerElement_i = drawers.get(i);
                    if (!drawerElement_i.isExpanded()) continue;
                    previous = drawerElement_i;
                }
                next = drawerElement;
            } else {
                if (pos > 0) {
                    previous = drawers.get(pos - 1);
                }
                int modelSize = drawers.size();
                for (int i = pos; next == null && i < modelSize; ++i) {
                    DrawerElementImpl drawerElement_i = drawers.get(i);
                    if (!drawerElement_i.isExpanded()) continue;
                    next = drawerElement_i;
                }
            }
            if (previous != null && next != null) {
                this.insideDrag(previous, next, delta, drawerElement);
                ret = true;
            }
        }
        return ret;
    }

    private boolean containsScreenPoint(Point ptScreen) {
        Point pt = new Point(ptScreen);
        SwingUtilities.convertPointFromScreen(pt, this);
        return this.contains(pt);
    }

    private int getDropInsertPosition(Point ptScreen) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        Rectangle bounds = new Rectangle();
        Point pt = new Point(ptScreen);
        SwingUtilities.convertPointFromScreen(pt, this);
        for (int i = 0; i < drawers.size(); ++i) {
            DrawerElementImpl element = drawers.get(i);
            element.getBounds(bounds);
            if (!bounds.contains(pt)) continue;
            Component component = element.getComponent();
            if (component != null) {
                if (pt.y < bounds.y + bounds.height / 2) {
                    return i;
                }
                return i + 1;
            }
            return i;
        }
        return -1;
    }

    @Override
    protected void saveLayout(StructuredPropertyAccess layout) {
        List<DrawerElementImpl> drawerElements = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawerElements) {
            double ratio = drawerElement.getRatio();
            boolean expanded = drawerElement.isExpanded();
            DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess("Drawer");
            propertyAccess.setProperty("Ratio", Double.toString(ratio));
            if (expanded) {
                propertyAccess.setBooleanProperty("Expanded", true);
            }
            layout.appendChild(propertyAccess);
        }
    }

    @Override
    protected void loadLayout(StructuredPropertyAccess layout) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        Iterator childNodes = layout.getChildNodes("Drawer");
        for (int i = 0; i < drawers.size() && childNodes.hasNext(); ++i) {
            DrawerElementImpl drawerElement = drawers.get(i);
            StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)childNodes.next();
            String property = propertyAccess.getProperty("Ratio", "0");
            double ratio = Double.parseDouble(property);
            boolean expanded = propertyAccess.getBooleanProperty("Expanded", false);
            drawerElement.setRatio(ratio);
            drawerElement.setExpanded(expanded);
        }
    }

    private static void createActions() {
        if (!_actionsCreated) {
            IdeAction.get(DrawerDockableWindow.DROP_DOWN_ACTION_ID, (String)null, "Menu", null, null, IdeIcons.getInstance(), 28, null, true);
            IdeAction.get(DrawerDockableWindow.RESTORE_ACTION_ID, null, "Restore", null, null, null, null, true);
            IdeAction.get(DrawerDockableWindow.MOVE_ACTION_ID, null, "Move", null, null, null, null, true);
            IdeAction.get(DrawerDockableWindow.SIZE_ACTION_ID, null, "Size", null, null, null, null, true);
            IdeAction.get(DrawerDockableWindow.FLOAT_ACTION_ID, null, "Float", null, null, null, null, true);
            IdeAction.get(DrawerDockableWindow.MINIMIZE_ACTION_ID, null, "Minimize", null, null, null, null, true);
            IdeAction.get(DrawerDockableWindow.MAXIMIZE_ACTION_ID, null, "Maximize", null, null, null, null, true);
            _actionsCreated = true;
        }
    }

    private class Listeners
    implements DockableDragSource {
        private Listeners() {
        }

        @Override
        public void canceled() {
            DrawerPanelImpl.this.whenDragCanceled();
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            DrawerModelImpl model = DrawerPanelImpl.this.getModel();
            for (int i = 0; i <= index1 - index0; ++i) {
                DrawerEntryImpl entry = model.getEntry(index0 + i);
                DrawerPanelImpl.this.addDrawerElement(entry, index0 + i);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            DrawerModelImpl model = DrawerPanelImpl.this.getModel();
            for (int i = 0; i <= index1 - index0; ++i) {
                DrawerEntryImpl entry = model.getEntry(index0 + i);
                DrawerPanelImpl.this.removeDrawerElement(entry);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            throw new IllegalStateException();
        }
    }
}

