/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.Ide;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.util.BitField;
import oracle.ide.view.View;
import oracle.ideimpl.docking.controls.FloatingFeedback;

public class DockableDragContextImpl
implements DockableDragContext,
KeyEventDispatcher {
    private Dimension _dockedPreferredSize;
    private Dimension _floatingPreferredSize;
    private Dockable[] _dockables;
    private View[] views;
    private DockableDropTarget _currentDropTarget;
    private Point _startPoint;
    private boolean _hasDragStarted;
    private FloatingFeedback _floatingFeedback;
    private static final int START_DRAG_THRESHOLD = DockableDragContextImpl.getDragThreshold();
    private DockableDragSource _dockableDragSource;

    public DockableDragContextImpl(DockableDragSource dockableDragSource) {
        assert (dockableDragSource != null);
        this._dockableDragSource = dockableDragSource;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this);
    }

    private static int getDragThreshold() {
        String property = Ide.getProperty("docking.dragThreshold", "20");
        try {
            int i = Integer.parseInt(property);
            return i * i;
        }
        catch (NumberFormatException numberFormatException) {
            return 25;
        }
    }

    @Override
    public View[] views() {
        return this.views;
    }

    @Override
    public void views(View ... views) {
        this.views = views;
    }

    @Override
    public void setStartPoint(Point ptScreen) {
        this._startPoint = ptScreen;
    }

    @Override
    public Point getStartPoint() {
        return new Point(this._startPoint);
    }

    @Override
    public void setDockables(Dockable[] dockables) {
        this._dockables = dockables;
    }

    @Override
    public Dockable[] getDockables() {
        return (Dockable[])this._dockables.clone();
    }

    @Override
    public void setPreferredSizes(Dimension dockedPreferredSize, Dimension floatingPreferredSize) {
        this._dockedPreferredSize = dockedPreferredSize;
        this._floatingPreferredSize = floatingPreferredSize;
    }

    @Override
    public void mouseMoved(Point ptScreen, int modifiers) {
        assert (this._floatingPreferredSize != null);
        assert (this._dockedPreferredSize != null);
        if (this._hasDragStarted || this._startPoint.distanceSq(ptScreen) > (double)START_DRAG_THRESHOLD) {
            this._hasDragStarted = true;
            boolean isFloating = true;
            if (!BitField.isSet(modifiers, 2)) {
                Point pt = new Point();
                pt.setLocation(ptScreen);
                Object parentFrame = null;
                if (this._dockables != null) {
                    JComponent realComp = null;
                    for (int i = 0; i < this._dockables.length && ((realComp = this._dockables[i].getHostedComponent()) == null || (parentFrame = WindowUtils.getWindow((Component)realComp)) == null); ++i) {
                    }
                } else {
                    parentFrame = Ide.getMainWindow();
                }
                if (parentFrame == null) {
                    return;
                }
                SwingUtilities.convertPointFromScreen(pt, (Component)parentFrame);
                for (Component c = SwingUtilities.getDeepestComponentAt((Component)parentFrame, pt.x, pt.y); isFloating && c != null; c = c.getParent()) {
                    if (!(c instanceof DockableDropTarget)) continue;
                    DockableDropTarget dockableDropTarget = (DockableDropTarget)((Object)c);
                    if (dockableDropTarget == this._currentDropTarget) {
                        if (!dockableDropTarget.dragOver(this, ptScreen)) continue;
                        isFloating = false;
                        continue;
                    }
                    if (!dockableDropTarget.dragEnter(this, ptScreen)) continue;
                    if (this._currentDropTarget != null) {
                        this._currentDropTarget.dragExit(this);
                    }
                    this._currentDropTarget = dockableDropTarget;
                    isFloating = false;
                }
            }
            if (isFloating) {
                if (this._currentDropTarget != null) {
                    this._currentDropTarget.dragExit(this);
                    this._currentDropTarget = null;
                }
                ptScreen.translate(-this._floatingPreferredSize.width / 2, -this._floatingPreferredSize.height / 2);
                this.showFloatPanel(ptScreen, this._floatingPreferredSize);
            } else {
                this.hideFloatPanel();
            }
        }
    }

    private void showFloatPanel(Point ptScreen, Dimension dimension) {
        if (this._floatingFeedback == null) {
            this._floatingFeedback = new FloatingFeedback();
        }
        this._floatingFeedback.show(new Rectangle(ptScreen, dimension));
    }

    private void hideFloatPanel() {
        if (this._floatingFeedback != null) {
            this._floatingFeedback.hideFloatPanel();
            this._floatingFeedback = null;
        }
    }

    @Override
    public void cancelDrag() {
        this._dockableDragSource.canceled();
        this.reset();
    }

    private void reset() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        if (this._currentDropTarget != null) {
            this._currentDropTarget.dragExit(this);
            this._currentDropTarget = null;
        }
        this.hideFloatPanel();
    }

    @Override
    public void endDrag(Point ptScreen, int modifiers) {
        if (this._currentDropTarget != null) {
            this._currentDropTarget.acceptDrop(this, ptScreen);
        }
        this.reset();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        boolean ret = false;
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 27: {
                    this.cancelDrag();
                    ret = true;
                }
            }
        }
        return ret;
    }
}

