/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.log.LogPage;
import oracle.ideimpl.controls.SwitchablePanel;

public final class FlatTabbedWindow
extends TabbedWindow
implements ListSelectionListener {
    private SwitchablePanel _switchablePanel = new SwitchablePanel();

    public FlatTabbedWindow() {
        this(true);
    }

    public FlatTabbedWindow(boolean showCloseButtonOnTabs) {
        this._switchablePanel.getCustomTab().addSelectionListener(this);
        this._switchablePanel.getCustomTab().setMinTabWidth(30);
        if (showCloseButtonOnTabs) {
            this._switchablePanel.getCustomTab().setCloseAction(new TabCloseAction());
            this._switchablePanel.getCustomTab().setCtrlClickCloseEnabled(true);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._switchablePanel, "Center");
    }

    @Override
    public final void add(String name, Icon icon, Component gui, String tooltip, Object data) {
        this.add(name, icon, gui, tooltip, data, true);
    }

    public final void add(String name, Icon icon, Component gui, String tooltip, Object data, boolean takeFocus) {
        this._switchablePanel.addPage(name, icon, gui, tooltip, data);
        this.setActive(gui, takeFocus);
    }

    @Override
    public void removeComponent(Component component) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        this._switchablePanel.removePage(tabPage);
    }

    @Override
    public void setActive(Component component) {
        this.setActive(component, true);
    }

    public void setActive(Component component, boolean takeFocus) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        CustomTab customTab = this._switchablePanel.getCustomTab();
        customTab.setSelectedPage(customTab.searchPage(tabPage));
        this._switchablePanel.moveToFront(tabPage, takeFocus);
    }

    @Override
    public Object getActiveData() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) > -1) {
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)customTab.getPage(index);
            return tabPage.getUserObject();
        }
        return null;
    }

    @Override
    public int getCount() {
        return this._switchablePanel.getPageCount();
    }

    public void navigateLeft() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) - 1 >= 0) {
            customTab.setSelectedPage(index - 1);
        }
    }

    public void navigateRight() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) + 1 <= this.getCount() - 1) {
            customTab.setSelectedPage(index + 1);
        }
    }

    public void displayDropdownMenu() {
        this._switchablePanel.displayDropdownMenu();
    }

    public void highlightPage(LogPage page) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        int pageCount = customTab.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            Object userObject;
            CustomTabPage tabPage = customTab.getPage(i);
            if (!(tabPage instanceof DefaultCustomTabPage) || !((userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof LogPage) || userObject != page) continue;
            customTab.setHighlighted(i, true);
            break;
        }
    }

    public void highlightPage(Component component) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        DefaultCustomTabPage componentTabPage = this._switchablePanel.getTabPageForComponent(component);
        int pageCount = customTab.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage tabPage = customTab.getPage(i);
            if (tabPage != componentTabPage) continue;
            customTab.setHighlighted(i, true);
            break;
        }
    }

    public CustomTabPage getTabPageForComponent(Component component) {
        return this._switchablePanel.getTabPageForComponent(component);
    }

    @Override
    public TabbedWindow.PageInfo[] getPages() {
        int pageCount = this.getCount();
        TabbedWindow.PageInfo[] pages = new TabbedWindow.PageInfo[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            TabbedWindow.PageInfo pageInfo;
            CustomTab customTab = this._switchablePanel.getCustomTab();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)customTab.getPage(i);
            pages[i] = pageInfo = new TabbedWindow.PageInfo(tabPage.getLabel(), tabPage.getIcon(), this._switchablePanel.getComponentForPage(tabPage), tabPage.getTooltip(), tabPage.getUserObject());
        }
        return pages;
    }

    @Override
    public void addTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.add(TabbedWindowListener.class, l);
    }

    @Override
    public void removeTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.remove(TabbedWindowListener.class, l);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this._switchablePanel.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this._switchablePanel.removeMouseListener(listener);
    }

    public CustomTab getCustomTab() {
        return this._switchablePanel.getCustomTab();
    }

    public void setTabTooltip(Component component, String tooltip) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        tabPage.setTooltip(tooltip);
    }

    public void setTabName(Component component, String name) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        tabPage.setLabel(name);
        this._switchablePanel.validate();
        this._switchablePanel.invalidate();
        this._switchablePanel.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() == -1) {
            return;
        }
        Object data = this.getActiveData();
        if (data != null) {
            this._fireTabbedWindowListener(data);
        }
    }

    private void _fireTabbedWindowListener(Object data) {
        Object[] listeners = this.listenerList.getListenerList();
        TabbedWindowEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TabbedWindowListener.class) continue;
            if (e == null) {
                e = new TabbedWindowEvent(this, data);
            }
            ((TabbedWindowListener)listeners[i + 1]).activeChanged(e);
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
            FlatTabbedWindow.this._switchablePanel.removePage(tabPage);
        }
    }
}

