/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.Context;
import oracle.ide.extension.rules.functions.util.ElementAttributeUtils;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.ClassUtils;
import oracle.ideimpl.controller.SimpleAndRule;
import oracle.ideimpl.controller.SimpleNotRule;
import oracle.ideimpl.controller.SimpleOrRule;
import oracle.ideimpl.controller.SimpleParametersEvaluator;
import oracle.ideimpl.controller.SimpleParametersRule;
import oracle.ideimpl.controller.SimpleRule;
import oracle.ideimpl.controller.SimpleRuleErrorCallback;
import oracle.ideimpl.controller.SimpleRuleFactory;

class SimpleRuleVisitor
extends ElementVisitor {
    public static final ElementName AND_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "and");
    private static final ElementName OR_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "or");
    private static final ElementName NOT_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "not");
    private static final ElementName RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule");
    private static final ElementName PARAMETERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "parameters");
    private static final ElementName PARAM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "param");
    private SimpleRule _currentRule;
    private ArrayList<SimpleRule> _stack = new ArrayList();
    private HashMap<String, SimpleRuleFactory> _typeToFactory = new HashMap();
    private ElementVisitor _ruleVisitor;
    private static final SimpleRule ERROR_RULE = new ErrorRule();
    private ErrorCallback _errorCallback;
    private ParametersVisitor _parametersVisitor;
    private ParamVisitor _paramVisitor;
    private OperatorVisitor _operatorVisitor;

    SimpleRuleVisitor(ElementStartContext context) {
        this._typeToFactory.put("and", new SimpleAndRuleFactory());
        this._typeToFactory.put("or", new SimpleOrRuleFactory());
        this._typeToFactory.put("not", new SimpleNotRuleFactory());
        this._typeToFactory.put("always-enabled", new SimpleAlwaysEnabledRuleFactory());
        this._typeToFactory.put("context-has-view", new SimpleViewRuleFactory());
        this._typeToFactory.put("context-has-node", new SimpleNodeRuleFactory());
        this._typeToFactory.put("context-has-project", new SimpleProjectRuleFactory());
        this._typeToFactory.put("context-has-workspace", new SimpleWorkspaceRuleFactory());
        this._typeToFactory.put("node-is-dirty", new SimpleDirtyRuleFactory());
        this._typeToFactory.put("is-single-selection", new SimpleSingleSelectionRuleFactory());
        this._typeToFactory.put("is-multiple-selection", new SimpleMultipleSelectionRuleFactory());
        this._typeToFactory.put("context-has-element", new SimpleElementRuleFactory());
        this._typeToFactory.put("element-has-data", new SimpleDataRuleFactory());
        this._typeToFactory.put("element-has-attribute", new SimpleElementHasAttributeRuleFactory());
        this._typeToFactory.put("all-selections-have-attribute", new SimpleAllHaveAttributeRuleFactory());
        this._typeToFactory.put("any-selection-has-attribute", new SimpleAnyHasAttributeRuleFactory());
        this._typeToFactory.put("project-properties-has-key", new SimpleProjectPropertiesHasKeyRuleFactory());
        this._ruleVisitor = this;
        this._errorCallback = new ErrorCallback();
        this._parametersVisitor = new ParametersVisitor();
        this._paramVisitor = new ParamVisitor();
        this._operatorVisitor = new OperatorVisitor();
        this.registerChildVisitors(context);
    }

    public SimpleRule getRule() {
        return this._currentRule;
    }

    public void registerChildVisitors(ElementStartContext context) {
        context.registerChildVisitor(AND_ELEMENT, (ElementVisitor)this._operatorVisitor);
        context.registerChildVisitor(OR_ELEMENT, (ElementVisitor)this._operatorVisitor);
        context.registerChildVisitor(NOT_ELEMENT, (ElementVisitor)this._operatorVisitor);
        context.registerChildVisitor(RULE_ELEMENT, this._ruleVisitor);
    }

    private void push(SimpleRule rule) {
        this._stack.add(rule);
    }

    private SimpleRule pop() {
        return this._stack.remove(this._stack.size() - 1);
    }

    private SimpleRule peek() {
        if (this._stack.isEmpty()) {
            return null;
        }
        return this._stack.get(this._stack.size() - 1);
    }

    public void start(ElementStartContext context) {
        String type = context.getAttributeValue("type");
        if (type == null) {
            this.log((ElementContext)context, Level.SEVERE, "rule missing type attribute");
        } else {
            SimpleRuleFactory factory = this._typeToFactory.get(type);
            if (factory == null) {
                this.log((ElementContext)context, Level.SEVERE, "unknown rule type \"" + type + "\"");
            } else {
                SimpleRule rule = factory.newRule();
                this.push(rule);
                context.registerChildVisitor(PARAMETERS_ELEMENT, (ElementVisitor)this._parametersVisitor);
                String name = context.getAttributeValue("name");
                String value = context.getAttributeValue("value");
                if (name != null && value != null) {
                    this.peek().addParam(name, value);
                }
                if ((name == null || value == null) && name != value) {
                    this.log((ElementContext)context, Level.SEVERE, "Missing name or value attribute");
                }
                return;
            }
        }
        this.push(ERROR_RULE);
    }

    public void end(ElementEndContext context) {
        this.commonRuleEnd((ElementContext)context);
    }

    private void commonRuleEnd(ElementContext context) {
        this._currentRule = this.pop();
        if (this._currentRule != ERROR_RULE && !this._stack.isEmpty()) {
            this.peek().addOperand(this._currentRule);
        }
        this._errorCallback.validate(this._currentRule, context);
        this._currentRule.validate(this._errorCallback);
    }

    boolean elementHasAttribute(HashMap<String, String[]> properties, Element element) {
        String[] attributes = properties.get("element-attribute");
        if (attributes != null) {
            for (String attribute : attributes) {
                int value = ElementAttributeUtils.getElementAttribute(attribute);
                if (value < 0 || !element.getAttributes().isSet(value)) continue;
                return true;
            }
        }
        return false;
    }

    class SimpleAndRuleFactory
    extends SimpleRuleFactory {
        SimpleAndRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleAndRule();
        }
    }

    class SimpleOrRuleFactory
    extends SimpleRuleFactory {
        SimpleOrRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleOrRule();
        }
    }

    class SimpleNotRuleFactory
    extends SimpleRuleFactory {
        SimpleNotRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleNotRule();
        }
    }

    class SimpleAlwaysEnabledRuleFactory
    extends SimpleRuleFactory {
        SimpleAlwaysEnabledRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleTrueRule("context-has-view");
        }
    }

    class SimpleViewRuleFactory
    extends SimpleRuleFactory {
        SimpleViewRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("context-has-view", new ContextHasViewEvaluator());
        }
    }

    class SimpleNodeRuleFactory
    extends SimpleRuleFactory {
        SimpleNodeRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("context-has-node", new ContextHasNodeEvaluator());
        }
    }

    class SimpleProjectRuleFactory
    extends SimpleRuleFactory {
        SimpleProjectRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("context-has-project", new ContextHasProjectEvaluator());
        }
    }

    class SimpleWorkspaceRuleFactory
    extends SimpleRuleFactory {
        SimpleWorkspaceRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("context-has-workspace", new ContextHasWorkspaceEvaluator());
        }
    }

    class SimpleDirtyRuleFactory
    extends SimpleRuleFactory {
        SimpleDirtyRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("node-is-dirty", new NodeIsDirtyEvaluator());
        }
    }

    class SimpleSingleSelectionRuleFactory
    extends SimpleRuleFactory {
        SimpleSingleSelectionRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("is-single-selection", new IsSingleSelectionEvaluator());
        }
    }

    class SimpleMultipleSelectionRuleFactory
    extends SimpleRuleFactory {
        SimpleMultipleSelectionRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("is-multiple-selection", new IsMultipleSelectionEvaluator());
        }
    }

    class SimpleElementRuleFactory
    extends SimpleRuleFactory {
        SimpleElementRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("context-has-element", new ContextHasElementEvaluator());
        }
    }

    class SimpleDataRuleFactory
    extends SimpleRuleFactory {
        SimpleDataRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("element-has-data", new ElementHasDataEvaluator());
        }
    }

    class SimpleElementHasAttributeRuleFactory
    extends SimpleRuleFactory {
        SimpleElementHasAttributeRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("element-has-attribute", new ElementHasAttributeEvaluator());
        }
    }

    class SimpleAllHaveAttributeRuleFactory
    extends SimpleRuleFactory {
        SimpleAllHaveAttributeRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("all-selections-have-attribute", new AllSelectionsHaveAttributeEvaluator());
        }
    }

    class SimpleAnyHasAttributeRuleFactory
    extends SimpleRuleFactory {
        SimpleAnyHasAttributeRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("any-selection-has-attribute", new AnySelectionHasAttributeEvaluator());
        }
    }

    class SimpleProjectPropertiesHasKeyRuleFactory
    extends SimpleRuleFactory {
        SimpleProjectPropertiesHasKeyRuleFactory() {
        }

        @Override
        public SimpleRule newRule() {
            return new SimpleParametersRule("project-properties-has-key", new ProjectPropertiesHasKeyEvaluator());
        }
    }

    private class ErrorCallback
    extends SimpleRuleErrorCallback {
        ElementContext context;

        private ErrorCallback() {
        }

        public void validate(SimpleRule rule, ElementContext context) {
            this.context = context;
            rule.validate(this);
        }

        @Override
        public void error(String msg) {
            SimpleRuleVisitor.this.log(this.context, Level.SEVERE, msg);
        }

        @Override
        public void warn(String msg) {
            SimpleRuleVisitor.this.log(this.context, Level.WARNING, msg);
        }
    }

    private class ParametersVisitor
    extends ElementVisitor {
        private ParametersVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(PARAM_ELEMENT, (ElementVisitor)SimpleRuleVisitor.this._paramVisitor);
        }
    }

    private class ParamVisitor
    extends ElementVisitor {
        private ParamVisitor() {
        }

        public void start(ElementStartContext context) {
            String name = context.getAttributeValue("name");
            String value = context.getAttributeValue("value");
            if (name == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing name attribute");
            }
            if (value == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing value attribute");
            } else if (name != null) {
                SimpleRuleVisitor.this.peek().addParam(name, value);
            }
        }
    }

    private class OperatorVisitor
    extends ElementVisitor {
        private OperatorVisitor() {
        }

        public void start(ElementStartContext context) {
            ElementName elementName = context.getElementName();
            String name = elementName.getLocalName();
            SimpleRuleFactory factory = SimpleRuleVisitor.this._typeToFactory.get(name);
            SimpleRule rule = factory.newRule();
            SimpleRuleVisitor.this.push(rule);
            SimpleRuleVisitor.this.registerChildVisitors(context);
        }

        public void end(ElementEndContext context) {
            SimpleRuleVisitor.this.commonRuleEnd((ElementContext)context);
        }
    }

    private static class ErrorRule
    extends SimpleRule {
        public ErrorRule() {
            super("error");
        }

        @Override
        public boolean evaluate(Context context) {
            return false;
        }
    }

    class IsMultipleSelectionEvaluator
    extends MetaEvaluator {
        IsMultipleSelectionEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 1) {
                String[] prop;
                String[] stringArray = prop = properties == null ? null : properties.get("element-class");
                if (prop == null) {
                    return true;
                }
                for (Element element : selection) {
                    if (this.isInstanceOf(element, "element-class", properties)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class IsSingleSelectionEvaluator
    extends MetaEvaluator {
        IsSingleSelectionEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1) {
                String[] prop;
                String[] stringArray = prop = properties == null ? null : properties.get("element-class");
                if (prop == null) {
                    return true;
                }
                return this.isInstanceOf(selection[0], "element-class", properties);
            }
            return false;
        }
    }

    class NodeIsDirtyEvaluator
    extends SimpleParametersEvaluator {
        NodeIsDirtyEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Node node = context.getNode();
            if (node != null) {
                return node.isDirty();
            }
            return false;
        }
    }

    class ContextHasWorkspaceEvaluator
    extends SimpleParametersEvaluator {
        ContextHasWorkspaceEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            return context.getWorkspace() != null;
        }
    }

    class ContextHasProjectEvaluator
    extends SimpleParametersEvaluator {
        ContextHasProjectEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            return context.getProject() != null;
        }
    }

    class ElementHasDataEvaluator
    extends MetaEvaluator {
        ElementHasDataEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element element = context.getElement();
            if (element == null) {
                return false;
            }
            return this.isInstanceOf(element.getData(), "data-class", properties);
        }
    }

    class ContextHasElementEvaluator
    extends MetaEvaluator {
        ContextHasElementEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            return this.isInstanceOf(context.getElement(), "element-class", properties);
        }

        @Override
        public void validate(HashMap<String, String[]> properties, SimpleRuleErrorCallback callback) {
            if (properties.get("element-class") == null) {
                callback.error("Missing 'element-class' property in rule");
            }
        }
    }

    class ProjectPropertiesHasKeyEvaluator
    extends MetaEvaluator {
        ProjectPropertiesHasKeyEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            if (context.getNode() != null && context.getNode() instanceof Project) {
                String[] props = properties.get("property-name");
                Project project = (Project)context.getNode();
                if (project.getProperties().containsKey(props[0])) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validate(HashMap<String, String[]> properties, SimpleRuleErrorCallback callback) {
            if (properties.get("property-name") == null) {
                callback.error("Missing 'property-name' property in rule");
            }
        }
    }

    class ContextHasNodeEvaluator
    extends MetaEvaluator {
        ContextHasNodeEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            return this.isInstanceOf(context.getNode(), "node-class", properties);
        }

        @Override
        public void validate(HashMap<String, String[]> properties, SimpleRuleErrorCallback callback) {
            if (properties.get("node-class") == null) {
                callback.error("Missing 'node-class' property in rule");
            }
        }
    }

    class ContextHasViewEvaluator
    extends MetaEvaluator {
        ContextHasViewEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            return this.isInstanceOf(context.getView(), "view-class", properties);
        }

        @Override
        public void validate(HashMap<String, String[]> properties, SimpleRuleErrorCallback callback) {
            if (properties.get("view-class") == null) {
                callback.error("Missing 'view-class' property in rule");
            }
        }
    }

    class AnySelectionHasAttributeEvaluator
    extends SimpleParametersEvaluator {
        AnySelectionHasAttributeEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element[] elements = context.getSelection();
            if (elements == null || elements.length == 0) {
                return false;
            }
            for (Element element : elements) {
                if (!SimpleRuleVisitor.this.elementHasAttribute(properties, element)) continue;
                return true;
            }
            return false;
        }
    }

    class AllSelectionsHaveAttributeEvaluator
    extends SimpleParametersEvaluator {
        AllSelectionsHaveAttributeEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element[] elements = context.getSelection();
            if (elements == null || elements.length == 0) {
                return false;
            }
            for (Element element : elements) {
                if (SimpleRuleVisitor.this.elementHasAttribute(properties, element)) continue;
                return false;
            }
            return true;
        }
    }

    class ElementHasAttributeEvaluator
    extends SimpleParametersEvaluator {
        ElementHasAttributeEvaluator() {
        }

        @Override
        public boolean evaluate(HashMap<String, String[]> properties, Context context) {
            Element element = context.getElement();
            if (element == null) {
                return false;
            }
            return SimpleRuleVisitor.this.elementHasAttribute(properties, element);
        }
    }

    abstract class MetaEvaluator
    extends SimpleParametersEvaluator {
        MetaEvaluator() {
        }

        protected boolean isInstanceOf(Object object, String propertyName, HashMap<String, String[]> properties) {
            if (object != null) {
                String[] classNames;
                String[] stringArray = classNames = properties == null ? null : properties.get(propertyName);
                if (classNames != null) {
                    Class<?> clazz = object.getClass();
                    for (String className : classNames) {
                        if (!ClassUtils.isInstanceOf(clazz, (String)className)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    class SimpleTrueRule
    extends SimpleRule {
        public SimpleTrueRule(String type) {
            super(type);
        }

        @Override
        public boolean evaluate(Context context) {
            return true;
        }
    }
}

