/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.menu.spi.ContextMenuHookHelper;
import javax.ide.menu.spi.MenuModel;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ideimpl.controller.SimpleRule;
import oracle.ideimpl.controller.SimpleRuleVisitor;
import oracle.ideimpl.jsr198.OracleActionRegistry;

public class EditorMenuHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "editor-menu-hook");
    private static final ElementName INSERT_WHEN_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "insert-when");
    private static final ElementName MENU_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "menu");
    private static final String RULE_ATTRIBUTE_NAME = "rule";
    private InsertWhenElementVisitor _insertWhenVisitor = new InsertWhenElementVisitor();
    private volatile MenuModel _menuModel;
    private static final String EDITOR_MENU_HOOK = "editorMenuHook";
    private List<HookData> _hookData = new ArrayList<HookData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItems(JMenu menu, Context context) {
        ArrayList<HookData> array;
        List<HookData> list = this._hookData;
        synchronized (list) {
            array = new ArrayList<HookData>(this._hookData);
        }
        for (HookData data : array) {
            this.doHook(data, context, menu);
        }
    }

    private void doHook(HookData data, Context context, JMenu menu) {
        if (data.evaluateRule(context)) {
            OracleActionRegistry registry = (OracleActionRegistry)OracleActionRegistry.getActionRegistry();
            registry.addToJMenu(menu, data.popupId, this._menuModel);
        }
    }

    public void start(ElementStartContext context) {
        RuleEngine ruleEngine;
        Map scopeData = context.getScopeData();
        EditorMenuData data = new EditorMenuData(this._menuModel);
        scopeData.put(EDITOR_MENU_HOOK, data);
        String possibleRuleId = this.getAttributeHelper(context, RULE_ATTRIBUTE_NAME, true, false);
        if (possibleRuleId != null && (ruleEngine = RuleEngine.getInstance()).validateRuleReference(possibleRuleId, (ElementContext)context)) {
            data.ruleId = possibleRuleId;
        }
        context.registerChildVisitor(INSERT_WHEN_ELEMENT, (ElementVisitor)this._insertWhenVisitor);
        context.registerChildVisitor(MENU_ELEMENT, (ElementVisitor)data.helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ElementEndContext context) {
        Map scopeData = context.getScopeData();
        EditorMenuData data = (EditorMenuData)scopeData.get(EDITOR_MENU_HOOK);
        this._menuModel = data.helper.getMenuModel();
        String popupId = data.helper.getPopupId();
        if (data.legacyRule == null && data.ruleId == null) {
            this.error((ElementContext)context, "<editor-menu-hook> requires either a valid value for the rule attribute or the deprecated <insert-when> child element");
        }
        if (!data.error) {
            List<HookData> list = this._hookData;
            synchronized (list) {
                this._hookData.add(new HookData(popupId, data.ruleId, data.legacyRule));
            }
        }
    }

    private void error(ElementContext context, String msg) {
        this.log(context, Level.SEVERE, msg);
        ((EditorMenuData)context.getScopeData().get((Object)EDITOR_MENU_HOOK)).error = true;
    }

    private class InsertWhenElementVisitor
    extends ElementVisitor {
        private InsertWhenElementVisitor() {
        }

        public void start(ElementStartContext context) {
            EditorMenuData data = (EditorMenuData)context.getScopeData().get(EditorMenuHook.EDITOR_MENU_HOOK);
            if (data.ruleId == null) {
                this.log((ElementContext)context, Level.WARNING, "Deprecated <insert-when> element encountered, instead use the rule attribute on <editor-menu-hook>");
                data.visitor = new SimpleRuleVisitor(context);
            } else {
                this.log((ElementContext)context, Level.WARNING, "Both the <editor-menu-hook> rule attribute and <insert-when> child were provided, this <insert-when> will be ignored");
            }
        }

        public void end(ElementEndContext context) {
            EditorMenuData data = (EditorMenuData)context.getScopeData().get(EditorMenuHook.EDITOR_MENU_HOOK);
            data.legacyRule = data.visitor.getRule();
            if (data.legacyRule != null && !data.legacyRule.verify(new String[]{"context-has-view"}, true)) {
                EditorMenuHook.this.error((ElementContext)context, "Missing positive context-has-view rule");
            }
        }
    }

    private static class HookData {
        String popupId;
        String ruleId;
        SimpleRule legacyRule;

        HookData(String popupId, String ruleId, SimpleRule legacyRule) {
            if (ruleId == null && legacyRule == null) {
                throw new IllegalArgumentException("ruleId and legacyRule parameters cannot both be null");
            }
            this.popupId = popupId;
            this.ruleId = ruleId;
            this.legacyRule = legacyRule;
        }

        boolean evaluateRule(Context context) {
            if (this.ruleId != null) {
                return RuleEngine.getInstance().evaluateRule(this.ruleId, context);
            }
            return this.legacyRule.evaluate(context);
        }
    }

    private static class EditorMenuData {
        private String ruleId;
        private SimpleRule legacyRule;
        private boolean error;
        private SimpleRuleVisitor visitor;
        private ContextMenuHookHelper helper;

        public EditorMenuData(MenuModel model) {
            this.helper = new ContextMenuHookHelper(EditorMenuHook.EDITOR_MENU_HOOK, model);
        }
    }
}

