/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Component;
import java.io.Serializable;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

final class PatchedLayoutComparator
implements Comparator,
Serializable {
    private static final Logger LOG = Logger.getLogger(PatchedLayoutComparator.class.getName());
    private Comparator _delegate;

    public PatchedLayoutComparator(Comparator delegate) {
        this._delegate = delegate;
    }

    public int compare(Object o1, Object o2) {
        try {
            return this._delegate.compare(o1, o2);
        }
        catch (ClassCastException e) {
            this._log((Component)o1, (Component)o2);
            throw e;
        }
        catch (NullPointerException e) {
            this._log((Component)o1, (Component)o2);
            throw e;
        }
    }

    private void _log(Component c1, Component c2) {
        this.dumpInfo(c1);
        this.dumpInfo(c2);
        LOG.log(Level.SEVERE, "Component hierarchy changed (probably in non EventDispatchThread) while FocusTraversablePolicy tries to find the right focusable component");
    }

    private void dumpInfo(Component c) {
        if (c == null) {
            LOG.log(Level.SEVERE, "Null Component");
            return;
        }
        Object indent = "-";
        StringBuilder sb = new StringBuilder("Component hierarchy for:\n");
        sb.append(c + "\nComponent Name: " + c.getName() + "\n");
        do {
            sb.append((String)indent + c.toString() + "\n");
            c = c.getParent();
            indent = "  " + (String)indent;
        } while (c != null);
        LOG.log(Level.SEVERE, sb.toString());
    }
}

