/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Locale;

public class MenuCJKUtil {
    private static final String INVOKED_TOKEN = "...";
    private static final String LOCAL_LANG = Locale.getDefault().getLanguage();
    private static final boolean isCJK = LOCAL_LANG.equals(Locale.CHINESE.getLanguage()) || LOCAL_LANG.equals(Locale.JAPANESE.getLanguage()) || LOCAL_LANG.equals(Locale.KOREAN.getLanguage());

    public static String addSingleByteCharsForMnemonics(String menuLabel) {
        if (menuLabel == null) {
            return null;
        }
        if (isCJK) {
            return menuLabel + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        }
        return menuLabel;
    }

    public static String getCJKMenuLabel(String label, Integer mnemonic) {
        if (mnemonic == null) {
            return label;
        }
        return MenuCJKUtil.getCJKMenuLabel(label, (int)mnemonic);
    }

    public static String getCJKMenuLabel(String label, int key) {
        return MenuCJKUtil.getModifiedMenuLabel(label, key);
    }

    private static String getModifiedMenuLabel(String label, int key) {
        boolean hasInvokedString = false;
        if (!isCJK || label == null) {
            return label;
        }
        label = ((String)label).trim();
        int length = ((String)label).length();
        boolean hasAmp = false;
        if (MenuCJKUtil.isInvoked((String)label)) {
            hasInvokedString = true;
            length -= 3;
        }
        if (length >= 4 && ((String)label).charAt(length - 4) == '(' && ((String)label).charAt(length - 3) == '&' && ((String)label).charAt(length - 1) == ')') {
            hasAmp = true;
            if (((String)label).charAt(length - 2) == (char)key) {
                return label;
            }
            length -= 4;
        }
        if (length >= 3 && !hasAmp && ((String)label).charAt(length - 3) == '(' && ((String)label).charAt(length - 1) == ')') {
            if (((String)label).charAt(length - 2) == (char)key) {
                return label;
            }
            length -= 3;
        }
        label = ((String)label).substring(0, length).trim();
        if (key != 0 && !MenuCJKUtil.labelContainsMnemonicChar((String)label, key)) {
            label = (String)label + MenuCJKUtil.getMnemonicToken(key, hasAmp);
        }
        if (hasInvokedString) {
            label = (String)label + INVOKED_TOKEN;
        }
        return label;
    }

    private static boolean labelContainsMnemonicChar(String label, int key) {
        char ch = (char)key;
        return label.indexOf(ch) != -1 || label.toLowerCase().indexOf(Character.toString(ch).toLowerCase()) != -1 || label.toUpperCase().indexOf(Character.toString(ch).toUpperCase()) != -1;
    }

    private static String getMnemonicToken(int key, boolean hasAmp) {
        String nmStr = "";
        if (key >= 97 && key <= 122 || key >= 65 && key <= 90) {
            if (hasAmp) {
                char[] keys = new char[]{'(', '&', (char)key, ')'};
                nmStr = new String(keys).toUpperCase();
            } else {
                char[] keys = new char[]{'(', (char)key, ')'};
                nmStr = new String(keys).toUpperCase();
            }
        }
        return nmStr;
    }

    private static boolean isInvoked(String label) {
        return label.trim().endsWith(INVOKED_TOKEN);
    }
}

