/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.ide.util.Assert;

public class FilePath {
    public static final int LOADING = 1;
    public static final int SAVING = 2;

    public static final boolean isAbsolute(String filename) {
        return new File(filename).isAbsolute();
    }

    public static final String makeQualified(String root, String relative) {
        Object result = null;
        if (root == null || relative == null || ((String)root).length() == 0 || relative.length() == 0) {
            result = "";
        } else {
            File relFile;
            String oldRelative = null;
            if (relative.startsWith("[") && relative.indexOf("]") > 0) {
                oldRelative = relative;
                relative = relative.substring(1, relative.indexOf("]"));
            }
            if ((relFile = new File(relative)).isAbsolute()) {
                try {
                    relative = relFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                result = relative;
            }
            if (result == null) {
                if (!((String)root).endsWith(File.separator)) {
                    root = (String)root + File.separator;
                }
                try {
                    result = new File((String)root + relative).getCanonicalPath();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    result = (String)root + relative;
                }
            }
            if (oldRelative != null) {
                result = "[" + (String)result + oldRelative.substring(oldRelative.indexOf("]"));
            }
        }
        return result;
    }

    public static final String makeRelative(String root, String path) {
        return FilePath.makeRelative(root, path, false);
    }

    public static final String makeRelative(String root, String path, boolean childrenOnly) {
        if (root == null || path == null || ((String)root).length() == 0 || path.length() == 0) {
            return "";
        }
        Object result = path;
        String oldResult = null;
        if (((String)result).startsWith("[") && ((String)result).indexOf("]") > 0) {
            oldResult = result;
            result = ((String)result).substring(1, ((String)result).indexOf("]"));
        }
        if (!FilePath.isAbsolute((String)result)) {
            return path;
        }
        try {
            root = new File(((String)root).trim()).getCanonicalPath();
            result = new File(((String)result).trim()).getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (((String)root).equals(result)) {
            result = "." + File.separator;
        } else if (!childrenOnly || ((String)result).startsWith((String)root)) {
            int len = ((String)result).length();
            if (len == 0) {
                result = "";
            } else {
                String startPath;
                if (!((String)root).endsWith(File.separator)) {
                    root = (String)root + File.separator;
                }
                if (((String)root).equals(startPath = ((String)result).substring(0, len = Math.min(((String)result).length(), ((String)root).length())))) {
                    result = ((String)result).substring(((String)root).length(), ((String)result).length());
                } else {
                    Object dotdot = "";
                    Object tempRoot = root;
                    while (((String)tempRoot).length() > 2) {
                        len = Math.min(((String)result).length(), ((String)tempRoot).length());
                        if (((String)tempRoot).equals(((String)result).substring(0, len))) {
                            StringBuffer buf = new StringBuffer(((String)result).substring(((String)tempRoot).length()));
                            if (buf.charAt(0) != File.separatorChar) {
                                buf.insert(0, File.separator);
                            }
                            buf.insert(0, (String)dotdot);
                            result = buf.toString();
                            break;
                        }
                        if (((String)tempRoot).endsWith(File.separator)) {
                            tempRoot = ((String)tempRoot).substring(0, ((String)tempRoot).length() - 1);
                        }
                        if ((tempRoot = FilePath.getParent((String)tempRoot)) == null) break;
                        if (((String)dotdot).length() > 0) {
                            dotdot = (String)dotdot + File.separator + "..";
                            continue;
                        }
                        dotdot = (String)dotdot + "..";
                    }
                }
            }
        }
        if (oldResult != null) {
            result = "[" + (String)result + oldResult.substring(oldResult.indexOf("]"));
        }
        return result;
    }

    public static String makePathQualified(String root, String path) {
        Assert.precondition((root != null && path != null ? 1 : 0) != 0);
        String result = null;
        if (path != null) {
            if (path.indexOf(File.pathSeparator) < 0) {
                result = path.length() == 0 ? path : FilePath.makeQualified(root, path);
            } else {
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                String elem = null;
                if (tok.hasMoreTokens()) {
                    elem = tok.nextToken();
                    if (elem.length() == 0) {
                        buf.append(elem);
                    } else {
                        buf.append(FilePath.makeQualified(root, elem));
                    }
                    while (tok.hasMoreTokens()) {
                        buf.append(File.pathSeparator);
                        elem = tok.nextToken();
                        if (elem.length() == 0 || FilePath.isAbsolute(elem)) {
                            buf.append(elem);
                            continue;
                        }
                        buf.append(FilePath.makeQualified(root, elem));
                    }
                }
                result = buf.toString();
            }
        }
        return result;
    }

    public static String makePathRelative(String root, String path) {
        return FilePath.makePathRelative(root, path, false);
    }

    public static String makePathRelative(String root, String path, boolean childrenOnly) {
        Assert.precondition((root != null && path != null ? 1 : 0) != 0);
        String result = null;
        if (path != null) {
            if (path.indexOf(File.pathSeparatorChar) < 0) {
                result = FilePath.makeRelative(root, path, childrenOnly);
            } else {
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                if (tok.hasMoreTokens()) {
                    buf.append(FilePath.makeRelative(root, tok.nextToken(), childrenOnly));
                    while (tok.hasMoreTokens()) {
                        buf.append(File.pathSeparator);
                        buf.append(FilePath.makeRelative(root, tok.nextToken(), childrenOnly));
                    }
                }
                result = buf.toString();
            }
        }
        return result;
    }

    public static final String getParent(String path) {
        return new File(path).getParent();
    }

    public static final String getFilename(String path) {
        return new File(path).getName();
    }

    public static final String getExtension(String path) {
        String name = FilePath.getFilename(path);
        int i = Math.min(name.lastIndexOf("."), name.length());
        if (i < 0) {
            return "";
        }
        return name.substring(i, name.length());
    }

    public static final String getName(String path) {
        String name = FilePath.getFilename(path);
        int i = Math.min(name.lastIndexOf("."), name.length());
        if (i < 0) {
            return name;
        }
        return name.substring(0, i);
    }

    public static final boolean mayBeADirectory(String fname) {
        File path = new File(fname);
        if (path.isDirectory()) {
            return true;
        }
        if (path.exists()) {
            return false;
        }
        return FilePath.getExtension(path.getAbsolutePath()).length() == 0;
    }

    public static final String convertPath(String path, int direction) {
        if (File.pathSeparatorChar == ';' && File.separatorChar == '\\') {
            return path;
        }
        if (direction == 1) {
            path = path.replace(';', File.pathSeparatorChar);
            path = path.replace('\\', File.separatorChar);
        } else if (direction == 2) {
            path = path.replace(File.pathSeparatorChar, ';');
            path = path.replace(File.separatorChar, '\\');
        } else {
            throw new IllegalArgumentException("direction must be 1 or 2");
        }
        return path;
    }

    public static final String getBasePath(String absolutePath, String relativePath) {
        String newPath = FilePath.makeQualified(absolutePath, relativePath);
        int i = newPath.indexOf(relativePath);
        if (i < 0) {
            return null;
        }
        return newPath.substring(0, i - 1);
    }
}

