/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class FileCopyUtil2 {
    private FileCopyUtil2() {
    }

    public static boolean copyFiles(String pathFrom, String pathTo) {
        try {
            if (pathFrom == null || pathTo == null) {
                return false;
            }
            File from = new File(pathFrom);
            if (!from.exists()) {
                return false;
            }
            File to = new File(pathTo);
            Files.walkFileTree(from.toPath(), new CopyVistor(from.toPath(), to.toPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Collection<File> findFilesOrDirectories(File baseSearchDir, String ... fileNames) {
        return FileCopyUtil2.findFilesOrDirectories(baseSearchDir, false, fileNames);
    }

    public static Collection<File> findFilesOrDirectories(File baseSearchDir, String fileName, boolean endOnFirst) {
        return FileCopyUtil2.findFilesOrDirectories(baseSearchDir, endOnFirst, fileName);
    }

    private static Collection<File> findFilesOrDirectories(File baseSearchDir, boolean endOnFirst, String ... fileNames) {
        if (baseSearchDir == null || fileNames == null) {
            return Collections.emptySet();
        }
        try {
            SearchVistor searchVistor = new SearchVistor(endOnFirst, fileNames);
            Files.walkFileTree(baseSearchDir.toPath(), searchVistor);
            return searchVistor.getFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
    }

    private static class CopyVistor
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;

        CopyVistor(Path fromPath, Path toPathFolder) {
            this.fromPath = fromPath;
            this.toPath = toPathFolder;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class SearchVistor
    extends SimpleFileVisitor<Path> {
        private String[] fileNames;
        private Collection<File> files = new HashSet<File>();
        private boolean endOnFirst;

        SearchVistor(boolean endOnFirst, String ... fileNames) {
            this.fileNames = fileNames;
            this.endOnFirst = endOnFirst;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return this.search(dir);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            return this.search(file);
        }

        private FileVisitResult search(Path dir) throws IOException {
            for (String fileName : this.fileNames) {
                if (!fileName.equals(dir.getFileName().toString())) continue;
                this.files.add(dir.toFile());
                if (!this.endOnFirst) continue;
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        private Collection<File> getFiles() {
            return this.files;
        }
    }
}

