/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Element;
import oracle.ide.refactoring.ActionHandlerInfo;
import oracle.ide.refactoring.ActionHandlersInfo;
import oracle.ide.refactoring.BaseActionHandler;
import oracle.ide.refactoring.DeleteHandlerService;
import oracle.ide.refactoring.GlobalActionHandlerValidator;
import oracle.ide.refactoring.MoveHandlerService;
import oracle.ide.refactoring.RenameHandlerService;
import oracle.ide.util.Assert;

abstract class AbstractActionHandlerService<CONCRETE_ACTION_HANDLER extends BaseActionHandler> {
    private static final String RENAME_OPERATION = "RENAME";
    private static final String MOVE_OPERATION = "MOVE";
    private static final String DELETE_OPERATION = "DELETE";
    private ActionHandlersInfo.ActionHandlersAddedListener actionHandlersAddedListener;
    private Map<String, HandlerLoadingInfo> m_element2HandlerMap = new HashMap<String, HandlerLoadingInfo>();
    private Map<String, Class<? extends CONCRETE_ACTION_HANDLER>> m_handlerName2ClassMap = new HashMap<String, Class<? extends CONCRETE_ACTION_HANDLER>>();
    private Map<String, Class<? extends GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>>> m_globalActionHandlerName2ClassMap = new HashMap<String, Class<? extends GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>>>();
    private ArrayList<BaseActionHandler.LookupHelper> m_lookupHelpers = new ArrayList();

    AbstractActionHandlerService() {
    }

    protected abstract <T extends CONCRETE_ACTION_HANDLER> T _createActionHandler(Context var1);

    final void _registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId, String[] bypassedGlobalActionHandlerValidatorClasses) {
        if (elementClassName == null || "".equals(elementClassName)) {
            throw new IllegalArgumentException("elementClassName '" + elementClassName + "' is mandatory argument");
        }
        if (refactoringActionHandlerClassName == null || "".equals(refactoringActionHandlerClassName)) {
            throw new IllegalArgumentException("refactoringActionHandlerClassName '" + refactoringActionHandlerClassName + "' is mandatory argument");
        }
        if (extensionId == null || "".equals(extensionId)) {
            throw new IllegalArgumentException("extensionId '" + extensionId + "' is mandatory argument");
        }
        HandlerLoadingInfo info = new HandlerLoadingInfo(refactoringActionHandlerClassName, bypassedGlobalActionHandlerValidatorClasses, extensionId);
        this.m_element2HandlerMap.put(elementClassName, info);
    }

    final void _registerActionHandler(Class<? extends Element> classKey, Class<? extends CONCRETE_ACTION_HANDLER> refactoringActionHandlerClass) {
        String elementClassName = classKey.getName();
        String refactoringActionHandlerClassName = refactoringActionHandlerClass.getName();
        HandlerLoadingInfo info = new HandlerLoadingInfo(refactoringActionHandlerClassName, new String[0], null);
        this.m_element2HandlerMap.put(elementClassName, info);
        this.m_handlerName2ClassMap.put(refactoringActionHandlerClassName, refactoringActionHandlerClass);
    }

    final Class<? extends CONCRETE_ACTION_HANDLER> _unregisterActionHandler(String elementClassName) {
        HandlerLoadingInfo info = this.m_element2HandlerMap.remove(elementClassName);
        if (info != null) {
            return this.m_handlerName2ClassMap.remove(info.getHandlerClassName());
        }
        return null;
    }

    final Class<? extends CONCRETE_ACTION_HANDLER> _unregisterActionHandler(Class<? extends Element> classKey) {
        String elementClassName = classKey.getName();
        return this._unregisterActionHandler(elementClassName);
    }

    final void _registerLookupHelper(BaseActionHandler.LookupHelper<? extends CONCRETE_ACTION_HANDLER> lookupHelper) {
        this.m_lookupHelpers.add(0, lookupHelper);
    }

    protected final HandlerData getHandlerData(Class<? extends Element> elementClass, Context context) {
        Class<CONCRETE_ACTION_HANDLER> handlerClass = this._getHandlerClass(elementClass, context);
        if (handlerClass != null) {
            return new HandlerData(handlerClass, null);
        }
        return this.lookupActionHandler(elementClass);
    }

    private final HandlerData lookupActionHandler(Class<? extends Element> elementClass) {
        HandlerLoadingInfo info = this.m_element2HandlerMap.get(elementClass.getName());
        Class<? extends Element> superClass = elementClass;
        while (info == null && superClass != null && !superClass.equals(Element.class)) {
            if ((superClass = superClass.getSuperclass()) == null) continue;
            info = this.m_element2HandlerMap.get(superClass.getName());
        }
        if (info != null) {
            String[] bypassedGlobalActionHandlerValidatorClasses;
            String extensionId;
            String handlerClassName = info.getHandlerClassName();
            Class handlerClass = this.m_handlerName2ClassMap.get(handlerClassName);
            if (handlerClass == null && (handlerClass = this.getClassForName(handlerClassName, extensionId = info.getExtensionId())) != null) {
                this.m_handlerName2ClassMap.put(handlerClassName, handlerClass);
            }
            ArrayList bypassedGlobalActionHandlerValidators = new ArrayList();
            for (String bypassedGlobalActionHandlerValidatorClass : bypassedGlobalActionHandlerValidatorClasses = info.getBypassedGlobalActionHandlerValidatorClasses()) {
                Class bypassedGlobalActionHandlerValidator = this.m_globalActionHandlerName2ClassMap.get(bypassedGlobalActionHandlerValidatorClass);
                if (bypassedGlobalActionHandlerValidator == null) {
                    String extensionId2 = info.getExtensionId();
                    bypassedGlobalActionHandlerValidator = this.getClassForName(bypassedGlobalActionHandlerValidatorClass, extensionId2);
                    if (!GlobalActionHandlerValidator.class.isAssignableFrom(bypassedGlobalActionHandlerValidator)) {
                        Assert.fail((String)("Class " + bypassedGlobalActionHandlerValidator + " specified as bypassed GlobalActionHandlerValidator for action handler " + handlerClassName + " is not a valid GlobalActionHandlerValidator"));
                    }
                    if (bypassedGlobalActionHandlerValidator != null) {
                        this.m_globalActionHandlerName2ClassMap.put(bypassedGlobalActionHandlerValidatorClass, bypassedGlobalActionHandlerValidator);
                    }
                }
                if (bypassedGlobalActionHandlerValidator == null) continue;
                bypassedGlobalActionHandlerValidators.add(bypassedGlobalActionHandlerValidator);
            }
            return new HandlerData(handlerClass, bypassedGlobalActionHandlerValidators);
        }
        return null;
    }

    protected final Class<? extends CONCRETE_ACTION_HANDLER> _getHandlerClass(Class<? extends Element> elementClass, Context context) {
        this.registerDeclarativeActionHandlersIfNeeded();
        for (BaseActionHandler.LookupHelper helper : this.m_lookupHelpers) {
            Class c = helper.lookup(elementClass, context);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private Class getClassForName(String className, String extensionId) {
        ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
        MetaClass metaClass = new MetaClass(loader, className);
        try {
            Class<Object> clz = metaClass.toClass().asSubclass(Object.class);
            return clz;
        }
        catch (ClassNotFoundException e) {
            Assert.fail((Exception)e);
            return null;
        }
    }

    protected final List<Class<? extends Element>> getAllSelectedElementSubtypes(Element[] elements) {
        ArrayList<Class<? extends Element>> subtypes = new ArrayList<Class<? extends Element>>();
        for (Element e : elements) {
            if (subtypes.contains(e.getClass())) continue;
            subtypes.add(e.getClass());
        }
        Collections.sort(subtypes, new Comparator<Class<? extends Element>>(){

            @Override
            public int compare(Class<? extends Element> o1, Class<? extends Element> o2) {
                if (o2 != null && o2.isAssignableFrom(o1)) {
                    return -1;
                }
                if (o1 != null && o1.isAssignableFrom(o2)) {
                    return 1;
                }
                return 0;
            }
        });
        return subtypes;
    }

    private void registerDeclarativeActionHandlersIfNeeded() {
        if (this.actionHandlersAddedListener != null) {
            return;
        }
        ActionHandlersInfo actionHandlersInfo = ActionHandlersInfo.getInstance();
        if (actionHandlersInfo != null) {
            this.registerActionHandlers(actionHandlersInfo.getActionHandlers());
            this.actionHandlersAddedListener = new ActionHandlersInfo.ActionHandlersAddedListener(){

                @Override
                public void addedActionHandlers(List<ActionHandlerInfo> actionHandlers) {
                    AbstractActionHandlerService.this.registerActionHandlers(actionHandlers);
                }
            };
            actionHandlersInfo.setActionHandlersAddedListener(this.actionHandlersAddedListener);
        }
    }

    private void registerActionHandlers(List<ActionHandlerInfo> actionHandlers) {
        for (ActionHandlerInfo info : actionHandlers) {
            String extensionId = info.getActionHandlerExtensionId();
            String handlerClassName = info.getActionHandlerClassName();
            String actionHandlerOperation = info.getActionHandlerOperation();
            String elementClassName = info.getActionHandlerElementClassName();
            String[] bypassGlobalValidationClassNames = info.getBypassedGlobalActionHandlerValidatorClasses();
            switch (actionHandlerOperation) {
                case "DELETE": {
                    DeleteHandlerService.registerActionHandler(elementClassName, handlerClassName, extensionId, bypassGlobalValidationClassNames);
                    break;
                }
                case "MOVE": {
                    MoveHandlerService.registerActionHandler(elementClassName, handlerClassName, extensionId, bypassGlobalValidationClassNames);
                    break;
                }
                case "RENAME": {
                    RenameHandlerService.registerActionHandler(elementClassName, handlerClassName, extensionId, bypassGlobalValidationClassNames);
                }
            }
        }
    }

    protected final CONCRETE_ACTION_HANDLER checkGlobalActionHandlerValidators(Context context, Map<HandlerData, List<Element>> handlers, GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>[] globalValidations) {
        for (Map.Entry<HandlerData, List<Element>> handlerWithElements : handlers.entrySet()) {
            HandlerData handlerData = handlerWithElements.getKey();
            HashSet disabledGlobalActionHandlerValidatorClasses = null;
            if (handlerData.getBypassedGlobalActionHandlerValidatorClasses() != null) {
                disabledGlobalActionHandlerValidatorClasses = new HashSet(handlerData.getBypassedGlobalActionHandlerValidatorClasses());
            }
            for (Element el : handlerWithElements.getValue()) {
                for (GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER> gValidation : globalValidations) {
                    if (disabledGlobalActionHandlerValidatorClasses != null && disabledGlobalActionHandlerValidatorClasses.contains(gValidation.getClass()) || gValidation.isValid(context, el)) continue;
                    return gValidation.createGlobalActionHandler(context, el);
                }
            }
        }
        return null;
    }

    private static class HandlerLoadingInfo {
        private String handlerClassName;
        private String extensionId;
        private String[] bypassedGlobalActionHandlerValidatorClasses;

        protected HandlerLoadingInfo(String handlerClassName, String[] bypassedGlobalActionHandlerValidatorClasses, String extensionId) {
            this.handlerClassName = handlerClassName;
            this.extensionId = extensionId;
            this.bypassedGlobalActionHandlerValidatorClasses = bypassedGlobalActionHandlerValidatorClasses;
        }

        protected String getHandlerClassName() {
            return this.handlerClassName;
        }

        protected String getExtensionId() {
            return this.extensionId;
        }

        protected String[] getBypassedGlobalActionHandlerValidatorClasses() {
            return this.bypassedGlobalActionHandlerValidatorClasses;
        }
    }

    final class HandlerData {
        private final Class<? extends CONCRETE_ACTION_HANDLER> actionHandlerClass;
        private final List<Class<? extends GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>>> bypassedGlobalActionHandlerValidatorClasses;

        HandlerData(Class<? extends CONCRETE_ACTION_HANDLER> actionHandlerClass, List<Class<? extends GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>>> bypassedGlobalActionHandlerValidatorClasses) {
            this.actionHandlerClass = actionHandlerClass;
            this.bypassedGlobalActionHandlerValidatorClasses = bypassedGlobalActionHandlerValidatorClasses;
        }

        Class<? extends CONCRETE_ACTION_HANDLER> getActionHandlerClass() {
            return this.actionHandlerClass;
        }

        List<Class<? extends GlobalActionHandlerValidator<CONCRETE_ACTION_HANDLER>>> getBypassedGlobalActionHandlerValidatorClasses() {
            return this.bypassedGlobalActionHandlerValidatorClasses;
        }
    }
}

