/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLNode;
import oracle.ide.resource.NetArb;
import oracle.ide.util.Assert;
import oracle.javatools.ui.KeyNavigationManager;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;

final class FileTable
extends GenericTable
implements FocusListener {
    private final FileTableModel _model = new FileTableModel();
    private final KeyNavigationManager _knm = new KeyNavigationManager();
    private TableColumn[] columns;
    private boolean columnsSized;
    private URLChooser _urlChooser;
    private static final String[] FILE_TABLE_COLUMN_NAMES = new String[]{NetArb.getString((int)26), NetArb.getString((int)27), NetArb.getString((int)28)};
    private static final KeyStroke TABLE_DESCEND_KEYSTROKE = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke TABLE_ASCEND_KEYSTROKE = KeyStroke.getKeyStroke(8, 0);
    private static final KeyStroke[] TABLE_SELECT_CURRENT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(32, 0), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0), KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)};
    private static final KeyStroke TABLE_TOGGLE_SELECT_KEYSTROKE = KeyStroke.getKeyStroke(32, 2);
    private static final Color INACTIVE_BACKGROUND_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
    private static final Color INACTIVE_TEXT_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
    private static final NumberFormat NUMBER_FORMATTER = NumberFormat.getNumberInstance();
    private static final DateFormat DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3);

    public FileTable(URLChooser urlChooser) {
        super(null);
        this.setColumnSelectorAvailable(this._model.isDetailsView());
        this._urlChooser = urlChooser;
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        this._knm.setKeyComponentAdapter((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TableKeyAdapter((JTable)((Object)this)));
        this.addFocusListener(this);
        this.setModel((TableModel)((Object)this._model));
        this.setSorted(true);
        this.setDefaultRenderer(URLNode.class, (TableCellRenderer)((Object)new URLNodeCellRenderer()));
        this.setDefaultRenderer(FileSize.class, (TableCellRenderer)((Object)new InactiveCellRenderer()));
        this.setDefaultRenderer(FileDate.class, (TableCellRenderer)((Object)new InactiveCellRenderer()));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        URLChooser.addKeyboardAction((JComponent)((Object)this), (Action)new TableDescendDirectoryAction(), "table-descend-into-child", TABLE_DESCEND_KEYSTROKE);
        URLChooser.addKeyboardAction((JComponent)((Object)this), (Action)new TableAscendDirectoryAction(), "table-ascend-to-parent", TABLE_ASCEND_KEYSTROKE);
        URLChooser.addKeyboardAction((JComponent)((Object)this), (Action)new TableSelectCurrentAction(), "table-select-current", TABLE_SELECT_CURRENT_KEYSTROKES);
        URLChooser.addKeyboardAction((JComponent)((Object)this), (Action)new TableToggleSelectAction(), "table-toggle-selection", TABLE_TOGGLE_SELECT_KEYSTROKE);
    }

    public void setDetailsView(boolean detailsView) {
        this._model.setDetailsView(detailsView);
        this.setAutoResizeMode(2);
        if (!detailsView) {
            this.removeDetailColumns();
        } else {
            this.addDetailColumns();
        }
    }

    public boolean isDetailsView() {
        return this._model.isDetailsView();
    }

    public void updateSelectedFile(String filename) {
        int row = this._model.findNode(filename);
        if (row >= 0) {
            this.selectRow(row);
        } else {
            this.resetSelection();
        }
    }

    public void resetSelection() {
        if (this.getModel().getRowCount() > 0) {
            this.selectRow(0);
            this.removeRowSelectionInterval(0, 0);
        }
    }

    public void clearList() {
        this._model.setData(new URLNode[0]);
    }

    public void updateList(URLNode node, URLFilter filter) {
        if (node == null) {
            this.clearList();
        } else {
            int dirMode = !this._urlChooser.isForceUseList() && this._urlChooser.getSelectionScope() == 1 ? 0 : (this._urlChooser.getSelectionScope() == 1 ? 3 : 2);
            Vector<URLNode> files = node.getFiles(filter, dirMode);
            URLNode[] children = files.toArray(new URLNode[files.size()]);
            this._model.setData(children);
        }
    }

    public Object[] getSelectedValues() {
        int[] rows = this.getSelectedRows();
        Object[] ret = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int realRow = this.convertRowIndexToModel(rows[i]);
            ret[i] = this.getModel().getValueAt(realRow, 0);
        }
        return ret;
    }

    public URLNode getSelectedNode() {
        int row = this.getSelectedRow();
        return row >= 0 ? (URLNode)this.getModel().getValueAt(this.convertRowIndexToModel(row), 0) : null;
    }

    public URLNode getNodeAt(Point p) {
        int col = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        return col >= 0 && row >= 0 ? (URLNode)this.getModel().getValueAt(this.convertRowIndexToModel(row), 0) : null;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isDetailsView()) {
            ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
            int anchorColumn = columnSelectionModel.getAnchorSelectionIndex();
            int leadColumn = columnSelectionModel.getLeadSelectionIndex();
            int urlnodeColumn = this.convertColumnIndexToView(0);
            if (leadColumn != -1 && leadColumn != urlnodeColumn || anchorColumn != -1 && anchorColumn != urlnodeColumn) {
                this.changeSelection(this.getSelectionModel().getAnchorSelectionIndex(), urlnodeColumn, false, false);
            }
        }
        this.repaintSelectedRows();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaintSelectedRows();
    }

    public void doLayout() {
        if (!this.columnsSized && this.isDetailsView()) {
            this.initColumnSizes();
            this.columnsSized = true;
        }
        super.doLayout();
    }

    @Deprecated
    public boolean isManagingFocus() {
        return false;
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(e);
        }
        super.processKeyEvent(e);
        if (this._knm != null) {
            this._knm.postProcessKeyEvent(e);
        }
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.updateColumnHeader();
    }

    protected void updateColumnHeader() {
        Container gp;
        this.setColumnSelectorAvailable(this.isDetailsView());
        this.getTableHeader().setVisible(this.isDetailsView());
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            scrollPane.setColumnHeaderView(this.isDetailsView() ? this.getTableHeader() : null);
        }
    }

    private void repaintSelectedRows() {
        this.repaint();
    }

    private void selectRow(int row) {
        this.changeSelection(row, 0, false, false);
    }

    private void removeDetailColumns() {
        if (this.columns == null) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            this.columns = new TableColumn[columnCount];
            int urlNodeIndex = this.convertColumnIndexToView(0);
            int i = columnCount;
            while (--i >= 0) {
                if (i != urlNodeIndex) {
                    TableColumn column;
                    this.columns[i] = column = columnModel.getColumn(i);
                    columnModel.removeColumn(column);
                    continue;
                }
                this.columns[i] = null;
            }
        }
    }

    private void addDetailColumns() {
        if (this.columns != null) {
            TableColumnModel columnModel = this.getColumnModel();
            TableColumn urlNodeColumn = columnModel.getColumn(0);
            for (int i = 0; i < this.columns.length; ++i) {
                TableColumn column = this.columns[i];
                if (column != null) {
                    columnModel.addColumn(column);
                    continue;
                }
                columnModel.removeColumn(urlNodeColumn);
                columnModel.addColumn(urlNodeColumn);
            }
            this.columns = null;
        }
    }

    private void initColumnSizes() {
        TableColumnModel columnModel = this.getColumnModel();
        int nrows = this.getRowCount();
        int ncols = columnModel.getColumnCount();
        int totalwidth = 0;
        for (int col = 0; col < ncols; ++col) {
            TableColumn column = columnModel.getColumn(col);
            Component comp = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, -1, col);
            int width = comp.getPreferredSize().width;
            Class columnClass = this.getColumnClass(col);
            for (int row = 0; row < nrows; ++row) {
                comp = this.getDefaultRenderer(columnClass).getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, col), false, false, row, col);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
            totalwidth += width;
        }
        int width = this.getParent().getWidth();
        this.setSize(width, this.getHeight());
        if (width > totalwidth) {
            int extrawidth = width - totalwidth;
            TableColumn column = columnModel.getColumn(0);
            int columnWidth = column.getPreferredWidth();
            int extra = extrawidth * 6 / 10;
            extrawidth -= extra;
            column.setPreferredWidth(columnWidth + extra);
            column = columnModel.getColumn(1);
            columnWidth = column.getPreferredWidth();
            extra = extrawidth / 2;
            extrawidth -= extra;
            column.setPreferredWidth(columnWidth + extra);
            column = columnModel.getColumn(2);
            columnWidth = column.getPreferredWidth();
            extra = extrawidth;
            extrawidth -= extra;
            column.setPreferredWidth(columnWidth + extra);
        }
        this.resizeAndRepaint();
    }

    private static final class FileTableModel
    extends GenericBaseTableModel {
        private static final int URLNODE_COLUMN = 0;
        private static final int SIZE_COLUMN = 1;
        private static final int DATE_MODIFIED_COLUMN = 2;
        private URLNode[] _data;
        private static boolean _detailsView;

        public void setDetailsView(boolean detailsView) {
            _detailsView = detailsView;
        }

        public boolean isDetailsView() {
            return _detailsView;
        }

        public void setData(URLNode[] data) {
            Assert.precondition((data != null ? 1 : 0) != 0);
            this._data = data;
            this.fireTableDataChanged();
        }

        public int findNode(String filename) {
            if (filename != null && filename.length() != 0 && this._data != null) {
                for (int i = 0; i < this._data.length; ++i) {
                    URLNode node = this._data[i];
                    if (URLChooser.compare(node.toString(), filename) != 0) continue;
                    return i;
                }
            }
            return -1;
        }

        public int getColumnAlignment(int col) {
            switch (col) {
                case 1: {
                    return 4;
                }
            }
            return 2;
        }

        public Comparator getColumnSortComparator(int col) {
            return null;
        }

        public int getColumnCount() {
            return FILE_TABLE_COLUMN_NAMES.length;
        }

        public String getColumnName(int col) {
            return FILE_TABLE_COLUMN_NAMES[col];
        }

        public int getRowCount() {
            return this._data != null ? this._data.length : 0;
        }

        public Object getValueAt(int row, int col) {
            if (this._data == null || row < 0 || row >= this._data.length) {
                return null;
            }
            URLNode node = this._data[row];
            switch (col) {
                case 0: {
                    return node;
                }
                case 1: {
                    return new FileSize(node);
                }
                case 2: {
                    return new FileDate(node);
                }
            }
            return null;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return URLNode.class;
                }
                case 1: {
                    return FileSize.class;
                }
                case 2: {
                    return FileDate.class;
                }
            }
            return null;
        }
    }

    private final class URLNodeCellRenderer
    extends InactiveCellRenderer {
        private URLNodeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            DefaultTableCellRenderer baseRenderer = (DefaultTableCellRenderer)this.getBaseRenderer();
            URLChooser.setLabelIcon(baseRenderer, value, true);
            URLChooser.setLabelFont(baseRenderer, value, table.getFont());
            FileTable.this.setEnabled(table.isEnabled());
            baseRenderer.setText(value == null ? "" : value.toString());
            return c;
        }
    }

    private static final class FileSize
    implements Comparable {
        private final URLNode node;

        public FileSize(URLNode node) {
            this.node = node;
        }

        public String toString() {
            if (!this.isLeaf()) {
                return "";
            }
            return NetArb.format((int)29, (Object)NUMBER_FORMATTER.format(this.getKbSize()));
        }

        public int compareTo(Object o) {
            long otherSize;
            FileSize other = (FileSize)o;
            if (this.isLeaf() != other.isLeaf()) {
                return this.isLeaf() ? 1 : -1;
            }
            long size = this.getSize();
            if (size != (otherSize = other.getSize())) {
                return size > otherSize ? 1 : -1;
            }
            return this.node.compareTo(other.node);
        }

        boolean isLeaf() {
            return this.node.isLeaf();
        }

        long getSize() {
            return this.isLeaf() ? this.node.length() : 0L;
        }

        long getKbSize() {
            long size = this.getSize();
            if (size <= 0L) {
                return 0L;
            }
            long kb = (size + 512L) / 1024L;
            return kb > 0L ? kb : 1L;
        }
    }

    private class InactiveCellRenderer
    extends GenericTableCellRenderer {
        private InactiveCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                if (table.hasFocus()) {
                    c.setBackground(table.getSelectionBackground());
                    c.setForeground(table.getSelectionForeground());
                } else {
                    c.setBackground(INACTIVE_BACKGROUND_SELECTION_COLOR);
                    c.setForeground(INACTIVE_TEXT_SELECTION_COLOR);
                }
            }
            return c;
        }
    }

    private static final class FileDate
    implements Comparable {
        private final URLNode node;

        public FileDate(URLNode node) {
            this.node = node;
        }

        public String toString() {
            return DATE_FORMATTER.format(this.getDate());
        }

        public int compareTo(Object o) {
            long otherDate;
            FileDate other = (FileDate)o;
            if (this.isLeaf() != other.isLeaf()) {
                return this.isLeaf() ? 1 : -1;
            }
            long date = this.lastModified();
            if (date != (otherDate = other.lastModified())) {
                return date > otherDate ? 1 : -1;
            }
            return this.node.compareTo(other.node);
        }

        boolean isLeaf() {
            return this.node.isLeaf();
        }

        long lastModified() {
            return this.node.lastModified();
        }

        Date getDate() {
            return new Date(this.lastModified());
        }
    }

    private class TableDescendDirectoryAction
    extends AbstractAction {
        public static final String KEY = "table-descend-into-child";

        private TableDescendDirectoryAction() {
        }

        @Override
        public boolean isEnabled() {
            if (!FileTable.this.isEnabled()) {
                return false;
            }
            URL fileURL = FileTable.this._urlChooser.getSelectedURL();
            return fileURL != null && URLFileSystem.isDirectoryPath((URL)fileURL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTable.this._urlChooser.setSelectedURL(FileTable.this._urlChooser.getSelectedURL());
        }
    }

    private class TableAscendDirectoryAction
    extends AbstractAction {
        public static final String KEY = "table-ascend-to-parent";

        private TableAscendDirectoryAction() {
        }

        @Override
        public boolean isEnabled() {
            return FileTable.this.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTable.this._urlChooser.runNow(1);
        }
    }

    private final class TableSelectCurrentAction
    extends TableSelectAction {
        public static final String KEY = "table-select-current";

        private TableSelectCurrentAction() {
        }

        @Override
        protected int getDelta() {
            return 0;
        }
    }

    private final class TableToggleSelectAction
    extends TableSelectAction {
        public static final String KEY = "table-toggle-selection";

        private TableToggleSelectAction() {
        }

        @Override
        protected int getDelta() {
            return 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            if (table.getSelectionModel().isSelectionEmpty()) {
                super.actionPerformed(e);
            } else {
                FileTable.this.clearSelection();
            }
        }
    }

    private abstract class TableSelectAction
    extends AbstractAction {
        private TableSelectAction() {
        }

        protected abstract int getDelta();

        @Override
        public boolean isEnabled() {
            return FileTable.this.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            int index = this.getIndexForSelection(table);
            if (index >= 0 && index < table.getModel().getRowCount()) {
                table.changeSelection(index, -1, false, false);
            }
        }

        protected int getIndexForSelection(JTable table) {
            int size = table.getModel().getRowCount();
            int delta = this.getDelta();
            int index = table.getSelectionModel().getAnchorSelectionIndex();
            if (index == -1) {
                if (size > 0) {
                    index = delta >= 0 ? 0 : size - 1;
                }
            } else if ((index += delta) < 0) {
                index = 0;
            } else if (index >= size) {
                index = size - 1;
            }
            return index;
        }
    }
}

