/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.LayerUI;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.internal.UICUtils;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.SwingUtils;

final class ReadOnlyComponent {
    private static final Font textFont = UIManager.getFont("Label.font");
    private static final Color blockedColor = new Color(204, 204, 204, 128);
    private static final Color bgColor = new Color(255, 255, 255);
    private static final Color textColor = new Color(10, 10, 60);
    private static final int ICON_TEXT_GAP = 6;
    private static final int LEFT_RIGHT_GAP = 6;
    private static final int TOP_BOTTOM_GAP = 6;
    private static final int SHADOW_DEPTH = 5;
    private static final Icon PREVIEW_ICON = OracleIcons.getIcon((String)"info.png");
    private volatile State _state = State.READ_WRITE;
    private String _message = "";
    private Icon _icon;
    private Component _previewComponent;
    private JLayer _layer;
    private LayeredPanel _readOnlyPanel;
    private List<PropertyChangeListener> pcls = new CopyOnWriteArrayList<PropertyChangeListener>();
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_MESSAGE = "message";

    public ReadOnlyComponent(JComponent componentToBlock) {
        this._layer = new JLayer<JComponent>(componentToBlock, new ReadOnlyLayerUI());
        this._layer.setName("read-only layer");
        this._readOnlyPanel = new LayeredPanel(this._layer);
    }

    public JComponent getReadOnlyComponent() {
        return this._readOnlyPanel;
    }

    public void setState(State state) {
        if (this._state == state) {
            return;
        }
        State oldState = this._state;
        this._state = state;
        switch (state) {
            case READ_WRITE: {
                this._layer.getGlassPane().setCursor(Cursor.getDefaultCursor());
                break;
            }
            default: {
                this._layer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this._readOnlyPanel.configureFromState(state);
        this._layer.repaint();
        PropertyChangeEvent event = new PropertyChangeEvent(this, PROPERTY_STATE, (Object)oldState, (Object)state);
        for (PropertyChangeListener l : this.pcls) {
            l.propertyChange(event);
        }
    }

    public void setIcon(Icon icon) {
        if (this._icon == icon) {
            return;
        }
        Icon oldIcon = this._icon;
        this._icon = icon;
        this._layer.repaint();
        PropertyChangeEvent event = new PropertyChangeEvent(this, PROPERTY_ICON, oldIcon, icon);
        for (PropertyChangeListener l : this.pcls) {
            l.propertyChange(event);
        }
    }

    public void setMessage(String message) {
        if (message == this._message) {
            return;
        }
        String oldMessage = this._message;
        this._message = message;
        this._layer.repaint();
        PropertyChangeEvent event = new PropertyChangeEvent(this, PROPERTY_MESSAGE, oldMessage, message);
        for (PropertyChangeListener l : this.pcls) {
            l.propertyChange(event);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public State getState() {
        return this._state;
    }

    public void setPreviewComponent(Component previewComp) {
        this._previewComponent = previewComp;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (!this.pcls.contains(pcl)) {
            this.pcls.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcls.remove(pcl);
    }

    private void showDialog(JComponent parent, Point point) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)parent);
        final JEWTDialog dlg = new JEWTDialog(dialog, "Details", 16);
        dlg.setName("more info dialog");
        dlg.setUndecorated(true);
        dlg.setResizable(true);
        dlg.setModal(true);
        dlg.setContent(this._previewComponent);
        dlg.pack();
        dlg.setLocation(point);
        dlg.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                dlg.dispose();
                ReadOnlyComponent.this._layer.repaint();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("nogrid, fill"));
        final JComboBox<State> states = new JComboBox<State>(State.values());
        panel.add(states, "growx 0");
        panel.setOpaque(false);
        final JPanel readOnlyContent = new JPanel((LayoutManager)new MigLayout("nogrid, fill"));
        readOnlyContent.setOpaque(false);
        readOnlyContent.add(new JTree());
        JButton button = new JButton("Press Me");
        button.setMnemonic('P');
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(readOnlyContent, "Button Pressed");
            }
        });
        readOnlyContent.add(button);
        readOnlyContent.add((Component)new JTextArea("This whole panel can be blocked by switching\nthe combo box.\n\nComponents outside the panel are unaffected."), "newline");
        readOnlyContent.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        final ReadOnlyComponent readOnlyComponent = new ReadOnlyComponent(readOnlyContent);
        readOnlyComponent.setMessage("Set by Maven");
        readOnlyComponent.setPreviewComponent(ReadOnlyComponent.testPanel());
        panel.add((Component)readOnlyComponent.getReadOnlyComponent(), "newline");
        panel.add((Component)new JButton("I do not get blocked"), "newline");
        states.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                readOnlyComponent.setState((State)((Object)states.getSelectedItem()));
            }
        });
        panel.setPreferredSize(new Dimension(400, 300));
        UICUtils.runComponent((JComponent)panel);
    }

    private static JPanel testPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 6));
        final RichHintLabel prompt = new RichHintLabel();
        prompt.setHtmlText("These settings are controlled by the project's Maven POM file:<br><a href=\"http:help\">../projectName/src/POM.xml.");
        prompt.registerAction("help", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDialog.information((Component)prompt, (Object)"should open POM file", (String)"Open POM.xml", null);
            }
        });
        panel.add((Component)prompt, "North");
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)new JLabel("Source Paths:"), "North");
        JList<String> ta = new JList<String>(new String[]{"source path 1", "source path 2", "source path 3"});
        ta.setSelectedIndex(0);
        subPanel.add((Component)new JScrollPane(ta), "Center");
        panel.add((Component)subPanel, "Center");
        return panel;
    }

    public static enum State {
        READ_WRITE,
        READ_ONLY,
        READ_ONLY_EX;

    }

    private class ReadOnlyLayerUI
    extends LayerUI<JComponent> {
        private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);

        private ReadOnlyLayerUI() {
        }

        @Override
        public void installUI(JComponent component) {
            super.installUI(component);
            ((JLayer)component).setLayerEventMask(56L);
        }

        @Override
        public void uninstallUI(JComponent component) {
            assert (component == ReadOnlyComponent.this._layer);
            ReadOnlyComponent.this._layer.setLayerEventMask(0L);
            ReadOnlyComponent.this._layer.getGlassPane().setCursor(Cursor.getDefaultCursor());
            super.uninstallUI(component);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            if (ReadOnlyComponent.this._state == State.READ_WRITE) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setColor(blockedColor);
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            String text = ReadOnlyComponent.this._message != null ? ReadOnlyComponent.this._message.trim() : "Read-only";
            FontMetrics fm = g2.getFontMetrics(textFont);
            int leftIconWidth = ReadOnlyComponent.this.getIcon() != null ? ReadOnlyComponent.this.getIcon().getIconWidth() : 0;
            int leftIconHeight = ReadOnlyComponent.this.getIcon() != null ? ReadOnlyComponent.this.getIcon().getIconHeight() : 0;
            int leftOffset = 6 + (leftIconWidth == 0 ? 0 : leftIconWidth + 6);
            int rightOffset = ReadOnlyComponent.this._state == State.READ_ONLY_EX ? 12 + ReadOnlyComponent.this._readOnlyPanel.buttonWidth() : 6;
            int w = leftOffset + fm.stringWidth(text) + rightOffset;
            int h = 6 + Math.max(fm.getHeight(), leftIconHeight) + 6;
            int x = c.getWidth() / 2 - w / 2;
            int y = c.getHeight() / 2 - h / 2;
            g2.setColor(bgColor);
            g2.fillRect(x, y, w, h);
            this.paintShadow(g2, new Rectangle(x, y, w, h));
            x += 6;
            if (ReadOnlyComponent.this.getIcon() != null) {
                ReadOnlyComponent.this.getIcon().paintIcon(c, g2, x, c.getHeight() / 2 - leftIconHeight / 2);
                x += leftIconWidth + 6;
            }
            g2.setColor(textColor);
            g2.setFont(textFont);
            g2.drawString(text, x, c.getHeight() / 2 - fm.getHeight() / 2 + fm.getAscent());
            if (ReadOnlyComponent.this._state == State.READ_ONLY_EX) {
                y = c.getHeight() / 2 - ReadOnlyComponent.this._readOnlyPanel.buttonHeight() / 2;
                ReadOnlyComponent.this._readOnlyPanel.positionButton(new Point(x += fm.stringWidth(text) + 6, y));
            }
        }

        private void paintShadow(Graphics2D g2, Rectangle r) {
            Area clipArea = new Area(new Rectangle(0, 0, ReadOnlyComponent.this._layer.getWidth(), ReadOnlyComponent.this._layer.getHeight()));
            clipArea.subtract(new Area(r));
            r.x -= 2;
            r.y -= 2;
            r.width += 5;
            r.height += 5;
            Object[] cacheImage = this.getCachedImage(this.shadowImageRef, r.width + 10, r.height + 10);
            int elementCount = 25;
            float i = 1.0f / (float)elementCount;
            float[] elements = new float[elementCount];
            for (int n = 0; n < elementCount; ++n) {
                elements[n] = i;
            }
            Kernel myKernel = new Kernel(5, 5, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            BufferedImage shadowImage = (BufferedImage)cacheImage[0];
            this.shadowImageRef = (SoftReference)cacheImage[1];
            Graphics2D shadowG = shadowImage.createGraphics();
            shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            shadowG.setColor(new Color(0, 0, 0, 114));
            shadowG.translate(-r.x + 5, -r.y + 5);
            shadowG.fill(r);
            shadowG.translate(r.x - 5, r.y - 5);
            Graphics2D tempG = (Graphics2D)g2.create();
            tempG.setComposite(AlphaComposite.getInstance(3, 0.5f));
            tempG.setClip(clipArea);
            tempG.drawImage(shadowImage, simpleBlur, r.x - 5, r.y - 5);
            tempG.dispose();
            shadowG.dispose();
        }

        private Object[] getCachedImage(SoftReference<BufferedImage> imageRef, int width, int height) {
            BufferedImage image = imageRef.get();
            if (image != null && (image.getWidth() != width || image.getHeight() != height)) {
                image = null;
            }
            Object[] ret = new Object[2];
            ret[1] = imageRef;
            if (image == null) {
                image = new BufferedImage(width, height, 2);
                ret[1] = new SoftReference<BufferedImage>(image);
            } else {
                Graphics2D g2D = image.createGraphics();
                g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
                g2D.fill(rect);
            }
            ret[0] = image;
            return ret;
        }

        @Override
        public void eventDispatched(AWTEvent e, JLayer<? extends JComponent> layer) {
            if (ReadOnlyComponent.this._state != State.READ_WRITE) {
                if (e instanceof InputEvent) {
                    ((InputEvent)e).consume();
                }
                return;
            }
            super.eventDispatched(e, layer);
        }
    }

    private class LayeredPanel
    extends JPanel {
        private final JButton _button;
        private final JComponent _comp;
        private ActionMap _noOpActionMap = new ActionMap();

        public LayeredPanel(JComponent comp) {
            this.setName("read-only layer");
            this._comp = comp;
            JPanel buttonPanel = new JPanel();
            buttonPanel.setName("button panel layer");
            this._button = new JButton(PREVIEW_ICON);
            this._button.setToolTipText("More...");
            IconicButtonUI.install((AbstractButton)this._button);
            this._button.setVisible(false);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Point locationOnScreen = LayeredPanel.this._button.getLocationOnScreen();
                    locationOnScreen.translate(LayeredPanel.this._button.getWidth(), LayeredPanel.this._button.getHeight());
                    ReadOnlyComponent.this.showDialog(LayeredPanel.this, locationOnScreen);
                }
            });
            buttonPanel.setLayout(null);
            buttonPanel.setOpaque(false);
            buttonPanel.add(this._button);
            this._button.setBounds(0, 0, this.buttonWidth(), this.buttonHeight());
            JLayeredPane layeredPane = new JLayeredPane();
            layeredPane.setName("host layered pane");
            layeredPane.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            layeredPane.add((Component)buttonPanel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            layeredPane.add((Component)comp, constraints);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(layeredPane));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(layeredPane, GroupLayout.Alignment.TRAILING));
        }

        void positionButton(Point point) {
            this._button.setLocation(point);
        }

        void configureFromState(State state) {
            switch (state) {
                case READ_ONLY_EX: {
                    this._button.setVisible(true);
                    this.deactivateAndDisableFocus();
                    break;
                }
                case READ_ONLY: {
                    this._button.setVisible(false);
                    this.deactivateAndDisableFocus();
                    break;
                }
                case READ_WRITE: {
                    this._button.setVisible(false);
                }
            }
        }

        int buttonWidth() {
            return PREVIEW_ICON.getIconWidth() + this._button.getIconTextGap();
        }

        int buttonHeight() {
            return PREVIEW_ICON.getIconHeight() + this._button.getIconTextGap();
        }

        private void deactivateAndDisableFocus() {
            String key = "ReadOnlyComponent.disable.focus.property";
            if (this._comp.getClientProperty("ReadOnlyComponent.disable.focus.property") == null) {
                this.deactivateAndDisableFocus(this._comp);
                this._comp.putClientProperty("ReadOnlyComponent.disable.focus.property", Boolean.TRUE);
            }
        }

        private void deactivateAndDisableFocus(Component component) {
            component.setFocusable(false);
            if (component instanceof JComponent) {
                ((JComponent)component).setActionMap(this._noOpActionMap);
            }
            if (component instanceof Container) {
                Component[] children;
                for (Component child : children = ((Container)component).getComponents()) {
                    this.deactivateAndDisableFocus(child);
                }
            }
        }
    }
}

