/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLRecognizer;

public class XMLDataNode
extends Node {
    static final String ROOT_ELEMENT_NAME = "XMLDataNode";
    private DataCastPacket _data;
    private final Observer _observer = new DataObserver();
    private NodeInfo _nodeInfo;
    private Attributes _attrs;

    public XMLDataNode() {
    }

    public XMLDataNode(Object dataObject, URL url) {
        super(url);
        this.setData(dataObject, true);
    }

    @Override
    public void setURL(URL url) {
        super.setURL(url);
        if (this._nodeInfo != null) {
            return;
        }
        Class<? extends Node> dataClass = Recognizer.recognizeURL(this.getURL());
        if (dataClass != null) {
            this._nodeInfo = XMLRecognizer.findNodeInfo(dataClass);
            if (this._nodeInfo == null) {
                this._attrs = null;
            }
        }
    }

    @Override
    public Icon getIcon() {
        Icon icon;
        if (this._nodeInfo != null && (icon = this._nodeInfo.getIcon()) != null) {
            return icon;
        }
        return super.getIcon();
    }

    @Override
    public String getToolTipText() {
        DataCastPacket data = this.getDataCastPacketDirectly();
        if (data.element != null) {
            String toolTip = data.element.getToolTipText();
            if (toolTip == null) {
                return null;
            }
            if (toolTip.length() > 0) {
                return toolTip;
            }
        }
        return super.getToolTipText();
    }

    @Override
    public Object getData() {
        try {
            this.open();
            return this.getDataCastPacketDirectly().object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean mayHaveChildren() {
        DataCastPacket data = this.getDataCastPacketDirectly();
        if (data.element != null) {
            return data.element.mayHaveChildren();
        }
        return super.mayHaveChildren();
    }

    @Override
    public Iterator getChildren() {
        try {
            this.open();
            DataCastPacket data = this.getDataCastPacketDirectly();
            if (data.element != null) {
                return data.element.getChildren();
            }
            return super.getChildren();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Attributes getAttributes() {
        if (this._nodeInfo != null) {
            if (this._attrs == null) {
                this._attrs = this._nodeInfo.getAttributes();
            }
            return this._attrs;
        }
        DataCastPacket data = this.getDataCastPacketDirectly();
        if (data.element != null) {
            return data.element.getAttributes();
        }
        return super.getAttributes();
    }

    @Override
    public void markDirty(boolean dirty) {
        DataCastPacket data;
        if (!dirty && (data = this.getDataCastPacketDirectly()) != null && data.dirtyable != null) {
            data.dirtyable.markDirty(dirty);
        }
        super.markDirty(dirty);
    }

    @Override
    protected void openImpl() throws IOException {
        URL url = this.getURL();
        if (URLFileSystem.exists((URL)url)) {
            Object2Dom o2d = this.newObject2Dom();
            Class defaultClass = this.getDefaultClass();
            ClassLoader o2dCL = defaultClass != null ? defaultClass.getClassLoader() : this.getClass().getClassLoader();
            Object object = o2d.toObject(url, defaultClass, o2dCL);
            this.setData(object, false);
        } else if (this._nodeInfo != null) {
            try {
                Object object = this._nodeInfo.getDataClass().newInstance();
                this.setData(object, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void closeImpl() throws IOException {
        this.setDataCastPacketDirectly(null);
    }

    @Override
    protected void saveImpl() throws IOException {
        Object2Dom o2d = this.newObject2Dom();
        if (this._nodeInfo != null) {
            o2d.setNamespaceURI(this._nodeInfo.getXMLNamespaceURI());
        }
        Object object = this.getDataCastPacketDirectly().object;
        String xmlRootElementName = this.getXMLRootElementName();
        Class defaultClass = this.getDefaultClass();
        URL url = this.getURL();
        o2d.toDocument(object, xmlRootElementName, defaultClass, url);
    }

    public void setNodeInfo(NodeInfo info) {
        this._nodeInfo = info;
        if (this._nodeInfo == null) {
            this._attrs = null;
        }
    }

    public void setData(Object object, boolean dirty) {
        DataCastPacket data = this.getDataCastPacketDirectly();
        if (data.object instanceof Subject) {
            ((Subject)data.object).detach(this._observer);
        }
        if (data.object instanceof SubDirtyable) {
            ((SubDirtyable)data.object).setOwner(null);
        }
        if (object instanceof Subject) {
            ((Subject)object).attach(this._observer);
        }
        if (object instanceof SubDirtyable) {
            ((SubDirtyable)object).setOwner((Dirtyable)this);
        }
        DataCastPacket newData = new DataCastPacket(object);
        this.setDataCastPacketDirectly(newData);
        this.setOpen(true);
        this.markDirty(dirty);
    }

    protected DataCastPacket getDataCastPacketDirectly() {
        if (this._data == null) {
            this._data = new DataCastPacket(null);
        }
        return this._data;
    }

    protected void setDataCastPacketDirectly(DataCastPacket data) {
        this._data = data;
    }

    protected String getXMLRootElementName() {
        if (this._nodeInfo == null) {
            return ROOT_ELEMENT_NAME;
        }
        return this._nodeInfo.getXMLRootElement();
    }

    protected Object2Dom newObject2Dom() {
        return Object2Dom.newInstance();
    }

    protected Class getDefaultClass() {
        return null;
    }

    private class DataObserver
    implements Observer {
        private DataObserver() {
        }

        @Override
        public void update(Object observed, UpdateMessage change) {
            XMLDataNode.this.notifyObservers(XMLDataNode.this, change.forNewOrigin(XMLDataNode.this));
        }
    }

    protected static final class DataCastPacket {
        public final Object object;
        public final Element element;
        public final Dirtyable dirtyable;
        public final Folder folder;

        public DataCastPacket(Object obj) {
            this.object = obj;
            this.element = obj instanceof Element ? (Element)obj : null;
            this.folder = obj instanceof Folder ? (Folder)obj : null;
            this.dirtyable = obj instanceof Dirtyable ? (Dirtyable)obj : null;
        }
    }
}

