/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.javatools.data.HashStructure;

class ProtocolRecognizerHookHelper {
    static Map<String, MetaClass<Node>> findProtocolMappings(HashStructure hs) {
        return Collections.unmodifiableMap(ProtocolRecognizerHookHelper.buildProtocolMappings(hs));
    }

    private static Map<String, MetaClass<Node>> buildProtocolMappings(HashStructure hs) {
        HashMap<String, MetaClass<Node>> mappings = new HashMap<String, MetaClass<Node>>();
        List urlRecognizers = hs.getAsList("url-recognizer");
        if (urlRecognizers == null) {
            return mappings;
        }
        for (Object o : urlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            ProtocolRecognizerHookHelper.addProtocolMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addProtocolMapping(HashStructure hs, Map<String, MetaClass<Node>> mappings) {
        List protocols = hs.getAsList("protocol");
        if (protocols == null) {
            return;
        }
        for (Object o : protocols) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String protocol = childHs.getString("protocol/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            mappings.put(protocol, metaClass);
        }
    }

    private ProtocolRecognizerHookHelper() {
    }
}

