/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.ContentSetProvidersHook;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NonAutoSelectable;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

public final class ProjectContent
extends HashStructureAdapter {
    boolean _includeSubFolders = false;
    public static final String CONTENT_SETS_PROPERTY = "contentProvidersPath";
    private static final CopyOnWriteArrayList<ContentSetProvider> _contentSetProviders;
    private static final L _projectChangeListener;
    private static HashSet _contentSetKeysForDisplayFoldersAsPackages;
    private static final ExecutorService VFS_REMOVAL_SCHEDULER;
    private static final Logger LOG;
    public static final String AUTO_SELECTOR_CONTEXT_KEY = "oracle.ide.model.ProjectContent.AutoSelecter";

    private ProjectContent(HashStructure hash) {
        super(hash);
    }

    @Deprecated
    public List<String> getMissingContentSetKeys() {
        ArrayList<String> missingContentSets = new ArrayList<String>();
        ContentSetProviderReference[] refs = ProjectContent.getContentSetProviderReferences();
        ListStructure metaList = this.getContentSetList();
        for (ContentSetProviderReference ref : refs) {
            String key = ref.key();
            if (key == null || metaList.contains((Object)key) && (this._hash.keyStatus(key) == 1 || this._hash.getBoolean(".initialized"))) continue;
            missingContentSets.add(key);
        }
        return missingContentSets;
    }

    @Deprecated
    public boolean isMissingContentSetKeys() {
        ContentSetProviderReference[] refs;
        ListStructure metaList = this.getContentSetList();
        for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
            String key = ref.key();
            if (key == null || metaList.contains((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static void initializeContentSets(Project project) {
        ProjectContent.initializeContentSets(project, true);
    }

    static void initializeContentSets(final Project project, final boolean persistent) {
        project.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                ContentSetProviderReference[] refs = ProjectContent.getContentSetProviderReferences();
                HashStructure shared = project.getSharedPropertiesOnly();
                ListStructure metaList = ProjectContent.getInstance(project).getContentSetList();
                URL projectDir = URLFileSystem.getParent((URL)project.getURL());
                Context context = new Context();
                context.setProject(project);
                for (ContentSetProviderReference provider : refs) {
                    String key = provider.key();
                    if (key == null || provider.applicationLevelContent()) continue;
                    int keyStatus = shared.keyStatus(key);
                    HashStructure contentSetHash = null;
                    switch (keyStatus) {
                        case 0: {
                            contentSetHash = HashStructure.newInstance();
                            break;
                        }
                        case 2: {
                            HashStructure existing = shared.getHashStructure(key);
                            if (existing.getBoolean(".initialized")) break;
                            contentSetHash = HashStructure.newInstance();
                            existing.copyTo(contentSetHash);
                        }
                    }
                    if (contentSetHash != null) {
                        ContentSet contentSet = new ContentSet(contentSetHash);
                        provider.initContentSet(contentSet, projectDir, context);
                        contentSetHash.getBoolean(".initialized", true);
                        if (persistent) {
                            shared.putHashStructure(key, contentSetHash);
                        } else {
                            shared.putPlaceholderHashStructure(key, contentSetHash);
                        }
                    }
                    if (metaList.size() == 0) {
                        metaList.add((Object)key);
                        continue;
                    }
                    if (metaList.contains((Object)key)) continue;
                    metaList.addPlaceholder((Object)key);
                }
            }
        });
    }

    public static ProjectContent getInstance(PropertyStorage project) {
        if (project != null) {
            return new ProjectContent(project.getProperties());
        }
        return new ProjectContent(HashStructure.newInstance());
    }

    public static ProjectContent getInstance(HashStructure hash) {
        return new ProjectContent(hash);
    }

    @Deprecated
    public static final void registerContentSetProvider(ContentSetProvider provider) {
        if (provider != null) {
            String key = provider.getKey();
            if (key != null) {
                if (provider.getShortLabel() != null) {
                    for (ContentSetProvider csp : _contentSetProviders) {
                        if (!key.equals(csp.getKey())) continue;
                        System.err.println("**** Warning: Replacing ContentSetProvider '" + key + "'");
                        _contentSetProviders.remove(csp);
                        _contentSetKeysForDisplayFoldersAsPackages.remove(key);
                    }
                    boolean added = _contentSetProviders.addIfAbsent(provider);
                    if (added && provider.displayFoldersAsPackages()) {
                        _contentSetKeysForDisplayFoldersAsPackages.add(key);
                    }
                    Project.addProjectChangeListener(key, _projectChangeListener);
                } else {
                    new IllegalArgumentException("Null ContentSet short label not allowed").printStackTrace();
                }
            } else {
                new IllegalArgumentException("Null ContentSet key not allowed.").printStackTrace();
            }
        }
    }

    public static final void unregisterContentSetProvider(ContentSetProvider provider) {
        if (provider != null) {
            _contentSetProviders.remove(provider);
            Project.removeProjectChangeListener(provider.getKey(), _projectChangeListener);
        }
    }

    @Deprecated
    public static final ContentSetProvider[] getContentSetProviders() {
        return _contentSetProviders.toArray(new ContentSetProvider[_contentSetProviders.size()]);
    }

    public static ContentSetProviderReference[] getContentSetProviderReferences() {
        ContentSetProvidersHook hook = ContentSetProvidersHook.getHook();
        List<ContentSetProviderReference> fromHook = hook.contentSetProviderReferences();
        ArrayList<ContentSetProviderReference> refs = new ArrayList<ContentSetProviderReference>(fromHook.size() + _contentSetProviders.size());
        for (ContentSetProviderReference ref : fromHook) {
            if (ref.applicationLevelContent()) continue;
            ProjectContent.registerDeclarativeContentSetProvider(ref);
            refs.add(ref);
        }
        for (ContentSetProvider p : _contentSetProviders) {
            ContentSetProviderReference ref = new ContentSetProviderReference(p);
            refs.add(ref);
        }
        return refs.toArray(new ContentSetProviderReference[refs.size()]);
    }

    public static final void registerDeclarativeContentSetProvider(ContentSetProviderReference provider) {
        if (provider != null) {
            String key = provider.key();
            if (key != null) {
                if (provider.displayFoldersAsPackages()) {
                    _contentSetKeysForDisplayFoldersAsPackages.add(key);
                }
                Project.addProjectChangeListener(key, _projectChangeListener);
            } else {
                new IllegalArgumentException("Null ContentSet key not allowed.").printStackTrace();
            }
        }
    }

    public ContentSet getContentSet(String contentSetKey) {
        return new ContentSet(this._hash.getOrCreateHashStructure(contentSetKey));
    }

    public final ListStructure getContentSetList() {
        return this._hash.getOrCreateListStructure("contentSets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentSet getAllContents() {
        ContentSet all = new ContentSet(HashStructure.newInstance(), false);
        ListStructure contentSetList = this.getContentSetList();
        ArrayList keys = new ArrayList();
        Object object = contentSetList.iteratorLock();
        synchronized (object) {
            for (Object keyObj : contentSetList) {
                if (keyObj == null) continue;
                keys.add(keyObj);
            }
        }
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            all.addContentSet(this.getContentSet(key));
        }
        return all;
    }

    public final URLPath getJavaRootDirs() {
        URLPath sourcePath = new URLPath();
        ContentSetProviderReference[] refs = ProjectContent.getContentSetProviderReferences();
        if (refs != null) {
            for (ContentSetProviderReference ref : refs) {
                if (!ref.canContainJavaSources()) continue;
                ContentSet cs = this.getContentSet(ref.key());
                sourcePath.add(cs.getAllRootDirs());
            }
        }
        return sourcePath;
    }

    public Iterator getNodeIterator() {
        return this.getAllContents().nodeIterator("");
    }

    public final Iterator findChildren(Class childType) {
        return new ChildTypeIterator(this.getNodeIterator(), childType);
    }

    public final Iterator findChildren(Class[] types) {
        switch (types.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findChildren(types[0]);
            }
        }
        return new MultiChildTypeIterator(this.getNodeIterator(), types);
    }

    public final Iterator findChildren(Class childType, String contentSetKey) {
        ContentSet cs = this.getContentSet(contentSetKey);
        return cs != null ? new ChildTypeIterator(cs.nodeIterator(null), childType) : Collections.EMPTY_LIST.iterator();
    }

    public boolean add(Node node, String contentSetKey) {
        return this.add(new Node[]{node}, contentSetKey);
    }

    public boolean add(Node[] nodes, String contentSetKey) {
        if (nodes.length == 0) {
            return true;
        }
        boolean status = true;
        if (ProjectContent.lookupProvider(contentSetKey) == null) {
            contentSetKey = "oracle.ide.model.ResourcePaths/resourcesContentSet";
            status = false;
        }
        ContentSet cs = this.getContentSet(contentSetKey);
        ContentSet allContents = this.getAllContents();
        for (int i = 0; i < nodes.length; ++i) {
            URL url = nodes[i].getURL();
            boolean included = true;
            included = contentSetKey.equals("oracle.ide.model.ResourcePaths/resourcesContentSet") ? allContents.canHaveMember(url) : cs.canHaveMember(url);
            if (included || this.addImpl(nodes[i], contentSetKey)) continue;
            status = false;
            if (!contentSetKey.equals("oracle.ide.model.ResourcePaths/resourcesContentSet") && this.addImpl(nodes[i], "oracle.ide.model.ResourcePaths/resourcesContentSet")) continue;
            Assert.println((String)("Failed to add '" + nodes[i].getLongLabel() + "' to project."));
            Assert.printStackTrace();
        }
        return status;
    }

    private boolean addImpl(Node node, String contentSetKey) {
        Node adjustedNode = this.adjust(node);
        URL url = adjustedNode.getURL();
        ContentSetHelper helper = this.lookupHelper(contentSetKey);
        if (helper != null && helper.canAddContent(url, this)) {
            ProgressBar progressBar = SwingUtilities.isEventDispatchThread() ? new ProgressBar((Component)((Object)Ide.getMainWindow()), "Add Content", null, true) : null;
            helper.addContent(url, this, this._includeSubFolders, progressBar);
            return true;
        }
        return false;
    }

    private Node adjust(Node node) {
        URLFilter filter = GlobalIgnoreList.getURLFilter();
        URL url = node.getURL();
        if (URLFileSystem.isDirectory((URL)url)) {
            URL[] children = URLFileSystem.list((URL)url, (URLFilter)filter);
            if (children == null || children.length == 0) {
                this._includeSubFolders = true;
            }
        } else if (URLFileSystem.isDirectoryPath((URL)url)) {
            this._includeSubFolders = true;
        } else {
            URL container = URLFileSystem.getParent((URL)url);
            URL[] children = URLFileSystem.list((URL)container, (URLFilter)filter);
            if (children == null || children.length == 0 || children.length == 1 && ModelUtil.areEqual((Object)children[0], (Object)url)) {
                try {
                    Node containerNode = NodeFactory.findOrCreate(container);
                    if (containerNode != null) {
                        this._includeSubFolders = true;
                        return containerNode;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        return node;
    }

    private ContentSetHelper lookupHelper(String key) {
        ContentSetProviderReference ref = ProjectContent.lookupProvider(key);
        if (ref == null) {
            return null;
        }
        ContentSetProvider provider = ref.contentSetProvider();
        return provider.getContentSetHelper();
    }

    private static ContentSetProviderReference lookupProvider(String key) {
        ContentSetProviderReference[] refs;
        for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
            if (!ref.key().equals(key)) continue;
            return ref;
        }
        return null;
    }

    static boolean isDisplayFoldersAsPackages(String contentSetKey) {
        return _contentSetKeysForDisplayFoldersAsPackages.contains(contentSetKey);
    }

    static {
        IdeArgs ideArgs;
        _contentSetProviders = new CopyOnWriteArrayList();
        _projectChangeListener = new L();
        _contentSetKeysForDisplayFoldersAsPackages = new HashSet();
        VFS_REMOVAL_SCHEDULER = new VFSRemovalExecutor();
        LOG = Logger.getLogger("oracle.ide.model");
        if (Ide.isRunning() && (ideArgs = Ide.getIdeArgs()) != null && ideArgs.getCreateUI()) {
            Project.addProjectChangeListener("###", new AutoSelecter());
        }
    }

    private static class L
    extends ProjectChangeListener {
        private L() {
        }

        @Override
        public void projectOpened(Project project) {
            VFSListener vfsListener = new VFSListener(project);
            L.setVFSListener(project, vfsListener);
            this.updateURLFileSystemListenerURLsOfProject(project, L.getVFSListener(project));
            Node.addNodeListenerForTypeHierarchy(Node.class, vfsListener);
        }

        private boolean containsNodeAddedEvents(ProjectChangeEvent e) {
            ChangeInfo[] changeInfos;
            for (ChangeInfo ci : changeInfos = e.getChangeDetails()) {
                if (ci.getChangeType() != 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            Project project = e.getProject();
            if (this.containsNodeAddedEvents(e)) {
                TechnologyScopeManager.Scanner scanner = TechnologyScopeManager.getTechnologyScopeManager().getScanner().canScan(e) ? TechnologyScopeManager.getTechnologyScopeManager().getScanner() : TechnologyScopeManager.SAME_THREAD_SCANNER;
                Collection<URL> updatedURLs = this.updateURLFileSystemListenerURLsOfProject(project, L.getVFSListener(project));
                try {
                    Collection<String> allNewTechs = scanner.scanForNewTechnologies(updatedURLs, project);
                    if (!allNewTechs.isEmpty()) {
                        TechnologyScopeConfiguration.getInstance(project).updateTechnologyScope(allNewTechs.toArray(new String[allNewTechs.size()]));
                    }
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.SEVERE, "Scanning for technologies interrupted", ie);
                }
            }
            URLPath contentProvidersPath = ProjectContent.getInstance(project).getAllContents().getAllRootDirs();
            PropertyChangeEvent pce = new PropertyChangeEvent(project, ProjectContent.CONTENT_SETS_PROPERTY, null, contentProvidersPath);
            PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
            UpdateMessage.firePropertiesChanged(project, pces, ProjectContent.class);
        }

        @Override
        public void projectClosed(Project project) {
            final VFSListener vfsListener = L.getVFSListener(project);
            if (vfsListener != null) {
                vfsListener.setEnabled(false);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Collection urls = URLFileSystem.getURLsForListener((URLFileSystemListener)vfsListener);
                        Iterator iter = urls.iterator();
                        while (iter.hasNext()) {
                            URLFileSystem.removeURLFileSystemListener((URL)((URL)iter.next()), (URLFileSystemListener)vfsListener);
                        }
                        Node.removeNodeListenerForTypeHierarchy(Node.class, vfsListener);
                    }
                };
                VFS_REMOVAL_SCHEDULER.submit(r);
            }
        }

        private static VFSListener getVFSListener(Project project) {
            return (VFSListener)project.getTransientProperties().get("VFSListener");
        }

        private static void setVFSListener(Project project, VFSListener vfsListener) {
            project.getTransientProperties().put("VFSListener", vfsListener);
        }

        private Collection<URL> updateURLFileSystemListenerURLsOfProject(Project project, URLFileSystemListener urlFSListener) {
            ArrayList<URL> addedURLs = new ArrayList<URL>();
            if (urlFSListener != null) {
                Collection urls = URLFileSystem.getURLsForListener((URLFileSystemListener)urlFSListener);
                Collection<URL> contentDirs = this.getTopLevelRootDirs(project);
                for (URL url : contentDirs) {
                    if (urls.contains(url)) continue;
                    addedURLs.add(url);
                    URLFileSystem.addURLFileSystemListener((URL)url, (URLFileSystemListener)urlFSListener);
                }
                for (URL url : urls) {
                    if (contentDirs.contains(url)) continue;
                    URLFileSystem.removeURLFileSystemListener((URL)url, (URLFileSystemListener)urlFSListener);
                }
            }
            return addedURLs;
        }

        private Collection<URL> getTopLevelRootDirs(Project project) {
            ArrayList<URL> urls = new ArrayList<URL>();
            URLPath contentDirs = ProjectContent.getInstance(project).getAllContents().getAllRootDirs();
            block0: for (URL current : contentDirs) {
                Iterator<URL> urlIter = urls.iterator();
                while (urlIter.hasNext()) {
                    URL url = urlIter.next();
                    if (URLFileSystem.isBaseURLFor((URL)url, (URL)current)) continue block0;
                    if (!URLFileSystem.isBaseURLFor((URL)current, (URL)url)) continue;
                    urlIter.remove();
                }
                urls.add(current);
            }
            return urls;
        }
    }

    static final class ChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private Class _type;

        ChildTypeIterator(Iterator iter, Class childType) {
            this._iter = iter;
            this._type = childType;
        }

        @Override
        public boolean hasNext() {
            while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object elem = this._iter.next();
                if (!this._type.isAssignableFrom(elem.getClass())) continue;
                this._next = elem;
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    static final class MultiChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private final Class[] _types;
        private final int _len;

        MultiChildTypeIterator(Iterator iter, Class[] childTypes) {
            this._iter = iter;
            this._types = childTypes;
            this._len = this._types.length;
        }

        @Override
        public boolean hasNext() {
            block0: while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object elem = this._iter.next();
                Class<?> c = elem.getClass();
                for (int i = 0; i < this._len; ++i) {
                    if (!this._types[i].isAssignableFrom(c)) continue;
                    this._next = elem;
                    continue block0;
                }
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class VFSRemovalExecutor
    extends ThreadPoolExecutor {
        public VFSRemovalExecutor() {
            super(0, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new VFSRemovalThreadFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            VFSRemovalExecutor vFSRemovalExecutor = this;
            synchronized (vFSRemovalExecutor) {
                this.setCorePoolSize(1);
                super.execute(command);
                this.setCorePoolSize(0);
            }
        }
    }

    private static class AutoSelecter
    extends ProjectChangeListener
    implements Observer {
        private AutoSelecter() {
        }

        @Override
        public void projectLoaded(Project project) {
            project.attach(this);
        }

        @Override
        public void projectUnloaded(Project project) {
            project.detach(this);
        }

        @Override
        public void update(Object observed, UpdateMessage change) {
            List addObjects;
            if (change.getMessageID() == UpdateMessage.CHILD_ADDED && (addObjects = change.getAddObjects()) != null && addObjects.size() > 0) {
                int i = addObjects.size();
                while (i > 0) {
                    Object addObject;
                    if ((addObject = addObjects.get(--i)) instanceof NonAutoSelectable) {
                        return;
                    }
                    if (!(addObject instanceof Node)) continue;
                    Node node = (Node)addObject;
                    Context context = Context.newIdeContext();
                    context.setProject((Project)observed);
                    context.setNode(node);
                    context.setBoolean(ProjectContent.AUTO_SELECTOR_CONTEXT_KEY, true);
                    try {
                        ContentSet cs = this.getOwningContentSet(context);
                        if (cs != null && !cs.isAutoExpand(context.getNode().getURL())) break;
                        NavigatorWindow.openContextInLastActiveNavigator(context);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private ContentSet getOwningContentSet(Context context) {
            ContentSetProviderReference[] refs;
            for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
                String key = ref.key();
                ContentSet cs = ContentSet.getInstance(context.getProject(), key);
                if (!cs.canHaveMember(context.getNode().getURL())) continue;
                cs.setNoAutoexpandFilters(ref.getNoAutoexpandFilters());
                return cs;
            }
            return null;
        }
    }

    private static class VFSRemovalThreadFactory
    implements ThreadFactory {
        private VFSRemovalThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "VFS Listener Removal");
            t.setPriority(4);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class VFSListener
    extends NodeListener
    implements URLFileSystemListener {
        private final Project _project;
        private boolean _enabled = true;
        private final ArrayList _addInProgress = new ArrayList();
        private final ArrayList _removeInProgress = new ArrayList();

        private VFSListener(Project project) {
            this._project = project;
        }

        private void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeDeleted(NodeEvent e) {
            URL removedURL;
            if (!this._enabled) {
                return;
            }
            ContentSet contents = ProjectContent.getInstance(this._project).getAllContents();
            if (contents.canHaveMember(removedURL = e.getNodeURL())) {
                this.startAssertTracking(null, removedURL);
                try {
                    Node removedNode = e.getNode();
                    this.fireRemovedEvent(removedURL, removedNode);
                }
                finally {
                    this.stopAssertTracking(null, removedURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            if (!this._enabled) {
                return;
            }
            ContentSet contents = ProjectContent.getInstance(this._project).getAllContents();
            boolean hasOldURL = contents.canHaveMember(oldURL);
            boolean hasNewURL = contents.canHaveMember(newURL);
            if (hasOldURL || hasNewURL) {
                this.startAssertTracking(newURL, oldURL);
                try {
                    if (hasOldURL && hasNewURL) {
                        Node oldNode = e.getNode();
                        Node newNode = NodeFactory.findOrCreateOrFail(newURL);
                        this.fireRenamedEvents(oldURL, oldNode, newNode);
                    } else if (hasOldURL) {
                        Node oldNode = e.getNode();
                        this.fireRemovedEvent(oldURL, oldNode);
                    } else {
                        Node newNode = NodeFactory.find(newURL);
                        this.fireAddedEvent(newNode);
                    }
                }
                finally {
                    this.stopAssertTracking(newURL, oldURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyEvent(URLFileSystemEvent event) {
            if (!this._enabled) {
                return;
            }
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: {
                    ContentSet contents = ProjectContent.getInstance(this._project).getAllContents();
                    URL addedURL = event.getURL();
                    if (!contents.canHaveMember(addedURL)) break;
                    this.startAssertTracking(addedURL, null);
                    try {
                        Node node = NodeFactory.findOrCreate(addedURL);
                        Collection<String> techScopes = TechnologyScopeManager.getTechnologyScopeManager().getDetector().detectTechnologyScopeIdsOfURL(this._project, addedURL);
                        if (!techScopes.isEmpty()) {
                            TechnologyScopeConfiguration.getInstance(this._project).updateTechnologyScope(techScopes.toArray(new String[techScopes.size()]));
                        }
                        this.fireAddedEvent(node);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    finally {
                        this.stopAssertTracking(addedURL, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startAssertTracking(URL addedURL, URL removedURL) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (addedURL != null && this._removeInProgress.contains(addedURL)) {
                    new RuntimeException("Assertion failure: FILE_ADDED event received while processing FILE_REMOVED for " + addedURL).printStackTrace();
                }
                if (removedURL != null && this._addInProgress.contains(removedURL)) {
                    new RuntimeException("Assertion failure: FILE_REMOVED event received while processing FILE_ADDED for " + removedURL).printStackTrace();
                }
                if (addedURL != null) {
                    this._addInProgress.add(addedURL);
                }
                if (removedURL != null) {
                    this._removeInProgress.add(removedURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAssertTracking(URL addedURL, URL removedURL) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (addedURL != null) {
                    this._addInProgress.remove(addedURL);
                }
                if (removedURL != null) {
                    this._removeInProgress.remove(removedURL);
                }
            }
        }

        private void fireAddedEvent(Node addedNode) {
            UpdateMessage.fireChildAdded(this._project, addedNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireRemovedEvent(final URL removedURL, Node removedNode) {
            Observer assertionObserver = new Observer(){

                @Override
                public void update(Object object, UpdateMessage message) {
                    if (message.getOrigin() != this) {
                        new RuntimeException("Assertion failure: Observer update received on a node that has already been deleted from disk for " + removedURL).printStackTrace();
                    }
                }
            };
            try {
                removedNode.attach(assertionObserver);
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, this);
                updateMessage.getRemoveObjects().add(removedNode);
                this._project.notifyObservers(this._project, updateMessage);
            }
            finally {
                removedNode.detach(assertionObserver);
            }
        }

        private void fireRenamedEvents(URL oldURL, Node oldNode, Node newNode) {
            UpdateMessage event = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, oldNode);
            RenameMessage.setRenamedNode(event, oldNode);
            if (newNode != null) {
                event.getAddObjects().add(newNode);
                event.getRemoveObjects().add(oldNode);
            }
            event.getModifyObjects().add(oldURL);
            oldNode.notifyObservers(oldNode, event);
            event = new UpdateMessage(UpdateMessage.CHILD_RENAMED, this._project);
            RenameMessage.setRenamedNode(event, oldNode);
            if (newNode != null) {
                event.getAddObjects().add(newNode);
                event.getRemoveObjects().add(oldNode);
            }
            event.getModifyObjects().add(oldURL);
            event.getModifyObjects().add(this._project);
            this._project.notifyObservers(this._project, event);
        }
    }
}

