/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.javatools.data.HashStructure;

class FileExtensionRecognizerHookHelper {
    private static final Logger LOG = Logger.getLogger(FileExtensionRecognizerHookHelper.class.getName());

    static Map<File, MetaClass<Node>> findFileExtensionMappings(HashStructure hs) {
        return Collections.unmodifiableMap(FileExtensionRecognizerHookHelper.buildFileExtensionMappings(hs));
    }

    private static Map<File, MetaClass<Node>> buildFileExtensionMappings(HashStructure hs) {
        HashMap<File, MetaClass<Node>> mappings = new HashMap<File, MetaClass<Node>>();
        List urlRecognizers = hs.getAsList("url-recognizer");
        if (urlRecognizers == null) {
            return mappings;
        }
        for (Object o : urlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            FileExtensionRecognizerHookHelper.addFileExtensionMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addFileExtensionMapping(HashStructure hs, Map<File, MetaClass<Node>> mappings) {
        List fileExtensions = hs.getAsList("file-extension");
        if (fileExtensions == null) {
            return;
        }
        for (Object o : fileExtensions) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String fileExtension = childHs.getString("extension/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass type = adapter.getMetaClass("node-type/#text");
            if (type == null) {
                LOG.log(Level.WARNING, "Missing type in <url-recognizer> registration for extension " + fileExtension);
                return;
            }
            if (fileExtension == null) {
                LOG.log(Level.WARNING, "Missing extension in <url-recognizer> registration for type " + (type == null ? "null" : type.getClassName()));
                return;
            }
            mappings.put(Recognizer.sanitizeExtension(fileExtension), type);
        }
    }

    private FileExtensionRecognizerHookHelper() {
    }
}

