/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.log.LogManager;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.HSAdapterDelegateMediator;
import oracle.ide.model.Project;
import oracle.ide.resource.IdeArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.ModelUtil;

public class DependencyConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = DependencyConfiguration.class.getName();
    private static final String MODULE_PATH_DEPENDENCIES_LIST = "modulePathDependencies";
    private static final Logger _extensionLogger = Logger.getLogger(DATA_KEY);
    private final Project _project;
    public static final String DEPENDENCY_LIST = "dependencyList";

    private DependencyConfiguration(HashStructure hash, Project project) {
        super(hash);
        this._project = project;
    }

    public static DependencyConfiguration getInstance(Project project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static DependencyConfiguration getInstance(PropertyStorage project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), null);
    }

    private ListStructure getDependenciesListStructure() {
        return this._hash.getListStructure(DEPENDENCY_LIST);
    }

    public void attachDependencyChangeListener(StructureChangeListener listener) {
        this._hash.getOrCreateListStructure(DEPENDENCY_LIST).addStructureChangeListener(listener);
        this._hash.getOrCreateListStructure(MODULE_PATH_DEPENDENCIES_LIST).addStructureChangeListener(listener);
    }

    public void detachDependencyChangeListener(StructureChangeListener listener) {
        if (this.getDependenciesListStructure() != null) {
            this.getDependenciesListStructure().removeStructureChangeListener(listener);
        }
        this.getModulePathDependencyListStructure().removeStructureChangeListener(listener);
    }

    public List<Dependable> getDependencyList() {
        return this.getDependencyList(this.getDependenciesListStructure());
    }

    public List<Dependable> getClassPathDependencyList() {
        List<Dependable> dependencies = this.getDependencyList();
        List<Dependable> modulePathDependencies = this.getModulePathDependencyList();
        dependencies.removeIf(modulePathDependencies::contains);
        return dependencies;
    }

    public List<Dependable> getModulePathDependencyList() {
        return this.getDependencyList(this.getModulePathDependencyListStructure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependable> getDependencyList(ListStructure depList) {
        ArrayList<Dependable> dependencies = new ArrayList<Dependable>();
        if (depList != null) {
            Object object = depList.iteratorLock();
            synchronized (object) {
                for (Object o : depList) {
                    HashStructure hash = (HashStructure)o;
                    try {
                        int code;
                        Dependable dependable = DependableFactory.getInstance().toDependable(hash, this._project);
                        if (dependable != null && dependable.getSource() != null && dependable.getSource() != this._project) {
                            dependencies.add(dependable);
                            continue;
                        }
                        StringBuilder builder = new StringBuilder();
                        String EOL = System.getProperty("line.separator");
                        if (dependable == null) {
                            code = 499;
                        } else if (this._project != null && dependable.getSource() == this._project) {
                            if (this._project.getTransientProperties().putIfAbsent("oracle.ide.project.self.dependency", Boolean.TRUE) != null) continue;
                            code = 500;
                        } else {
                            code = 498;
                            builder.append("  TOSTRING: ").append(dependable).append(EOL);
                            builder.append("  SOURCE:   ").append(dependable.getSource()).append(EOL);
                            builder.append("  OWNER:    ").append(dependable.getSourceOwner());
                        }
                        builder.append(EOL);
                        String project = this._project != null ? this._project.getLongLabel() : "<null>";
                        String message = IdeArb.format(code, project, builder);
                        if (Ide.getIdeArgs().getCreateUI()) {
                            LogManager.getLogManager().getMsgPage().log(message);
                            continue;
                        }
                        System.err.println("WARNING: " + message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return dependencies;
    }

    public void setDependencyList(List<Dependable> dependencies) {
        this.setDependencyList(dependencies, this.getDependencyListStructure());
    }

    public void setModulePathDependencyList(List<Dependable> dependencies) {
        this.setDependencyList(dependencies, this.getModulePathDependencyListStructure());
    }

    private void setDependencyList(List<Dependable> dependencies, ListStructure dependencyListStructure) {
        ArrayList<HashStructure> depList = new ArrayList<HashStructure>();
        if (dependencies != null) {
            for (Dependable dependable : dependencies) {
                try {
                    depList.add(DependableFactory.getInstance().toHashStructure(dependable, this._project));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        dependencyListStructure.mirror(depList);
    }

    private ListStructure getDependencyListStructure() {
        return this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    private ListStructure getModulePathDependencyListStructure() {
        return this._hash.getOrCreateListStructure(MODULE_PATH_DEPENDENCIES_LIST);
    }

    public void addDependency(Dependable dependable) throws IllegalStateException {
        this.addDependency(dependable, false);
    }

    public void addDependency(Dependable dependable, boolean isModulePathDependency) {
        if (dependable != null) {
            ListStructure list = this.getDependencyListStructure();
            ListStructure modulePathList = isModulePathDependency ? this.getModulePathDependencyListStructure() : null;
            try {
                HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                if (!list.contains((Object)hash)) {
                    this.checkExistingMutuallyExclusiveDependency(dependable);
                    list.add((Object)hash);
                    if (isModulePathDependency) {
                        hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                        modulePathList.add((Object)hash);
                    }
                    if (this._project != null && HSAdapterDelegateMediator.getMediator().needsDelegation(this._project, this._project.getProperties())) {
                        HashStructure hs = HashStructure.newInstance();
                        this._hash.remove("_equals_breaker_");
                        this._hash.copyTo(hs);
                        hs.putHashStructure("_equals_breaker_", HashStructure.newInstance());
                        this._project.getProperties()._putObject(DATA_KEY, (Object)hs);
                    }
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeDependency(Dependable dependable) {
        this.removeDependency(dependable, this.getDependencyListStructure());
        this.removeDependency(dependable, this.getModulePathDependencyListStructure());
    }

    private void removeDependency(Dependable dependable, ListStructure dependencyList) {
        if (dependable == null || dependencyList == null) {
            return;
        }
        try {
            HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
            Iterator i = dependencyList.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (next == null || !next.equals(hash)) continue;
                i.remove();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Logger getLogger() {
        return _extensionLogger;
    }

    public Iterator<Dependable> getDependencies() {
        return this.getDependencyList().iterator();
    }

    public List<Dependable> getAllDependenciesList() {
        return this.getAllDependenciesList(this.getDependencies());
    }

    public List<Dependable> getAllClassPathDependenciesList() {
        return this.getAllDependenciesList(this.getClassPathDependencyList().iterator());
    }

    public List<Dependable> getAllModulePathDependenciesList() {
        return this.getAllDependenciesList(this.getModulePathDependencyList().iterator());
    }

    private List<Dependable> getAllDependenciesList(Iterator<Dependable> dependencies) {
        ArrayList<Dependable> allDependables = new ArrayList<Dependable>();
        ArrayList<Element> seenSources = new ArrayList<Element>();
        if (this._project != null) {
            seenSources.add(this._project);
        } else {
            new Exception("*** Warning: Project not specified to DependencyConfiguration.  Cycles will not be detected properly.").printStackTrace();
        }
        this.collectDependencies(dependencies, allDependables, seenSources);
        return allDependables;
    }

    private void collectDependencies(Iterator<Dependable> dependencies, List<Dependable> output, List<Element> seenSources) {
        while (dependencies.hasNext()) {
            Dependable dependable = dependencies.next();
            if (DependencyConfiguration.wasSourceSeen(dependable.getSource(), seenSources)) continue;
            seenSources.add(dependable.getSource());
            this.collectDependencies(dependable.getDependencies(), output, seenSources);
            output.add(dependable);
        }
    }

    private static boolean wasSourceSeen(Element element, List<Element> seenSources) {
        for (Element source : seenSources) {
            if (source != element) continue;
            return true;
        }
        return false;
    }

    private void checkExistingMutuallyExclusiveDependency(Dependable dependable) throws IllegalStateException {
        URL sourceUrl;
        boolean isOutputPathDependency = false;
        if (dependable.getSource() instanceof Project) {
            sourceUrl = ((Project)dependable.getSource()).getURL();
            isOutputPathDependency = true;
        } else if (dependable.getSourceOwner() instanceof Project) {
            sourceUrl = ((Project)dependable.getSourceOwner()).getURL();
        } else {
            return;
        }
        Iterator<Dependable> i = this.getDependencies();
        while (i.hasNext()) {
            Dependable next = i.next();
            URL depURL = null;
            if (isOutputPathDependency) {
                if (next.getSourceOwner() instanceof Project) {
                    depURL = ((Project)next.getSourceOwner()).getURL();
                }
            } else if (next.getSource() instanceof Project) {
                depURL = ((Project)next.getSource()).getURL();
            }
            if (!ModelUtil.areEqual((Object)sourceUrl, depURL)) continue;
            throw new IllegalStateException(IdeArb.format(516, dependable.toString(), next.toString()));
        }
    }
}

