/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.ContentSetProvidersHook;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ApplicationContent
extends HashStructureAdapter {
    private boolean _includeSubFolders = false;
    public static final String CONTENT_SETS_PROPERTY = "contentProvidersPath";
    private static final CopyOnWriteArrayList<ContentSetProvider> _contentSetProviders = new CopyOnWriteArrayList();
    private static HashSet _contentSetKeysForDisplayFoldersAsPackages = new HashSet();
    private static final ExecutorService VFS_REMOVAL_SCHEDULER = new VFSRemovalExecutor();

    private ApplicationContent(HashStructure hash) {
        super(hash);
    }

    @Deprecated
    public List<String> getMissingContentSetKeys() {
        ArrayList<String> missingContentSets = new ArrayList<String>();
        ContentSetProviderReference[] refs = ApplicationContent.getContentSetProviderReferences();
        ListStructure metaList = this.getContentSetList();
        for (ContentSetProviderReference ref : refs) {
            String key = ref.key();
            if (key == null || metaList.contains((Object)key) && (this._hash.keyStatus(key) == 1 || this._hash.getBoolean(".initialized"))) continue;
            missingContentSets.add(key);
        }
        return missingContentSets;
    }

    @Deprecated
    public boolean isMissingContentSetKeys() {
        ContentSetProviderReference[] refs;
        ListStructure metaList = this.getContentSetList();
        for (ContentSetProviderReference ref : refs = ApplicationContent.getContentSetProviderReferences()) {
            String key = ref.key();
            if (key == null || metaList.contains((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static void initializeContentSets(Workspace workspace) {
        ApplicationContent.initializeContentSets(workspace, true);
    }

    static void initializeContentSets(final Workspace workspace, final boolean persistent) {
        workspace.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                ContentSetProviderReference[] refs = ApplicationContent.getContentSetProviderReferences();
                HashStructure shared = workspace.getSharedPropertiesOnly();
                ListStructure metaList = ApplicationContent.getInstance(workspace).getContentSetList();
                URL workspaceDir = URLFileSystem.getParent((URL)workspace.getURL());
                Context context = new Context();
                context.setWorkspace(workspace);
                for (ContentSetProviderReference provider : refs) {
                    String key = provider.key();
                    if (key == null || !provider.applicationLevelContent()) continue;
                    int keyStatus = shared.keyStatus(key);
                    HashStructure contentSetHash = null;
                    switch (keyStatus) {
                        case 0: {
                            contentSetHash = HashStructure.newInstance();
                            break;
                        }
                        case 2: {
                            HashStructure existing = shared.getHashStructure(key);
                            if (existing.getBoolean(".initialized")) break;
                            contentSetHash = HashStructure.newInstance();
                            existing.copyTo(contentSetHash);
                        }
                    }
                    if (contentSetHash != null) {
                        ContentSet contentSet = new ContentSet(contentSetHash);
                        provider.initContentSet(contentSet, workspaceDir, context);
                        contentSetHash.getBoolean(".initialized", true);
                        if (persistent) {
                            shared.putHashStructure(key, contentSetHash);
                        } else {
                            shared.putPlaceholderHashStructure(key, contentSetHash);
                        }
                    }
                    if (metaList.size() == 0) {
                        metaList.add((Object)key);
                        continue;
                    }
                    if (metaList.contains((Object)key)) continue;
                    metaList.addPlaceholder((Object)key);
                }
            }
        });
    }

    public static ApplicationContent getInstance(PropertyStorage workspace) {
        if (workspace != null) {
            return new ApplicationContent(workspace.getProperties());
        }
        return new ApplicationContent(HashStructure.newInstance());
    }

    public static ApplicationContent getInstance(HashStructure hash) {
        return new ApplicationContent(hash);
    }

    public static ContentSetProviderReference[] getContentSetProviderReferences() {
        ContentSetProvidersHook hook = ContentSetProvidersHook.getHook();
        List<ContentSetProviderReference> fromHook = hook.contentSetProviderReferences();
        ArrayList<ContentSetProviderReference> refs = new ArrayList<ContentSetProviderReference>(fromHook.size() + _contentSetProviders.size());
        for (ContentSetProviderReference ref : fromHook) {
            if (!ref.applicationLevelContent()) continue;
            ApplicationContent.registerDeclarativeContentSetProvider(ref);
            refs.add(ref);
        }
        for (ContentSetProvider p : _contentSetProviders) {
            ContentSetProviderReference ref = new ContentSetProviderReference(p);
            refs.add(ref);
        }
        return refs.toArray(new ContentSetProviderReference[refs.size()]);
    }

    public static final void registerDeclarativeContentSetProvider(ContentSetProviderReference provider) {
        if (provider != null) {
            String key = provider.key();
            if (key != null) {
                if (provider.displayFoldersAsPackages()) {
                    _contentSetKeysForDisplayFoldersAsPackages.add(key);
                }
            } else {
                new IllegalArgumentException("Null ContentSet key not allowed.").printStackTrace();
            }
        }
    }

    public ContentSet getContentSet(String contentSetKey) {
        return new ContentSet(this._hash.getOrCreateHashStructure(contentSetKey));
    }

    public final ListStructure getContentSetList() {
        return this._hash.getOrCreateListStructure("contentSets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentSet getAllContents() {
        ContentSet all = new ContentSet(HashStructure.newInstance(), false);
        ListStructure contentSetList = this.getContentSetList();
        Object object = contentSetList.iteratorLock();
        synchronized (object) {
            for (Object keyObj : contentSetList) {
                if (keyObj == null) continue;
                String key = keyObj.toString();
                all.addContentSet(this.getContentSet(key));
            }
        }
        return all;
    }

    public final URLPath getJavaRootDirs() {
        URLPath sourcePath = new URLPath();
        ContentSetProviderReference[] refs = ApplicationContent.getContentSetProviderReferences();
        if (refs != null) {
            for (ContentSetProviderReference ref : refs) {
                if (!ref.canContainJavaSources()) continue;
                ContentSet cs = this.getContentSet(ref.key());
                sourcePath.add(cs.getAllRootDirs());
            }
        }
        return sourcePath;
    }

    public Iterator getNodeIterator() {
        return this.getAllContents().nodeIterator("");
    }

    public final Iterator findChildren(Class childType) {
        return new ChildTypeIterator(this.getNodeIterator(), childType);
    }

    public final Iterator findChildren(Class[] types) {
        switch (types.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findChildren(types[0]);
            }
        }
        return new MultiChildTypeIterator(this.getNodeIterator(), types);
    }

    public final Iterator findChildren(Class childType, String contentSetKey) {
        ContentSet cs = this.getContentSet(contentSetKey);
        return cs != null ? new ChildTypeIterator(cs.nodeIterator(null), childType) : Collections.EMPTY_LIST.iterator();
    }

    public boolean add(Node node, String contentSetKey) {
        return this.add(new Node[]{node}, contentSetKey);
    }

    public boolean add(Node[] nodes, String contentSetKey) {
        if (nodes.length == 0) {
            return true;
        }
        boolean status = true;
        if (ApplicationContent.lookupProvider(contentSetKey) == null) {
            contentSetKey = "oracle.ide.model.ResourcePaths/resourcesContentSet";
            status = false;
        }
        ContentSet cs = this.getContentSet(contentSetKey);
        ContentSet allContents = this.getAllContents();
        for (int i = 0; i < nodes.length; ++i) {
            URL url = nodes[i].getURL();
            boolean included = true;
            included = contentSetKey.equals("oracle.ide.model.ResourcePaths/resourcesContentSet") ? allContents.canHaveMember(url) : cs.canHaveMember(url);
            if (included || this.addImpl(nodes[i], contentSetKey)) continue;
            status = false;
            if (!contentSetKey.equals("oracle.ide.model.ResourcePaths/resourcesContentSet") && this.addImpl(nodes[i], "oracle.ide.model.ResourcePaths/resourcesContentSet")) continue;
            Assert.println((String)("Failed to add '" + nodes[i].getLongLabel() + "' to workspace."));
            Assert.printStackTrace();
        }
        return status;
    }

    private boolean addImpl(Node node, String contentSetKey) {
        Node adjustedNode = this.adjust(node);
        URL url = adjustedNode.getURL();
        ContentSetHelper helper = this.lookupHelper(contentSetKey);
        if (helper != null && helper.canAddApplicationContent(url, this)) {
            ProgressBar progressBar = SwingUtilities.isEventDispatchThread() ? new ProgressBar((Component)((Object)Ide.getMainWindow()), "Add Content", null, true) : null;
            helper.addApplicationContent(url, this, this._includeSubFolders, progressBar);
            return true;
        }
        return false;
    }

    private Node adjust(Node node) {
        URLFilter filter = GlobalIgnoreList.getURLFilter();
        URL url = node.getURL();
        if (URLFileSystem.isDirectory((URL)url)) {
            URL[] children = URLFileSystem.list((URL)url, (URLFilter)filter);
            if (children == null || children.length == 0) {
                this._includeSubFolders = true;
            }
        } else if (URLFileSystem.isDirectoryPath((URL)url)) {
            this._includeSubFolders = true;
        } else {
            URL container = URLFileSystem.getParent((URL)url);
            URL[] children = URLFileSystem.list((URL)container, (URLFilter)filter);
            if (children == null || children.length == 0 || children.length == 1) {
                try {
                    Node containerNode = NodeFactory.findOrCreate(container);
                    if (containerNode != null) {
                        this._includeSubFolders = true;
                        return containerNode;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        return node;
    }

    private ContentSetHelper lookupHelper(String key) {
        ContentSetProviderReference ref = ApplicationContent.lookupProvider(key);
        if (ref == null) {
            return null;
        }
        ContentSetProvider provider = ref.contentSetProvider();
        return provider.getContentSetHelper();
    }

    private static ContentSetProviderReference lookupProvider(String key) {
        ContentSetProviderReference[] refs;
        for (ContentSetProviderReference ref : refs = ApplicationContent.getContentSetProviderReferences()) {
            if (!ref.key().equals(key)) continue;
            return ref;
        }
        return null;
    }

    static boolean isDisplayFoldersAsPackages(String contentSetKey) {
        return _contentSetKeysForDisplayFoldersAsPackages.contains(contentSetKey);
    }

    static final class ChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private Class _type;

        ChildTypeIterator(Iterator iter, Class childType) {
            this._iter = iter;
            this._type = childType;
        }

        @Override
        public boolean hasNext() {
            while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object elem = this._iter.next();
                if (!this._type.isAssignableFrom(elem.getClass())) continue;
                this._next = elem;
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    static final class MultiChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private final Class[] _types;
        private final int _len;

        MultiChildTypeIterator(Iterator iter, Class[] childTypes) {
            this._iter = iter;
            this._types = childTypes;
            this._len = this._types.length;
        }

        @Override
        public boolean hasNext() {
            block0: while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object elem = this._iter.next();
                Class<?> c = elem.getClass();
                for (int i = 0; i < this._len; ++i) {
                    if (!this._types[i].isAssignableFrom(c)) continue;
                    this._next = elem;
                    continue block0;
                }
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class VFSRemovalExecutor
    extends ThreadPoolExecutor {
        public VFSRemovalExecutor() {
            super(0, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new VFSRemovalThreadFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            VFSRemovalExecutor vFSRemovalExecutor = this;
            synchronized (vFSRemovalExecutor) {
                this.setCorePoolSize(1);
                super.execute(command);
                this.setCorePoolSize(0);
            }
        }
    }

    private static class VFSRemovalThreadFactory
    implements ThreadFactory {
        private VFSRemovalThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "VFS Listener Removal");
            t.setPriority(4);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class VFSListener
    extends NodeListener
    implements URLFileSystemListener {
        private final Workspace _workspace;
        private boolean _enabled = true;
        private final ArrayList _addInProgress = new ArrayList();
        private final ArrayList _removeInProgress = new ArrayList();

        private VFSListener(Workspace workspace) {
            this._workspace = workspace;
        }

        private void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeDeleted(NodeEvent e) {
            URL removedURL;
            if (!this._enabled) {
                return;
            }
            ContentSet contents = ApplicationContent.getInstance(this._workspace).getAllContents();
            if (contents.canHaveMember(removedURL = e.getNodeURL())) {
                this.startAssertTracking(null, removedURL);
                try {
                    Node removedNode = e.getNode();
                    this.fireRemovedEvent(removedURL, removedNode);
                }
                finally {
                    this.stopAssertTracking(null, removedURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            if (!this._enabled) {
                return;
            }
            ContentSet contents = ApplicationContent.getInstance(this._workspace).getAllContents();
            boolean hasOldURL = contents.canHaveMember(oldURL);
            boolean hasNewURL = contents.canHaveMember(newURL);
            if (hasOldURL || hasNewURL) {
                this.startAssertTracking(newURL, oldURL);
                try {
                    if (hasOldURL && hasNewURL) {
                        Node oldNode = e.getNode();
                        Node newNode = NodeFactory.findOrCreateOrFail(newURL);
                        this.fireRenamedEvents(oldURL, oldNode, newNode);
                    } else if (hasOldURL) {
                        Node oldNode = e.getNode();
                        this.fireRemovedEvent(oldURL, oldNode);
                    } else {
                        Node newNode = NodeFactory.find(newURL);
                        this.fireAddedEvent(newNode);
                    }
                }
                finally {
                    this.stopAssertTracking(newURL, oldURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyEvent(URLFileSystemEvent event) {
            if (!this._enabled) {
                return;
            }
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: {
                    ContentSet contents = ApplicationContent.getInstance(this._workspace).getAllContents();
                    URL addedURL = event.getURL();
                    if (!contents.canHaveMember(addedURL)) break;
                    this.startAssertTracking(addedURL, null);
                    try {
                        Node node = NodeFactory.findOrCreate(addedURL);
                        this.fireAddedEvent(node);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    finally {
                        this.stopAssertTracking(addedURL, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startAssertTracking(URL addedURL, URL removedURL) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (addedURL != null && this._removeInProgress.contains(addedURL)) {
                    new RuntimeException("Assertion failure: FILE_ADDED event received while processing FILE_REMOVED for " + addedURL).printStackTrace();
                }
                if (removedURL != null && this._addInProgress.contains(removedURL)) {
                    new RuntimeException("Assertion failure: FILE_REMOVED event received while processing FILE_ADDED for " + removedURL).printStackTrace();
                }
                if (addedURL != null) {
                    this._addInProgress.add(addedURL);
                }
                if (removedURL != null) {
                    this._removeInProgress.add(removedURL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAssertTracking(URL addedURL, URL removedURL) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (addedURL != null) {
                    this._addInProgress.remove(addedURL);
                }
                if (removedURL != null) {
                    this._removeInProgress.remove(removedURL);
                }
            }
        }

        private void fireAddedEvent(Node addedNode) {
            UpdateMessage.fireChildAdded(this._workspace, addedNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireRemovedEvent(final URL removedURL, Node removedNode) {
            Observer assertionObserver = new Observer(){

                @Override
                public void update(Object object, UpdateMessage message) {
                    if (message.getOrigin() != this) {
                        new RuntimeException("Assertion failure: Observer update received on a node that has already been deleted from disk for " + removedURL).printStackTrace();
                    }
                }
            };
            try {
                removedNode.attach(assertionObserver);
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, this);
                updateMessage.getRemoveObjects().add(removedNode);
                this._workspace.notifyObservers(this._workspace, updateMessage);
            }
            finally {
                removedNode.detach(assertionObserver);
            }
        }

        private void fireRenamedEvents(URL oldURL, Node oldNode, Node newNode) {
            UpdateMessage event = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, oldNode);
            RenameMessage.setRenamedNode(event, oldNode);
            if (newNode != null) {
                event.getAddObjects().add(newNode);
                event.getRemoveObjects().add(oldNode);
            }
            event.getModifyObjects().add(oldURL);
            oldNode.notifyObservers(oldNode, event);
            event = new UpdateMessage(UpdateMessage.CHILD_RENAMED, this._workspace);
            RenameMessage.setRenamedNode(event, oldNode);
            if (newNode != null) {
                event.getAddObjects().add(newNode);
                event.getRemoveObjects().add(oldNode);
            }
            event.getModifyObjects().add(oldURL);
            event.getModifyObjects().add(this._workspace);
            this._workspace.notifyObservers(this._workspace, event);
        }
    }
}

