/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public abstract class ExtensionMigrator
implements Migrator {
    protected static final int SETTINGS = 0;
    protected boolean isSelected = true;
    protected static final String ROOT_TAG = "client-settings";
    private static final String KEY_TAG = "Key";
    private static final String VALUE_TAG = "Value";
    private static final String CLASS_ATTR = "class";
    private Object2Dom o2d;
    private Document document;
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    @Override
    public String getDescription(int category) {
        return null;
    }

    @Override
    public boolean canMigrate(int category, File sourceDir) {
        File file;
        return category == 0 && sourceDir != null && sourceDir.exists() && (file = this.getSourceFile(sourceDir)) != null && file.exists() && file.canRead();
    }

    @Override
    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this.isSelected = selected;
        }
    }

    @Override
    public boolean isSelected(int category) {
        return category == 0 ? this.isSelected : false;
    }

    @Override
    public String[] migrate(File sourceDir, File destDir) {
        if (this.isSelected(0) && sourceDir != null && sourceDir.exists()) {
            File srcFile = this.getSourceFile(sourceDir);
            File destFile = this.getDestFile(destDir);
            String extensionId = this.getExtensionID();
            if (ExtensionMigrator.isDebug()) {
                System.out.println("ExtensionMigrator migrating extension=" + this.getExtensionID() + " " + this.getClass().getName() + " filename=" + srcFile.toString());
            }
            if (extensionId == null) {
                new NullPointerException(this.getClass() + " returned null from getExtensionID()").printStackTrace();
                return null;
            }
            return this.copyPreferenceObject(srcFile, destFile, this.getSettingKeys(), this.getExtensionID());
        }
        return null;
    }

    public static String[] copyPreferenceObjectsAsIs(File srcFile, File destFile, List settingKeys, String extensionID) {
        ArrayList<String> errors = new ArrayList<String>();
        URL url = URLFactory.newFileURL((File)srcFile);
        Object2Dom o2d = Object2Dom.newInstance();
        Map map = null;
        try {
            if (ExtensionMigrator.isDebug()) {
                System.out.println("ExtensionMigrator.copyPreferenceObjectsAsIs extension=" + extensionID + " filename=" + srcFile.toString());
            }
            NullLogger logger = new NullLogger();
            o2d.setLogger(2, (Object2DomLogger)logger);
            ClassLoader classLoader = null;
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            if (registry != null) {
                classLoader = registry.getClassLoader(extensionID);
            }
            if (classLoader == null) {
                classLoader = ExtensionMigrator.class.getClassLoader();
            }
            map = (Map)o2d.toObject(url, classLoader);
        }
        catch (Exception e) {
            return new String[]{e.getLocalizedMessage()};
        }
        if (destFile != null && destFile.exists()) {
            try {
                destFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ClientSetting setting = ClientSetting.findOrCreate(extensionID);
        for (Object key : settingKeys) {
            try {
                if (!map.containsKey(key)) continue;
                setting.putData((String)key, (Copyable)map.get(key));
            }
            catch (Exception e) {
                errors.add(e.getLocalizedMessage());
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    public String[] copyPreferenceObject(File srcFile, File destFile, List settingKeys, String extensionID) {
        ArrayList<String> errors = new ArrayList<String>();
        URL url = URLFactory.newFileURL((File)srcFile);
        this.o2d = Object2Dom.newInstance();
        this.o2d.setDocumentURL(url);
        NullLogger logger = new NullLogger();
        this.o2d.setLogger(2, (Object2DomLogger)logger);
        this.o2d.setTemporaryIgnoreClassNames(this.getClassNamesToIgnoreErrorsOn());
        if (settingKeys != null && settingKeys.size() > 0) {
            this.parse(url);
        } else {
            try {
                ClassLoader classLoader = null;
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                if (registry != null) {
                    classLoader = registry.getClassLoader(extensionID);
                }
                if (classLoader == null) {
                    classLoader = ExtensionMigrator.class.getClassLoader();
                }
                this.map = (Map)this.o2d.toObject(url, classLoader);
            }
            catch (Exception e) {
                return new String[]{e.getLocalizedMessage()};
            }
        }
        if (destFile != null && destFile.exists()) {
            try {
                destFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ClientSetting setting = null;
        for (Object key : settingKeys) {
            try {
                AdjustedObject[] adjustedObjects;
                if (!this.map.containsKey(key)) continue;
                Object obj = this.getValue((String)key);
                for (AdjustedObject adjustedObject : adjustedObjects = this.adjustObject((String)key, obj)) {
                    if (this.addToProductPreferences()) {
                        HashStructureAdapter hsa = (HashStructureAdapter)adjustedObject.getAdjustedObject();
                        HashStructure hash = this.getHashStructure(hsa);
                        Preferences prefs = Preferences.getPreferences();
                        prefs.getProperties().putHashStructure(adjustedObject.getNewKey(), hash);
                        continue;
                    }
                    if (setting == null) {
                        setting = ClientSetting.findOrCreate(extensionID);
                    }
                    setting.putData(adjustedObject.getNewKey(), (Copyable)adjustedObject.getAdjustedObject());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.add(e.getLocalizedMessage());
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    protected ClassLoader getMigratorClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected AdjustedObject[] adjustObject(String inKey, Object inObject) {
        AdjustedObject[] adjustedObjects = new AdjustedObject[]{new AdjustedObject(inKey, inObject)};
        return adjustedObjects;
    }

    protected File getSourceFile(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (!file.exists()) {
            file = new File(sourceDir, "settings.xml");
        }
        return file;
    }

    protected File getSourceFileOrJDevExtrasFile(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (file.exists()) {
            return file;
        }
        file = !sourceDir.equals(MigrationManager.getMigrationManager().getSourceInstallationIfAvailable()) ? new File(sourceDir.getParent(), "o.jdeveloper") : new File(sourceDir, "o.jdeveloper");
        file = new File(file, "preferences.xml");
        return file;
    }

    protected File getDestFile(File destDir) {
        return new File(destDir, "preferences.xml");
    }

    protected boolean addToProductPreferences() {
        return false;
    }

    protected Collection<String> getClassNamesToIgnoreErrorsOn() {
        return Collections.emptyList();
    }

    protected String getRootTag(URL sourceURL) {
        return ROOT_TAG;
    }

    private HashStructure getHashStructure(HashStructureAdapter hsa) {
        try {
            Method m;
            Class<?> hsaClass = hsa.getClass().getSuperclass();
            try {
                m = hsaClass.getDeclaredMethod("getHashStructure", null);
            }
            catch (Exception ex) {
                Class<?> superHsaClass = hsaClass.getSuperclass();
                m = superHsaClass.getDeclaredMethod("getHashStructure", null);
            }
            m.setAccessible(true);
            HashStructure hash = (HashStructure)m.invoke((Object)hsa, (Object[])null);
            m.setAccessible(false);
            return hash;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void parse(URL sourceURL) {
        block4: {
            InputStream inputStream = null;
            DOMParser domParser = new DOMParser();
            try {
                domParser.setPreserveWhitespace(false);
                inputStream = sourceURL.openStream();
                domParser.parse(inputStream);
                this.document = domParser.getDocument();
                this.parseKeysIntoMap(sourceURL);
                inputStream.close();
            }
            catch (Exception e) {
                if (inputStream == null) break block4;
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    private void parseKeysIntoMap(URL sourceURL) {
        NodeList nodelist = this.document.getElementsByTagNameNS("*", this.getRootTag(sourceURL));
        Element rootNode = (Element)nodelist.item(0);
        nodelist = rootNode.getChildNodes();
        int numChildren = nodelist.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node n = nodelist.item(i);
            NodeList keyvalueNodes = n.getChildNodes();
            String key = null;
            Element valueNode = null;
            for (int j = 0; j < keyvalueNodes.getLength(); ++j) {
                Node jn;
                String localName;
                if (j == 0) {
                    key = null;
                    valueNode = null;
                }
                if ((localName = (jn = keyvalueNodes.item(j)).getLocalName()) != null) {
                    if (localName.equals(KEY_TAG)) {
                        key = jn.getTextContent();
                    } else if (localName.equals(VALUE_TAG)) {
                        valueNode = (Element)jn;
                    }
                }
                if (key != null && valueNode != null) break;
            }
            if (key == null || valueNode == null) continue;
            this.map.put(key, valueNode);
        }
    }

    protected Class loadClass(Element element) throws ClassNotFoundException {
        String className = element.getAttribute(CLASS_ATTR);
        if (className == null || className.length() == 0) {
            className = "java.lang.String";
        }
        ClassLoader loader = this.getMigratorClassLoader();
        return loader.loadClass(className);
    }

    private Object getValue(String key) {
        Object obj = this.map.get(key);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Element)) {
            return obj;
        }
        try {
            String attr = ((Element)obj).getAttribute(CLASS_ATTR);
            if (attr == null || attr.length() == 0) {
                attr = "java.lang.String";
            }
            Class c = this.loadClass((Element)obj);
            Object resolvedObject = this.o2d.toObject((Element)obj, c, true, c.getClassLoader(), true);
            this.map.put(key, resolvedObject);
            return resolvedObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static final boolean isDebug() {
        return Boolean.valueOf(System.getProperty("migrationDebug"));
    }

    private static boolean isVersionNumber(String testString) {
        for (int i = 0; i < testString.length(); ++i) {
            char c = testString.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    protected abstract List getSettingKeys();

    protected abstract String getExtensionID();

    protected File getIde1013ExtensionDirectory(File sourceDir) {
        File file = null;
        if (sourceDir.equals(MigrationManager.getMigrationManager().getSourceInstallationIfAvailable())) {
            File[] dirs;
            for (File dir : dirs = sourceDir.listFiles()) {
                String testSection;
                int idx = dir.toString().indexOf("oracle.ide.10.1.3");
                if (idx == -1 || !ExtensionMigrator.isVersionNumber(testSection = dir.toString().substring(idx + 16))) continue;
                file = dir;
                break;
            }
        }
        return file;
    }

    private static final class NullLogger
    implements Object2DomLogger {
        private NullLogger() {
        }

        public void logXMLParseException(XMLParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logSAXParseException(SAXParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logOtherException(Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logMessage(String mesg) {
            Assert.println((String)mesg);
        }

        public void logXMLDocument(XMLDocument document) {
        }
    }

    protected static final class AdjustedObject {
        private String _newKey;
        private Object _adjustedObject;

        public AdjustedObject(String newKey, Object adjustedObject) {
            this._newKey = newKey;
            this._adjustedObject = adjustedObject;
        }

        protected String getNewKey() {
            return this._newKey;
        }

        protected Object getAdjustedObject() {
            return this._adjustedObject;
        }
    }
}

