/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.javatools.util.Pair;

final class MyModel
extends AbstractTableModel
implements ChangeListener {
    private int _nSortedCol;
    private List _data = Collections.emptyList();

    MyModel() {
    }

    final void refresh() {
        this._data = new ArrayList(100);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        ArrayList global = ksm.getData();
        for (int i = 0; i < global.size(); ++i) {
            Pair p = (Pair)global.get(i);
            String name = "(global) " + (String)p.getFirst();
            String key = p.getSecond().toString();
            this._data.add(new Pair((Object)name, (Object)key));
        }
        HashMap localMaps = kso.getLocalKeyMaps();
        if (localMaps != null) {
            for (Map.Entry entry : localMaps.entrySet()) {
                Object key = entry.getKey();
                KeyStrokeMap ksm2 = (KeyStrokeMap)entry.getValue();
                ArrayList local = ksm2.getData();
                for (int j = 0; j < local.size(); ++j) {
                    Pair p = (Pair)local.get(j);
                    String sName = "(" + key + ") " + (String)p.getFirst();
                    String sKey = p.getSecond().toString();
                    this._data.add(new Pair((Object)sName, (Object)sKey));
                }
            }
        }
        this.sort();
    }

    @Override
    public final int getRowCount() {
        return this._data.size();
    }

    @Override
    public final int getColumnCount() {
        return 2;
    }

    @Override
    public final String getColumnName(int column) {
        if (column == 0) {
            return "Command";
        }
        return "Key";
    }

    @Override
    public final Object getValueAt(int row, int column) {
        Object ret = null;
        Pair pair = (Pair)this._data.get(row);
        switch (column) {
            case 0: {
                ret = pair.getFirst();
                break;
            }
            case 1: {
                ret = pair.getSecond();
            }
        }
        return ret;
    }

    final void sort(int nCol) {
        this._nSortedCol = nCol;
        this.sort();
    }

    private void sort() {
        Comparator comp = this._nSortedCol == 0 ? new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                String s1 = p1.getFirst() != null ? p1.getFirst().toString() : "";
                String s2 = p2.getFirst() != null ? p2.getFirst().toString() : "";
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                String s1 = p1.getSecond().toString();
                String s2 = p2.getSecond().toString();
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        };
        Collections.sort(this._data, comp);
        this.fireTableDataChanged();
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        this.refresh();
    }
}

